/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coldFusion.model.psi;

import com.intellij.coldFusion.model.CfmlScopesInfo;
import com.intellij.coldFusion.model.psi.CfmlJavaLoaderClassType;
import com.intellij.coldFusion.model.psi.CfmlPsiUtil;
import com.intellij.coldFusion.model.psi.CfmlVariable;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.RenameableFakePsiElement;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CfmlImplicitVariable
extends RenameableFakePsiElement
implements CfmlVariable {
    private final PsiComment myComment;
    private final String myName;
    private String myType;
    private final String myText;

    public CfmlImplicitVariable(@NotNull PsiFile containingFile, PsiComment comment, @NotNull String name) {
        if (containingFile == null) {
            CfmlImplicitVariable.$$$reportNull$$$0(0);
        }
        if (name == null) {
            CfmlImplicitVariable.$$$reportNull$$$0(1);
        }
        super((PsiElement)containingFile);
        this.myComment = comment;
        this.myText = name;
        this.myName = this.cutScope(this.myText);
    }

    private String cutScope(String name) {
        int i = name.indexOf(".");
        if (i != -1 && CfmlScopesInfo.getScopeByString(name.substring(0, i)) != 17) {
            return name.substring(i + 1);
        }
        return name;
    }

    public TextRange getTextRange() {
        return this.myComment.getTextRange();
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            CfmlImplicitVariable.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public PsiElement getNavigationElement() {
        PsiComment psiComment = this.myComment;
        if (psiComment == null) {
            CfmlImplicitVariable.$$$reportNull$$$0(3);
        }
        return psiComment;
    }

    public PsiElement getParent() {
        return this.myComment;
    }

    public String getTypeName() {
        return "Type name variable";
    }

    public String toString() {
        return "ImplicitVariable " + this.myName;
    }

    public void setType(String type) {
        this.myType = type;
    }

    @Override
    @Nullable
    public PsiType getPsiType() {
        if (this.myType == null) {
            return null;
        }
        try {
            if (this.myType.toLowerCase().equals("javaloader")) {
                return new CfmlJavaLoaderClassType(this.myComment, this.getProject());
            }
            return CfmlPsiUtil.getTypeByName(this.myType, this.getProject());
        }
        catch (IncorrectOperationException e) {
            return null;
        }
    }

    public Icon getIcon() {
        return PlatformIcons.VARIABLE_ICON;
    }

    @Override
    public boolean isTrulyDeclaration() {
        return true;
    }

    public PsiElement getNameIdentifier() {
        return this.getNavigationElement();
    }

    public String getText() {
        return this.myText;
    }

    @Override
    @NotNull
    public String getlookUpString() {
        String string = this.myText;
        if (string == null) {
            CfmlImplicitVariable.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/coldFusion/model/psi/CfmlImplicitVariable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/coldFusion/model/psi/CfmlImplicitVariable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigationElement";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getlookUpString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

