/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coldFusion.model.psi;

import com.intellij.coldFusion.model.CfmlScopesInfo;
import com.intellij.coldFusion.model.lexer.CfscriptTokenTypes;
import com.intellij.coldFusion.model.parsers.CfmlElementTypes;
import com.intellij.coldFusion.model.psi.CfmlArgumentNameReference;
import com.intellij.coldFusion.model.psi.CfmlCompositeElement;
import com.intellij.coldFusion.model.psi.CfmlExpression;
import com.intellij.coldFusion.model.psi.CfmlImplicitVariable;
import com.intellij.coldFusion.model.psi.CfmlReferenceExpression;
import com.intellij.coldFusion.model.psi.CfmlScopeProvider;
import com.intellij.coldFusion.model.psi.CfmlVariable;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.RenameableFakePsiElement;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CfmlAssignmentExpression
extends CfmlCompositeElement
implements CfmlExpression {
    private AssignedVariable myAssignedVariable;
    private boolean myVariableWasInitialized;

    public CfmlAssignmentExpression(@NotNull ASTNode node) {
        if (node == null) {
            CfmlAssignmentExpression.$$$reportNull$$$0(0);
        }
        super(node);
        this.myAssignedVariable = null;
        this.myVariableWasInitialized = false;
    }

    @Nullable
    private AssignedVariable createAssignedVariable() {
        CfmlReferenceExpression varElement = this.getAssignedVariableElement();
        if (varElement == null) {
            return null;
        }
        CfmlImplicitVariable var = this.getContainingFile().findImplicitVariable(varElement.getText());
        if (var != null && var.getTextRange().getStartOffset() < this.getTextRange().getStartOffset()) {
            return null;
        }
        return new AssignedVariable(this.findChildByType(CfscriptTokenTypes.VAR_KEYWORD) != null);
    }

    @Nullable
    public CfmlReferenceExpression getAssignedVariableElement() {
        if (this.getFirstChild() instanceof CfmlArgumentNameReference) {
            return (CfmlReferenceExpression)this.getFirstChild();
        }
        PsiElement element = this.findChildByType(CfmlElementTypes.REFERENCE_EXPRESSION);
        if (!(element instanceof CfmlReferenceExpression)) {
            return null;
        }
        return (CfmlReferenceExpression)element;
    }

    @Nullable
    private PsiType getAssignedVariableElementType() {
        CfmlExpression e = this.getRightHandExpr();
        return e != null ? e.getPsiType() : null;
    }

    @Nullable
    public CfmlExpression getRightHandExpr() {
        CfmlExpression[] expressions = (CfmlExpression[])this.findChildrenByClass(CfmlExpression.class);
        if (expressions.length != 2) {
            return null;
        }
        return expressions[1];
    }

    @Nullable
    public CfmlVariable getAssignedVariable() {
        if (!this.myVariableWasInitialized) {
            this.myVariableWasInitialized = true;
            this.myAssignedVariable = this.createAssignedVariable();
        }
        return this.myAssignedVariable;
    }

    @Override
    public PsiType getPsiType() {
        return this.getAssignedVariableElementType();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/coldFusion/model/psi/CfmlAssignmentExpression", "<init>"));
    }

    public class AssignedVariable
    extends RenameableFakePsiElement
    implements CfmlVariable,
    CfmlScopeProvider {
        private final boolean myIsDefinition;

        public AssignedVariable(boolean isDefinition) {
            super((PsiElement)CfmlAssignmentExpression.this.getContainingFile());
            this.myIsDefinition = isDefinition;
        }

        @Nullable
        public CfmlExpression getRightHandExpr() {
            return CfmlAssignmentExpression.this.getRightHandExpr();
        }

        @NotNull
        public String getName() {
            CfmlReferenceExpression expression = CfmlAssignmentExpression.this.getAssignedVariableElement();
            if (expression == null) {
                if ("" == null) {
                    AssignedVariable.$$$reportNull$$$0(0);
                }
                return "";
            }
            String variableName = expression.getText();
            String scopeName = this.getScopeName();
            if (scopeName != null && variableName != null && variableName.startsWith(scopeName + ".")) {
                String string = variableName.substring((scopeName + ".").length());
                if (string == null) {
                    AssignedVariable.$$$reportNull$$$0(1);
                }
                return string;
            }
            String string = variableName != null ? expression.getText() : "";
            if (string == null) {
                AssignedVariable.$$$reportNull$$$0(2);
            }
            return string;
        }

        public PsiElement setName(@NotNull @NonNls String name) throws IncorrectOperationException {
            if (name == null) {
                AssignedVariable.$$$reportNull$$$0(3);
            }
            return this;
        }

        @NotNull
        public PsiElement getNavigationElement() {
            CfmlReferenceExpression expression = CfmlAssignmentExpression.this.getAssignedVariableElement();
            assert (expression != null);
            PsiElement namedElement = expression.getReferenceNameElement();
            Object object = namedElement != null ? namedElement : this;
            if (object == null) {
                AssignedVariable.$$$reportNull$$$0(4);
            }
            return object;
        }

        public PsiElement getParent() {
            return CfmlAssignmentExpression.this.getAssignedVariableElement();
        }

        public String getTypeName() {
            return "Unknown type";
        }

        public Icon getIcon() {
            return PlatformIcons.VARIABLE_ICON;
        }

        @Override
        public PsiType getPsiType() {
            return CfmlAssignmentExpression.this.getAssignedVariableElementType();
        }

        public CfmlExpression getRightChildExpression() {
            CfmlExpression[] expressions = (CfmlExpression[])this.findChildrenByClass(CfmlExpression.class);
            if (expressions.length != 2) {
                return null;
            }
            return expressions[1];
        }

        public String toString() {
            return "AssignedVariable " + this.getName();
        }

        @Nullable
        private String getScopeName() {
            PsiElement scope;
            CfmlReferenceExpression expression = CfmlAssignmentExpression.this.getAssignedVariableElement();
            if (expression != null && (scope = expression.getScope()) != null) {
                return scope.getText();
            }
            return null;
        }

        @Override
        public int getProvidedScope() {
            return CfmlScopesInfo.getScopeByString(this.getScopeName());
        }

        @Override
        public boolean isTrulyDeclaration() {
            return this.myIsDefinition;
        }

        public PsiElement getNameIdentifier() {
            return this.getNavigationElement();
        }

        @Override
        @NotNull
        public String getlookUpString() {
            CfmlReferenceExpression expression = CfmlAssignmentExpression.this.getAssignedVariableElement();
            if (expression == null) {
                if ("" == null) {
                    AssignedVariable.$$$reportNull$$$0(5);
                }
                return "";
            }
            String string = expression.getText();
            if (string == null) {
                AssignedVariable.$$$reportNull$$$0(6);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/coldFusion/model/psi/CfmlAssignmentExpression$AssignedVariable";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/coldFusion/model/psi/CfmlAssignmentExpression$AssignedVariable";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNavigationElement";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getlookUpString";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setName";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

