/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coldFusion.injection;

import com.intellij.coldFusion.injection.CfmlPsiUtilsKt;
import com.intellij.coldFusion.model.lexer.CfmlTokenTypes;
import com.intellij.coldFusion.model.parsers.CfmlElementTypes;
import com.intellij.coldFusion.model.psi.CfmlAssignmentExpression;
import com.intellij.coldFusion.model.psi.CfmlExpression;
import com.intellij.coldFusion.model.psi.CfmlLeafPsiElement;
import com.intellij.coldFusion.model.psi.CfmlLiteralExpressionType;
import com.intellij.coldFusion.model.psi.CfmlReferenceExpression;
import com.intellij.coldFusion.model.psi.CfmlStringLiteralExpressionType;
import com.intellij.coldFusion.model.psi.impl.CfmlTagImpl;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.sql.psi.SqlLanguage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0007\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\n0\t0\bH\u0016J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\b2\u0006\u0010\f\u001a\u00020\nH\u0002J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\b2\u0006\u0010\f\u001a\u00020\nH\u0002J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\nH\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0013\u001a\u00020\nH\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0013\u001a\u00020\nH\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J6\u0010\u001e\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020 0\u001f0\b2\u0006\u0010!\u001a\u00020\n2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\n0\bH\u0002J@\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u001e\u0010'\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020 0\u001f0\b2\u0006\u0010(\u001a\u00020)2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/intellij/coldFusion/injection/CfmlSqlMultiHostInjector;", "Lcom/intellij/lang/injection/MultiHostInjector;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "CFQUERY_PARAM_DUMMY", "", "elementsToInjectIn", "", "Ljava/lang/Class;", "Lcom/intellij/psi/PsiElement;", "getCfIfTagOptionHosts", "context", "getCfQueryHosts", "getLanguagesToInject", "", "registrar", "Lcom/intellij/lang/injection/MultiHostRegistrar;", "getPrefixForCfIfTag", "cfIfTag", "getSuffixForCfIfTag", "getSuffixForCfmlExpression", "sibling", "Lcom/intellij/psi/impl/source/tree/LeafPsiElement;", "getSuffixForCfmlTag", "cfmlTag", "Lcom/intellij/coldFusion/model/psi/impl/CfmlTagImpl;", "getSuffixForSplitElement", "host", "Lcom/intellij/psi/PsiLanguageInjectionHost;", "mapSplittedHostsToTextRanges", "Lkotlin/Triple;", "Lcom/intellij/openapi/util/TextRange;", "head", "splittedElements", "registerInjection", "", "lang", "Lcom/intellij/lang/Language;", "injectionList", "finalContainingFile", "Lcom/intellij/psi/PsiFile;", "intellij.cfml"})
public final class CfmlSqlMultiHostInjector
implements MultiHostInjector {
    private final String CFQUERY_PARAM_DUMMY = "'parameter from <cfqueryparam>'";

    public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement context) {
        Intrinsics.checkParameterIsNotNull((Object)registrar, (String)"registrar");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (CfmlPsiUtilsKt.isCfIfTag(context) && CfmlPsiUtilsKt.isTagInsideCfQuery(context)) {
            List<PsiElement> cfIfTagOptionHosts = this.getCfIfTagOptionHosts(context);
            for (PsiElement host : cfIfTagOptionHosts) {
                SqlLanguage sqlLanguage = SqlLanguage.INSTANCE;
                Intrinsics.checkExpressionValueIsNotNull((Object)sqlLanguage, (String)"SqlLanguage.INSTANCE");
                Language language = (Language)sqlLanguage;
                List<Triple<PsiElement, PsiLanguageInjectionHost, TextRange>> list = this.mapSplittedHostsToTextRanges(context, CollectionsKt.listOf((Object)host));
                PsiFile psiFile = context.getContainingFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"context.containingFile");
                this.registerInjection(language, list, psiFile, registrar);
            }
        }
        if (CfmlPsiUtilsKt.isCfQueryTag(context)) {
            List<PsiElement> splitHosts = this.getCfQueryHosts(context);
            if (splitHosts.isEmpty()) {
                return;
            }
            SqlLanguage sqlLanguage = SqlLanguage.INSTANCE;
            Intrinsics.checkExpressionValueIsNotNull((Object)sqlLanguage, (String)"SqlLanguage.INSTANCE");
            Language language = (Language)sqlLanguage;
            List<Triple<PsiElement, PsiLanguageInjectionHost, TextRange>> list = this.mapSplittedHostsToTextRanges(context, splitHosts);
            PsiFile psiFile = context.getContainingFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"context.containingFile");
            this.registerInjection(language, list, psiFile, registrar);
        }
    }

    @NotNull
    public List<Class<? extends PsiElement>> elementsToInjectIn() {
        return CollectionsKt.listOf(CfmlTagImpl.class);
    }

    private final List<PsiElement> getCfQueryHosts(PsiElement context) {
        List filteredChildren = new ArrayList();
        PsiElement psiElement = context.getFirstChild();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"context.firstChild");
        Iterable $receiver$iv = CfmlPsiUtilsKt.traverse$default(psiElement, null, 1, null);
        for (Object element$iv : $receiver$iv) {
            PsiElement it = (PsiElement)element$iv;
            if (it instanceof CfmlLeafPsiElement) {
                filteredChildren.add(it);
            }
            if (!CfmlPsiUtilsKt.isCfIfTag(it)) continue;
            PsiElement psiElement2 = it;
            if (psiElement2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.coldFusion.model.psi.impl.CfmlTagImpl");
            }
            CfmlPsiUtilsKt.addNotNull(filteredChildren, CfmlPsiUtilsKt.getFirstCfIfValue((CfmlTagImpl)psiElement2));
        }
        return filteredChildren;
    }

    private final List<PsiElement> getCfIfTagOptionHosts(PsiElement context) {
        PsiElement it;
        Iterable $receiver$iv$iv;
        PsiElement psiElement = context.getFirstChild();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"context.firstChild");
        Iterable $receiver$iv = CfmlPsiUtilsKt.traverse$default(psiElement, null, 1, null);
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (PsiElement)element$iv$iv;
            if (!((CfmlPsiUtilsKt.isCfElseTag(it) || CfmlPsiUtilsKt.isCfElseIfTag(it)) && it.getNextSibling() instanceof CfmlLeafPsiElement)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = (PsiElement)item$iv$iv;
            Collection collection = destination$iv$iv;
            PsiElement psiElement2 = it.getNextSibling();
            collection.add(psiElement2);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Triple<PsiElement, PsiLanguageInjectionHost, TextRange>> mapSplittedHostsToTextRanges(PsiElement head, List<? extends PsiElement> splittedElements) {
        void $receiver$iv$iv;
        Iterable $receiver$iv = CollectionsKt.filterIsInstance((Iterable)splittedElements, PsiLanguageInjectionHost.class);
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void psiLanguageInjectionHost;
            PsiLanguageInjectionHost psiLanguageInjectionHost2 = (PsiLanguageInjectionHost)item$iv$iv;
            Collection collection = destination$iv$iv;
            Triple triple = new Triple((Object)head, (Object)psiLanguageInjectionHost, (Object)new TextRange(0, psiLanguageInjectionHost.getText().length()));
            collection.add(triple);
        }
        return (List)destination$iv$iv;
    }

    private final boolean registerInjection(Language lang, List<? extends Triple<? extends PsiElement, ? extends PsiLanguageInjectionHost, ? extends TextRange>> injectionList, PsiFile finalContainingFile, MultiHostRegistrar registrar) {
        boolean injectionStarted = false;
        for (Triple<? extends PsiElement, ? extends PsiLanguageInjectionHost, ? extends TextRange> triple : injectionList) {
            PsiElement head = (PsiElement)triple.component1();
            PsiLanguageInjectionHost host = (PsiLanguageInjectionHost)triple.component2();
            TextRange textRange = (TextRange)triple.component3();
            if (host.getContainingFile() != finalContainingFile || !host.isValidHost()) continue;
            if (!injectionStarted) {
                registrar.startInjecting(lang);
                injectionStarted = true;
            }
            if (CfmlPsiUtilsKt.isCfIfTag(head)) {
                registrar.addPlace(this.getPrefixForCfIfTag(head), this.getSuffixForCfIfTag(head), host, textRange);
                continue;
            }
            registrar.addPlace(null, this.getSuffixForSplitElement(host), host, textRange);
        }
        if (injectionStarted) {
            registrar.doneInjecting();
        }
        return injectionStarted;
    }

    private final String getSuffixForSplitElement(PsiLanguageInjectionHost host) {
        if (host instanceof CfmlLeafPsiElement && ((CfmlLeafPsiElement)host).getParent() instanceof CfmlTagImpl) {
            PsiElement sibling;
            PsiElement psiElement = ((CfmlLeafPsiElement)host).getNextSibling();
            if (psiElement == null) {
                return null;
            }
            PsiElement psiElement2 = sibling = psiElement;
            return psiElement2 instanceof CfmlTagImpl ? this.getSuffixForCfmlTag((CfmlTagImpl)sibling) : (psiElement2 instanceof LeafPsiElement ? this.getSuffixForCfmlExpression((LeafPsiElement)sibling) : null);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final String getSuffixForCfIfTag(PsiElement cfIfTag) {
        String string;
        Object object = cfIfTag.getNextSibling();
        if (object != null && (object = CfmlPsiUtilsKt.traverse$default(object, null, 1, null)) != null) {
            void $receiver$iv$iv;
            Object $receiver$iv;
            Object object2 = $receiver$iv = object;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                Object object3;
                void it;
                PsiElement psiElement = (PsiElement)item$iv$iv;
                Collection collection = destination$iv$iv;
                if (CfmlPsiUtilsKt.isCfIfTag((PsiElement)it)) {
                    void v1 = it;
                    if (v1 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type com.intellij.coldFusion.model.psi.impl.CfmlTagImpl");
                    }
                    object3 = CfmlPsiUtilsKt.getFirstCfIfValue((CfmlTagImpl)v1);
                } else {
                    object3 = CfmlPsiUtilsKt.isCfQueryParamTag((PsiElement)it) ? this.CFQUERY_PARAM_DUMMY : it.getText();
                }
                Object object4 = object3;
                collection.add(object4);
            }
            string = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), null, null, null, (int)0, null, null, (int)63, null);
        } else {
            string = null;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final String getPrefixForCfIfTag(PsiElement cfIfTag) {
        void $receiver$iv$iv;
        Iterable<PsiElement> $receiver$iv;
        PsiElement psiElement = cfIfTag.getParent();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"cfIfTag.parent");
        PsiElement psiElement2 = psiElement.getFirstChild();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"cfIfTag.parent.firstChild");
        Iterable<PsiElement> iterable = $receiver$iv = CfmlPsiUtilsKt.traverse(psiElement2, cfIfTag);
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            Object object;
            void it;
            PsiElement psiElement3 = (PsiElement)item$iv$iv;
            Collection collection = destination$iv$iv;
            if (CfmlPsiUtilsKt.isCfIfTag((PsiElement)it)) {
                void v2 = it;
                if (v2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.coldFusion.model.psi.impl.CfmlTagImpl");
                }
                object = CfmlPsiUtilsKt.getFirstCfIfValue((CfmlTagImpl)v2);
            } else {
                object = CfmlPsiUtilsKt.isCfQueryParamTag((PsiElement)it) ? this.CFQUERY_PARAM_DUMMY : (it instanceof CfmlLeafPsiElement ? ((CfmlLeafPsiElement)it).getText() : "");
            }
            Object object2 = object;
            collection.add(object2);
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
    }

    private final String getSuffixForCfmlExpression(LeafPsiElement sibling) {
        ASTNode aSTNode = sibling.getNode();
        Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"sibling.node");
        if (Intrinsics.areEqual((Object)aSTNode.getElementType(), (Object)CfmlTokenTypes.START_EXPRESSION) && sibling.getNextSibling() != null && sibling.getNextSibling() instanceof CfmlReferenceExpression) {
            PsiElement psiElement = sibling.getNextSibling();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"sibling.nextSibling");
            if (psiElement.getNextSibling() != null) {
                PsiElement psiElement2 = sibling.getNextSibling();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"sibling.nextSibling");
                PsiElement psiElement3 = psiElement2.getNextSibling();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"sibling.nextSibling.nextSibling");
                ASTNode aSTNode2 = psiElement3.getNode();
                Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode2, (String)"sibling.nextSibling.nextSibling.node");
                if (Intrinsics.areEqual((Object)aSTNode2.getElementType(), (Object)CfmlTokenTypes.END_EXPRESSION)) {
                    PsiElement psiElement4 = sibling.getNextSibling();
                    if (psiElement4 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type com.intellij.coldFusion.model.psi.CfmlReferenceExpression");
                    }
                    CfmlReferenceExpression cfmlReferenceExpression = (CfmlReferenceExpression)psiElement4;
                    PsiElement psiElement5 = cfmlReferenceExpression.resolve();
                    if (psiElement5 != null && psiElement5 instanceof CfmlAssignmentExpression.AssignedVariable) {
                        CfmlExpression cfmlExpression;
                        CfmlExpression rightHandExpr = ((CfmlAssignmentExpression.AssignedVariable)psiElement5).getRightHandExpr();
                        if (rightHandExpr instanceof CfmlLiteralExpressionType) {
                            ASTNode aSTNode3 = rightHandExpr.getNode();
                            if (Intrinsics.areEqual((Object)(aSTNode3 != null ? aSTNode3.getElementType() : null), (Object)((Object)CfmlElementTypes.INTEGER_LITERAL))) {
                                return rightHandExpr.getText();
                            }
                        }
                        if (((cfmlExpression = rightHandExpr) != null && (cfmlExpression = cfmlExpression.getNode()) != null ? cfmlExpression.getElementType() : null) instanceof CfmlStringLiteralExpressionType) {
                            return rightHandExpr.getText();
                        }
                    }
                    return "'parameter from expression'";
                }
            }
        }
        return null;
    }

    private final String getSuffixForCfmlTag(CfmlTagImpl cfmlTag) {
        return CfmlPsiUtilsKt.isCfQueryParamTag(cfmlTag) ? this.CFQUERY_PARAM_DUMMY : null;
    }

    public CfmlSqlMultiHostInjector(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.CFQUERY_PARAM_DUMMY = "'parameter from <cfqueryparam>'";
    }
}

