/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.cloud.stream.model;

import com.intellij.jam.JamService;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.spring.boot.cloud.stream.library.SpringCloudStreamLibraryUtil;
import com.intellij.spring.boot.cloud.stream.model.jam.EnableBinding;
import com.intellij.spring.boot.cloud.stream.model.jam.MessageChannel;
import com.intellij.spring.contexts.model.LocalAnnotationModel;
import com.intellij.spring.contexts.model.LocalModel;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.custom.CustomLocalComponentsDiscoverer;
import com.intellij.spring.model.jam.stereotype.CustomSpringComponent;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SpringCloudStreamBindingsDiscoverer
extends CustomLocalComponentsDiscoverer {
    @NotNull
    public Collection<CommonSpringBean> getCustomComponents(@NotNull LocalModel localModel) {
        Module module;
        if (localModel == null) {
            SpringCloudStreamBindingsDiscoverer.$$$reportNull$$$0(0);
        }
        if ((module = localModel.getModule()) == null || module.isDisposed() || !(localModel instanceof LocalAnnotationModel)) {
            List<CommonSpringBean> list = Collections.emptyList();
            if (list == null) {
                SpringCloudStreamBindingsDiscoverer.$$$reportNull$$$0(1);
            }
            return list;
        }
        if (!SpringCommonUtils.hasSpringFacet((Module)module) || !SpringCloudStreamLibraryUtil.hasSpringCloudStream(module)) {
            List<CommonSpringBean> list = Collections.emptyList();
            if (list == null) {
                SpringCloudStreamBindingsDiscoverer.$$$reportNull$$$0(2);
            }
            return list;
        }
        PsiClass psiClass = (PsiClass)((LocalAnnotationModel)localModel).getConfig();
        EnableBinding enableBinding = (EnableBinding)EnableBinding.CLASS_META.getJamElement((PsiModifierListOwner)psiClass);
        if (enableBinding == null) {
            List<CommonSpringBean> list = Collections.emptyList();
            if (list == null) {
                SpringCloudStreamBindingsDiscoverer.$$$reportNull$$$0(3);
            }
            return list;
        }
        SmartList beans = new SmartList();
        for (PsiClass bindingClass : enableBinding.getValue()) {
            CustomSpringComponent bean = new CustomSpringComponent(null, bindingClass);
            beans.add(bean);
            beans.addAll(SpringCloudStreamBindingsDiscoverer.getMessageChannels(bindingClass));
        }
        SmartList smartList = beans;
        if (smartList == null) {
            SpringCloudStreamBindingsDiscoverer.$$$reportNull$$$0(4);
        }
        return smartList;
    }

    @NotNull
    private static List<MessageChannel> getMessageChannels(@NotNull PsiClass bindingClass) {
        if (bindingClass == null) {
            SpringCloudStreamBindingsDiscoverer.$$$reportNull$$$0(5);
        }
        List list = JamService.getJamService((Project)bindingClass.getProject()).getAnnotatedMembersList(bindingClass, MessageChannel.JAM_KEY, false, true, false, true);
        if (list == null) {
            SpringCloudStreamBindingsDiscoverer.$$$reportNull$$$0(6);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localModel";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/cloud/stream/model/SpringCloudStreamBindingsDiscoverer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bindingClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/cloud/stream/model/SpringCloudStreamBindingsDiscoverer";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomComponents";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessageChannels";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCustomComponents";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getMessageChannels";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

