/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.guice.inspections;

import com.intellij.guice.GuiceBundle;
import com.intellij.guice.inspections.BaseInspection;
import com.intellij.guice.inspections.BaseInspectionVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;

public class InvalidRequestParametersInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = GuiceBundle.message("invalid.request.parameters.problem.descriptor", new Object[0]);
        if (string == null) {
            InvalidRequestParametersInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/guice/inspections/InvalidRequestParametersInspection", "buildErrorString"));
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        public void visitAnnotation(PsiAnnotation annotation) {
            super.visitAnnotation(annotation);
            if (!"com.google.inject.servlet.RequestParameters".equals(annotation.getQualifiedName())) {
                return;
            }
            PsiVariable variable = (PsiVariable)PsiTreeUtil.getParentOfType((PsiElement)annotation, PsiVariable.class);
            if (variable == null) {
                return;
            }
            PsiType type = variable.getType();
            String typeText = type.getCanonicalText();
            if ((typeText = typeText.replaceAll(" ", "")).equals("java.util.Map<java.lang.String,java.lang.String[]>")) {
                return;
            }
            this.registerError((PsiElement)annotation, new Object[0]);
        }
    }
}

