/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.guice.inspections;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.guice.GuiceBundle;
import com.intellij.guice.inspections.BaseInspectionVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class BaseInspection
extends LocalInspectionTool {
    private String m_shortName = null;
    @NonNls
    private static final String INSPECTION = "Inspection";

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        if ("Guice Inspections" == null) {
            BaseInspection.$$$reportNull$$$0(0);
        }
        return "Guice Inspections";
    }

    @NotNull
    public String getShortName() {
        if (this.m_shortName != null) {
            String string = this.m_shortName;
            if (string == null) {
                BaseInspection.$$$reportNull$$$0(1);
            }
            return string;
        }
        Class<?> aClass = ((Object)((Object)this)).getClass();
        String name = aClass.getName();
        String string = this.m_shortName = name.substring(name.lastIndexOf(46) + 1, name.length() - INSPECTION.length());
        if (string == null) {
            BaseInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    protected abstract String buildErrorString(Object ... var1);

    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return false;
    }

    private String getPropertyPrefixForInspection() {
        String shortName = this.getShortName();
        return BaseInspection.getPrefix(shortName);
    }

    public static String getPrefix(String shortName) {
        int length = shortName.length();
        StringBuilder buffer = new StringBuilder(length + 10);
        buffer.append(Character.toLowerCase(shortName.charAt(0)));
        for (int i = 1; i < length; ++i) {
            char c = shortName.charAt(i);
            if (Character.isUpperCase(c)) {
                buffer.append('.');
                buffer.append(Character.toLowerCase(c));
                continue;
            }
            buffer.append(c);
        }
        return buffer.toString();
    }

    @NotNull
    public String getDisplayName() {
        String displayNameSuffix = ".display.name";
        String string = GuiceBundle.message(this.getPropertyPrefixForInspection() + ".display.name", new Object[0]);
        if (string == null) {
            BaseInspection.$$$reportNull$$$0(3);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    public abstract BaseInspectionVisitor buildVisitor();

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            BaseInspection.$$$reportNull$$$0(4);
        }
        BaseInspectionVisitor visitor = this.buildVisitor();
        visitor.setProblemsHolder(holder);
        visitor.setOnTheFly(isOnTheFly);
        visitor.setInspection(this);
        BaseInspectionVisitor baseInspectionVisitor = visitor;
        if (baseInspectionVisitor == null) {
            BaseInspection.$$$reportNull$$$0(5);
        }
        return baseInspectionVisitor;
    }

    public LocalQuickFix buildFix(PsiElement location, Object[] infos) {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/guice/inspections/BaseInspection";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/guice/inspections/BaseInspection";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

