/*
 * Decompiled with CFR 0.152.
 */
package com.google.archivepatcher.generator;

import com.google.archivepatcher.generator.MinimalCentralDirectoryMetadata;
import com.google.archivepatcher.generator.MinimalZipEntry;
import com.google.archivepatcher.generator.MinimalZipParser;
import com.google.archivepatcher.shared.RandomAccessFileInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.zip.ZipException;

public class MinimalZipArchive {
    private static final Comparator<MinimalZipEntry> LOCAL_ENTRY_OFFSET_COMAPRATOR = new Comparator<MinimalZipEntry>(){

        @Override
        public int compare(MinimalZipEntry o1, MinimalZipEntry o2) {
            return Long.compare(o1.getFileOffsetOfLocalEntry(), o2.getFileOffsetOfLocalEntry());
        }
    };

    public static List<MinimalZipEntry> listEntries(File file) throws IOException {
        try (RandomAccessFileInputStream in = new RandomAccessFileInputStream(file);){
            List<MinimalZipEntry> list = MinimalZipArchive.listEntriesInternal(in);
            return list;
        }
    }

    private static List<MinimalZipEntry> listEntriesInternal(RandomAccessFileInputStream in) throws IOException {
        int x;
        long offsetOfEocd = MinimalZipParser.locateStartOfEocd(in, 32768);
        if (offsetOfEocd == -1L) {
            throw new ZipException("EOCD record not found in last 32k of archive, giving up");
        }
        in.setRange(offsetOfEocd, in.length() - offsetOfEocd);
        MinimalCentralDirectoryMetadata centralDirectoryMetadata = MinimalZipParser.parseEocd((InputStream)in);
        in.setRange(centralDirectoryMetadata.getOffsetOfCentralDirectory(), centralDirectoryMetadata.getLengthOfCentralDirectory());
        ArrayList<MinimalZipEntry> minimalZipEntries = new ArrayList<MinimalZipEntry>(centralDirectoryMetadata.getNumEntriesInCentralDirectory());
        for (x = 0; x < centralDirectoryMetadata.getNumEntriesInCentralDirectory(); ++x) {
            minimalZipEntries.add(MinimalZipParser.parseCentralDirectoryEntry((InputStream)in));
        }
        Collections.sort(minimalZipEntries, LOCAL_ENTRY_OFFSET_COMAPRATOR);
        for (x = 0; x < minimalZipEntries.size(); ++x) {
            MinimalZipEntry entry = (MinimalZipEntry)minimalZipEntries.get(x);
            long offsetOfNextEntry = x < minimalZipEntries.size() - 1 ? ((MinimalZipEntry)minimalZipEntries.get(x + 1)).getFileOffsetOfLocalEntry() : centralDirectoryMetadata.getOffsetOfCentralDirectory();
            long rangeLength = offsetOfNextEntry - entry.getFileOffsetOfLocalEntry();
            in.setRange(entry.getFileOffsetOfLocalEntry(), rangeLength);
            long relativeDataOffset = MinimalZipParser.parseLocalEntryAndGetCompressedDataOffset((InputStream)in);
            entry.setFileOffsetOfCompressedData(entry.getFileOffsetOfLocalEntry() + relativeDataOffset);
        }
        return minimalZipEntries;
    }
}

