/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.model.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.xml.TagNameReference;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.SmartList;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.ResolvingConverter;
import com.intellij.util.xml.impl.GenericDomValueReference;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.converters.MavenSmartConverter;
import org.jetbrains.idea.maven.dom.references.MavenPropertyCompletionContributor;

public class MavenSmartCompletionContributor
extends CompletionContributor {
    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            MavenSmartCompletionContributor.$$$reportNull$$$0(0);
        }
        if (result == null) {
            MavenSmartCompletionContributor.$$$reportNull$$$0(1);
        }
        if (parameters.getCompletionType() != CompletionType.SMART) {
            return;
        }
        Collection<?> variants = MavenSmartCompletionContributor.getVariants(parameters);
        MavenPropertyCompletionContributor.addVariants(variants, result);
    }

    @NotNull
    private static Collection<?> getVariants(CompletionParameters parameters) {
        if (!MavenDomUtil.isMavenFile(parameters.getOriginalFile())) {
            List list = Collections.emptyList();
            if (list == null) {
                MavenSmartCompletionContributor.$$$reportNull$$$0(2);
            }
            return list;
        }
        SmartList result = new SmartList();
        for (PsiReference each : MavenSmartCompletionContributor.getReferences(parameters)) {
            if (each instanceof TagNameReference) continue;
            if (each instanceof GenericDomValueReference) {
                GenericDomValueReference reference = (GenericDomValueReference)each;
                Converter converter = reference.getConverter();
                if (converter instanceof MavenSmartConverter) {
                    Collection variants = ((MavenSmartConverter)converter).getSmartVariants(reference.getConvertContext());
                    if (converter instanceof ResolvingConverter) {
                        MavenSmartCompletionContributor.addVariants((ResolvingConverter)converter, variants, (Collection)result);
                        continue;
                    }
                    result.addAll(variants);
                    continue;
                }
                if (!(converter instanceof ResolvingConverter)) continue;
                ResolvingConverter resolvingConverter = (ResolvingConverter)converter;
                Collection variants = resolvingConverter.getVariants(reference.getConvertContext());
                MavenSmartCompletionContributor.addVariants(resolvingConverter, variants, (Collection)result);
                continue;
            }
            Collections.addAll(result, each.getVariants());
        }
        SmartList smartList = result;
        if (smartList == null) {
            MavenSmartCompletionContributor.$$$reportNull$$$0(3);
        }
        return smartList;
    }

    private static <T> void addVariants(ResolvingConverter<T> converter, Collection<T> variants, Collection result) {
        for (T variant : variants) {
            LookupElement lookupElement = converter.createLookupElement(variant);
            if (lookupElement != null) {
                result.add(lookupElement);
                continue;
            }
            result.add(variant);
        }
    }

    @NotNull
    private static PsiReference[] getReferences(CompletionParameters parameters) {
        PsiElement psiElement = parameters.getPosition().getParent();
        PsiReference[] psiReferenceArray = psiElement instanceof XmlText ? psiElement.getParent().getReferences() : psiElement.getReferences();
        if (psiReferenceArray == null) {
            MavenSmartCompletionContributor.$$$reportNull$$$0(4);
        }
        return psiReferenceArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/dom/model/completion/MavenSmartCompletionContributor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/dom/model/completion/MavenSmartCompletionContributor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fillCompletionVariants";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

