/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.converters;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.ResolvingConverter;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenDomBundle;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.converters.MavenArtifactCoordinatesHelper;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.dom.references.MavenPathReferenceConverter;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenUtil;

public class MavenParentRelativePathConverter
extends ResolvingConverter<PsiFile>
implements CustomReferenceConverter {
    public PsiFile fromString(@Nullable @NonNls String s, ConvertContext context) {
        if (StringUtil.isEmptyOrSpaces((String)s)) {
            return null;
        }
        VirtualFile contextFile = context.getFile().getVirtualFile();
        if (contextFile == null) {
            return null;
        }
        VirtualFile f = contextFile.getParent().findFileByRelativePath(s);
        if (f == null) {
            return null;
        }
        if (f.isDirectory()) {
            f = f.findChild("pom.xml");
        }
        if (f == null) {
            return null;
        }
        return context.getPsiManager().findFile(f);
    }

    public String toString(@Nullable PsiFile f, ConvertContext context) {
        if (f == null) {
            return null;
        }
        VirtualFile currentFile = context.getFile().getOriginalFile().getVirtualFile();
        if (currentFile == null) {
            return null;
        }
        return MavenDomUtil.calcRelativePath(currentFile.getParent(), f.getVirtualFile());
    }

    @NotNull
    public Collection<PsiFile> getVariants(ConvertContext context) {
        ArrayList<PsiFile> result = new ArrayList<PsiFile>();
        PsiFile currentFile = context.getFile().getOriginalFile();
        for (DomFileElement<MavenDomProjectModel> each : MavenDomUtil.collectProjectModels(context.getFile().getProject())) {
            XmlFile file = each.getOriginalFile();
            if (file == currentFile) continue;
            result.add((PsiFile)file);
        }
        ArrayList<PsiFile> arrayList = result;
        if (arrayList == null) {
            MavenParentRelativePathConverter.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    public LocalQuickFix[] getQuickFixes(ConvertContext context) {
        return (LocalQuickFix[])ArrayUtil.append((Object[])super.getQuickFixes(context), (Object)new RelativePathFix(context));
    }

    @NotNull
    public PsiReference[] createReferences(GenericDomValue genericDomValue, PsiElement element, ConvertContext context) {
        Project project = element.getProject();
        Condition condition = item -> item.isDirectory() || MavenUtil.isPomFile(project, item.getVirtualFile());
        PsiReference[] psiReferenceArray = new MavenPathReferenceConverter((Condition<PsiFileSystemItem>)condition).createReferences(genericDomValue, element, context);
        if (psiReferenceArray == null) {
            MavenParentRelativePathConverter.$$$reportNull$$$0(1);
        }
        return psiReferenceArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/idea/maven/dom/converters/MavenParentRelativePathConverter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createReferences";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class RelativePathFix
    implements LocalQuickFix {
        private final ConvertContext myContext;

        RelativePathFix(ConvertContext context) {
            this.myContext = context;
        }

        @NotNull
        public String getName() {
            String string = MavenDomBundle.message("fix.parent.path", new Object[0]);
            if (string == null) {
                RelativePathFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = MavenDomBundle.message("inspection.group", new Object[0]);
            if (string == null) {
                RelativePathFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                RelativePathFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                RelativePathFix.$$$reportNull$$$0(3);
            }
            GenericDomValue el = (GenericDomValue)this.myContext.getInvocationElement();
            MavenId id = MavenArtifactCoordinatesHelper.getId(this.myContext);
            MavenProjectsManager manager = MavenProjectsManager.getInstance(project);
            MavenProject parentFile = manager.findProject(id);
            if (parentFile != null) {
                VirtualFile currentFile = this.myContext.getFile().getVirtualFile();
                el.setStringValue(MavenDomUtil.calcRelativePath(currentFile.getParent(), parentFile.getFile()));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/idea/maven/dom/converters/MavenParentRelativePathConverter$RelativePathFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/idea/maven/dom/converters/MavenParentRelativePathConverter$RelativePathFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

