/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom;

import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomService;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.reflect.DomCollectionChildDescription;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenDomElement;
import org.jetbrains.idea.maven.dom.model.MavenDomDependencies;
import org.jetbrains.idea.maven.dom.model.MavenDomDependency;
import org.jetbrains.idea.maven.dom.model.MavenDomParent;
import org.jetbrains.idea.maven.dom.model.MavenDomProfiles;
import org.jetbrains.idea.maven.dom.model.MavenDomProfilesModel;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.dom.model.MavenDomProperties;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenResource;
import org.jetbrains.idea.maven.plugins.groovy.MavenGroovyPomCompletionContributor;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenUtil;

public class MavenDomUtil {
    private static final Key<Pair<Long, Set<VirtualFile>>> FILTERED_RESOURCES_ROOTS_KEY = Key.create((String)"MavenDomUtil.FILTERED_RESOURCES_ROOTS");
    private static final Set<String> SUBTAGS_IN_SETTINGS_FILE = ContainerUtil.newHashSet((Object[])new String[]{"localRepository", "interactiveMode", "usePluginRegistry", "offline", "pluginGroups", "servers", "mirrors", "proxies", "profiles", "activeProfiles"});
    private static final Pattern XML_TAG_NAME_PATTERN = Pattern.compile("(\\S*)\\[(\\d*)\\]\\z");

    public static boolean isMavenFile(PsiFile file) {
        return MavenDomUtil.isProjectFile(file) || MavenDomUtil.isProfilesFile(file) || MavenDomUtil.isSettingsFile(file);
    }

    public static boolean isProjectFile(PsiFile file) {
        if (!(file instanceof XmlFile)) {
            return false;
        }
        XmlTag rootTag = ((XmlFile)file).getRootTag();
        if (rootTag == null || !"project".equals(rootTag.getName())) {
            return false;
        }
        String xmlns = rootTag.getAttributeValue("xmlns");
        if (xmlns != null && xmlns.startsWith("http://maven.apache.org/POM/")) {
            return true;
        }
        return MavenUtil.isPomFileName(file.getName());
    }

    public static boolean isProfilesFile(PsiFile file) {
        if (!(file instanceof XmlFile)) {
            return false;
        }
        return "profiles.xml".equals(file.getName());
    }

    public static boolean isSettingsFile(PsiFile file) {
        if (!(file instanceof XmlFile)) {
            return false;
        }
        XmlTag rootTag = ((XmlFile)file).getRootTag();
        if (rootTag == null || !"settings".equals(rootTag.getName())) {
            return false;
        }
        String xmlns = rootTag.getAttributeValue("xmlns");
        if (xmlns != null) {
            return xmlns.contains("maven");
        }
        boolean hasTag = false;
        for (PsiElement e = rootTag.getFirstChild(); e != null; e = e.getNextSibling()) {
            if (!(e instanceof XmlTag)) continue;
            if (SUBTAGS_IN_SETTINGS_FILE.contains(((XmlTag)e).getName())) {
                return true;
            }
            hasTag = true;
        }
        return !hasTag;
    }

    public static boolean isMavenFile(PsiElement element) {
        return MavenDomUtil.isMavenFile(element.getContainingFile());
    }

    @Nullable
    public static Module findContainingMavenizedModule(@NotNull PsiFile psiFile) {
        VirtualFile file;
        if (psiFile == null) {
            MavenDomUtil.$$$reportNull$$$0(0);
        }
        if ((file = psiFile.getVirtualFile()) == null) {
            return null;
        }
        Project project = psiFile.getProject();
        MavenProjectsManager manager = MavenProjectsManager.getInstance(project);
        if (!manager.isMavenizedProject()) {
            return null;
        }
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)project).getFileIndex();
        Module module = index.getModuleForFile(file);
        if (module == null || !manager.isMavenizedModule(module)) {
            return null;
        }
        return module;
    }

    public static boolean isMavenProperty(PsiElement target) {
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)target, XmlTag.class, (boolean)false);
        if (tag == null) {
            return false;
        }
        return DomUtil.findDomElement((PsiElement)tag, MavenDomProperties.class) != null;
    }

    public static String calcRelativePath(VirtualFile parent, VirtualFile child) {
        String result = FileUtil.getRelativePath((String)parent.getPath(), (String)child.getPath(), (char)'/');
        if (result == null) {
            MavenLog.LOG.warn("cannot calculate relative path for\nparent: " + parent + "\nchild: " + child);
            result = child.getPath();
        }
        return FileUtil.toSystemIndependentName((String)result);
    }

    public static MavenDomParent updateMavenParent(MavenDomProjectModel mavenModel, MavenProject parentProject) {
        MavenDomParent result = mavenModel.getMavenParent();
        VirtualFile pomFile = DomUtil.getFile((DomElement)mavenModel).getVirtualFile();
        Project project = mavenModel.getManager().getProject();
        MavenId parentId = parentProject.getMavenId();
        result.getGroupId().setStringValue(parentId.getGroupId());
        result.getArtifactId().setStringValue(parentId.getArtifactId());
        result.getVersion().setStringValue(parentId.getVersion());
        if (!Comparing.equal((Object)pomFile.getParent().getParent(), (Object)parentProject.getDirectoryFile()) || !FileUtil.namesEqual((String)"pom.xml", (String)parentProject.getFile().getName())) {
            result.getRelativePath().setValue((Object)PsiManager.getInstance((Project)project).findFile(parentProject.getFile()));
        }
        return result;
    }

    public static <T> T getImmediateParent(ConvertContext context, Class<T> clazz) {
        DomElement parentElement = context.getInvocationElement().getParent();
        return (T)(clazz.isInstance(parentElement) ? parentElement : null);
    }

    @Nullable
    public static VirtualFile getVirtualFile(@NotNull DomElement element) {
        if (element == null) {
            MavenDomUtil.$$$reportNull$$$0(1);
        }
        XmlFile psiFile = DomUtil.getFile((DomElement)element);
        return MavenDomUtil.getVirtualFile((PsiFile)psiFile);
    }

    @Nullable
    public static VirtualFile getVirtualFile(@NotNull PsiElement element) {
        if (element == null) {
            MavenDomUtil.$$$reportNull$$$0(2);
        }
        PsiFile psiFile = element.getContainingFile();
        return MavenDomUtil.getVirtualFile(psiFile);
    }

    @Nullable
    private static VirtualFile getVirtualFile(PsiFile psiFile) {
        if (psiFile == null) {
            return null;
        }
        VirtualFile virtualFile = (psiFile = psiFile.getOriginalFile()).getVirtualFile();
        if (virtualFile instanceof LightVirtualFile) {
            virtualFile = (VirtualFile)ObjectUtils.chooseNotNull((Object)psiFile.getUserData(MavenGroovyPomCompletionContributor.ORIGINAL_POM_FILE), (Object)virtualFile);
        }
        return virtualFile;
    }

    @Nullable
    public static MavenProject findProject(@NotNull MavenDomProjectModel projectDom) {
        XmlElement element;
        if (projectDom == null) {
            MavenDomUtil.$$$reportNull$$$0(3);
        }
        if ((element = projectDom.getXmlElement()) == null) {
            return null;
        }
        VirtualFile file = MavenDomUtil.getVirtualFile((PsiElement)element);
        if (file == null) {
            return null;
        }
        MavenProjectsManager manager = MavenProjectsManager.getInstance(element.getProject());
        return manager.findProject(file);
    }

    @Nullable
    public static MavenProject findContainingProject(@NotNull DomElement element) {
        XmlElement psi;
        if (element == null) {
            MavenDomUtil.$$$reportNull$$$0(4);
        }
        return (psi = element.getXmlElement()) == null ? null : MavenDomUtil.findContainingProject((PsiElement)psi);
    }

    @Nullable
    public static MavenProject findContainingProject(@NotNull PsiElement element) {
        VirtualFile file;
        if (element == null) {
            MavenDomUtil.$$$reportNull$$$0(5);
        }
        if ((file = MavenDomUtil.getVirtualFile(element)) == null) {
            return null;
        }
        MavenProjectsManager manager = MavenProjectsManager.getInstance(element.getProject());
        return manager.findContainingProject(file);
    }

    @Nullable
    public static MavenDomProjectModel getMavenDomProjectModel(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            MavenDomUtil.$$$reportNull$$$0(6);
        }
        if (file == null) {
            MavenDomUtil.$$$reportNull$$$0(7);
        }
        return MavenDomUtil.getMavenDomModel(project, file, MavenDomProjectModel.class);
    }

    @Nullable
    public static MavenDomProfiles getMavenDomProfilesModel(@NotNull Project project, @NotNull VirtualFile file) {
        MavenDomProfilesModel model;
        if (project == null) {
            MavenDomUtil.$$$reportNull$$$0(8);
        }
        if (file == null) {
            MavenDomUtil.$$$reportNull$$$0(9);
        }
        if ((model = MavenDomUtil.getMavenDomModel(project, file, MavenDomProfilesModel.class)) != null) {
            return model.getProfiles();
        }
        return MavenDomUtil.getMavenDomModel(project, file, MavenDomProfiles.class);
    }

    @Nullable
    public static <T extends MavenDomElement> T getMavenDomModel(@NotNull Project project, @NotNull VirtualFile file, @NotNull Class<T> clazz) {
        if (project == null) {
            MavenDomUtil.$$$reportNull$$$0(10);
        }
        if (file == null) {
            MavenDomUtil.$$$reportNull$$$0(11);
        }
        if (clazz == null) {
            MavenDomUtil.$$$reportNull$$$0(12);
        }
        if (!file.isValid()) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        if (psiFile == null) {
            return null;
        }
        return MavenDomUtil.getMavenDomModel(psiFile, clazz);
    }

    @Nullable
    public static <T extends MavenDomElement> T getMavenDomModel(@NotNull PsiFile file, @NotNull Class<T> clazz) {
        DomFileElement<T> fileElement;
        if (file == null) {
            MavenDomUtil.$$$reportNull$$$0(13);
        }
        if (clazz == null) {
            MavenDomUtil.$$$reportNull$$$0(14);
        }
        return (T)((fileElement = MavenDomUtil.getMavenDomFile(file, clazz)) == null ? null : (MavenDomElement)fileElement.getRootElement());
    }

    @Nullable
    private static <T extends MavenDomElement> DomFileElement<T> getMavenDomFile(@NotNull PsiFile file, @NotNull Class<T> clazz) {
        if (file == null) {
            MavenDomUtil.$$$reportNull$$$0(15);
        }
        if (clazz == null) {
            MavenDomUtil.$$$reportNull$$$0(16);
        }
        if (!(file instanceof XmlFile)) {
            return null;
        }
        return DomManager.getDomManager((Project)file.getProject()).getFileElement((XmlFile)file, clazz);
    }

    @Nullable
    public static XmlTag findTag(@NotNull DomElement domElement, @NotNull String path) {
        List elements;
        if (domElement == null) {
            MavenDomUtil.$$$reportNull$$$0(17);
        }
        if (path == null) {
            MavenDomUtil.$$$reportNull$$$0(18);
        }
        if ((elements = StringUtil.split((String)path, (String)".")).isEmpty()) {
            return null;
        }
        Pair<String, Integer> nameAndIndex = MavenDomUtil.translateTagName((String)elements.get(0));
        String name = (String)nameAndIndex.first;
        Integer index = (Integer)nameAndIndex.second;
        XmlTag result = domElement.getXmlTag();
        if (result == null || !name.equals(result.getName())) {
            return null;
        }
        result = MavenDomUtil.getIndexedTag(result, index);
        for (String each : elements.subList(1, elements.size())) {
            nameAndIndex = MavenDomUtil.translateTagName(each);
            name = (String)nameAndIndex.first;
            index = (Integer)nameAndIndex.second;
            if ((result = result.findFirstSubTag(name)) == null) {
                return null;
            }
            result = MavenDomUtil.getIndexedTag(result, index);
        }
        return result;
    }

    private static Pair<String, Integer> translateTagName(String text) {
        String tagName = text.trim();
        Integer index = null;
        Matcher matcher = XML_TAG_NAME_PATTERN.matcher(tagName);
        if (matcher.find()) {
            tagName = matcher.group(1);
            try {
                index = Integer.parseInt(matcher.group(2));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return Pair.create((Object)tagName, index);
    }

    private static XmlTag getIndexedTag(XmlTag parent, Integer index) {
        if (index == null) {
            return parent;
        }
        XmlTag[] children = parent.getSubTags();
        if (index < 0 || index >= children.length) {
            return null;
        }
        return children[index];
    }

    @Nullable
    public static PropertiesFile getPropertiesFile(@NotNull Project project, @NotNull VirtualFile file) {
        PsiFile psiFile;
        if (project == null) {
            MavenDomUtil.$$$reportNull$$$0(19);
        }
        if (file == null) {
            MavenDomUtil.$$$reportNull$$$0(20);
        }
        if (!((psiFile = PsiManager.getInstance((Project)project).findFile(file)) instanceof PropertiesFile)) {
            return null;
        }
        return (PropertiesFile)psiFile;
    }

    @Nullable
    public static IProperty findProperty(@NotNull Project project, @NotNull VirtualFile file, @NotNull String propName) {
        PropertiesFile propertiesFile;
        if (project == null) {
            MavenDomUtil.$$$reportNull$$$0(21);
        }
        if (file == null) {
            MavenDomUtil.$$$reportNull$$$0(22);
        }
        if (propName == null) {
            MavenDomUtil.$$$reportNull$$$0(23);
        }
        return (propertiesFile = MavenDomUtil.getPropertiesFile(project, file)) == null ? null : propertiesFile.findPropertyByKey(propName);
    }

    @Nullable
    public static PsiElement findPropertyValue(@NotNull Project project, @NotNull VirtualFile file, @NotNull String propName) {
        IProperty prop;
        if (project == null) {
            MavenDomUtil.$$$reportNull$$$0(24);
        }
        if (file == null) {
            MavenDomUtil.$$$reportNull$$$0(25);
        }
        if (propName == null) {
            MavenDomUtil.$$$reportNull$$$0(26);
        }
        return (prop = MavenDomUtil.findProperty(project, file, propName)) == null ? null : prop.getPsiElement().getFirstChild().getNextSibling().getNextSibling();
    }

    private static Set<VirtualFile> getFilteredResourcesRoots(@NotNull MavenProject mavenProject) {
        Pair cachedValue;
        if (mavenProject == null) {
            MavenDomUtil.$$$reportNull$$$0(27);
        }
        if ((cachedValue = mavenProject.getCachedValue(FILTERED_RESOURCES_ROOTS_KEY)) == null || ((Long)cachedValue.first).longValue() != VirtualFileManager.getInstance().getModificationCount()) {
            Set set = null;
            for (MavenResource resource : ContainerUtil.concat(mavenProject.getResources(), mavenProject.getTestResources())) {
                VirtualFile resourceDir;
                if (!resource.isFiltered() || (resourceDir = LocalFileSystem.getInstance().findFileByPath(resource.getDirectory())) == null) continue;
                if (set == null) {
                    set = new HashSet();
                }
                set.add(resourceDir);
            }
            if (set == null) {
                set = Collections.emptySet();
            }
            cachedValue = Pair.create((Object)VirtualFileManager.getInstance().getModificationCount(), set);
            mavenProject.putCachedValue(FILTERED_RESOURCES_ROOTS_KEY, cachedValue);
        }
        return (Set)cachedValue.second;
    }

    public static boolean isFilteredResourceFile(PsiElement element) {
        PsiFile psiFile = element.getContainingFile();
        VirtualFile file = MavenDomUtil.getVirtualFile(psiFile);
        if (file == null) {
            return false;
        }
        MavenProjectsManager manager = MavenProjectsManager.getInstance(psiFile.getProject());
        MavenProject mavenProject = manager.findContainingProject(file);
        if (mavenProject == null) {
            return false;
        }
        Set<VirtualFile> filteredRoots = MavenDomUtil.getFilteredResourcesRoots(mavenProject);
        if (!filteredRoots.isEmpty()) {
            for (VirtualFile f = file.getParent(); f != null; f = f.getParent()) {
                if (!filteredRoots.contains(f)) continue;
                return true;
            }
        }
        return false;
    }

    public static List<DomFileElement<MavenDomProjectModel>> collectProjectModels(Project p) {
        return DomService.getInstance().getFileElements(MavenDomProjectModel.class, p, GlobalSearchScope.projectScope((Project)p));
    }

    @NotNull
    public static MavenId describe(PsiFile psiFile) {
        MavenDomProjectModel model = MavenDomUtil.getMavenDomModel(psiFile, MavenDomProjectModel.class);
        if (model == null) {
            MavenId mavenId = new MavenId(null, null, null);
            if (mavenId == null) {
                MavenDomUtil.$$$reportNull$$$0(28);
            }
            return mavenId;
        }
        String groupId = model.getGroupId().getStringValue();
        String artifactId = model.getArtifactId().getStringValue();
        String version = model.getVersion().getStringValue();
        if (groupId == null) {
            groupId = model.getMavenParent().getGroupId().getStringValue();
        }
        if (version == null) {
            version = model.getMavenParent().getVersion().getStringValue();
        }
        MavenId mavenId = new MavenId(groupId, artifactId, version);
        if (mavenId == null) {
            MavenDomUtil.$$$reportNull$$$0(29);
        }
        return mavenId;
    }

    @NotNull
    public static MavenDomDependency createDomDependency(MavenDomProjectModel model, @Nullable Editor editor, @NotNull MavenId id) {
        if (id == null) {
            MavenDomUtil.$$$reportNull$$$0(30);
        }
        MavenDomDependency mavenDomDependency = MavenDomUtil.createDomDependency(model.getDependencies(), editor, id);
        if (mavenDomDependency == null) {
            MavenDomUtil.$$$reportNull$$$0(31);
        }
        return mavenDomDependency;
    }

    @NotNull
    public static MavenDomDependency createDomDependency(MavenDomDependencies dependencies, @Nullable Editor editor, @NotNull MavenId id) {
        if (id == null) {
            MavenDomUtil.$$$reportNull$$$0(32);
        }
        MavenDomDependency dep = MavenDomUtil.createDomDependency(dependencies, editor);
        dep.getGroupId().setStringValue(id.getGroupId());
        dep.getArtifactId().setStringValue(id.getArtifactId());
        dep.getVersion().setStringValue(id.getVersion());
        MavenDomDependency mavenDomDependency = dep;
        if (mavenDomDependency == null) {
            MavenDomUtil.$$$reportNull$$$0(33);
        }
        return mavenDomDependency;
    }

    @NotNull
    public static MavenDomDependency createDomDependency(@NotNull MavenDomProjectModel model, @Nullable Editor editor) {
        if (model == null) {
            MavenDomUtil.$$$reportNull$$$0(34);
        }
        MavenDomDependency mavenDomDependency = MavenDomUtil.createDomDependency(model.getDependencies(), editor);
        if (mavenDomDependency == null) {
            MavenDomUtil.$$$reportNull$$$0(35);
        }
        return mavenDomDependency;
    }

    @NotNull
    public static MavenDomDependency createDomDependency(@NotNull MavenDomDependencies dependencies, @Nullable Editor editor) {
        DomElement element;
        DomCollectionChildDescription childDescription;
        int index;
        if (dependencies == null) {
            MavenDomUtil.$$$reportNull$$$0(36);
        }
        if ((index = MavenDomUtil.getCollectionIndex(dependencies, editor)) >= 0 && (childDescription = dependencies.getGenericInfo().getCollectionChildDescription("dependency")) != null && (element = childDescription.addValue((DomElement)dependencies, index)) instanceof MavenDomDependency) {
            MavenDomDependency mavenDomDependency = (MavenDomDependency)element;
            if (mavenDomDependency == null) {
                MavenDomUtil.$$$reportNull$$$0(37);
            }
            return mavenDomDependency;
        }
        MavenDomDependency mavenDomDependency = dependencies.addDependency();
        if (mavenDomDependency == null) {
            MavenDomUtil.$$$reportNull$$$0(38);
        }
        return mavenDomDependency;
    }

    public static int getCollectionIndex(@NotNull MavenDomDependencies dependencies, @Nullable Editor editor) {
        if (dependencies == null) {
            MavenDomUtil.$$$reportNull$$$0(39);
        }
        if (editor != null) {
            int offset = editor.getCaretModel().getOffset();
            List<MavenDomDependency> dependencyList = dependencies.getDependencies();
            for (int i = 0; i < dependencyList.size(); ++i) {
                MavenDomDependency dependency = dependencyList.get(i);
                XmlElement xmlElement = dependency.getXmlElement();
                if (xmlElement == null || xmlElement.getTextRange().getStartOffset() < offset) continue;
                return i;
            }
        }
        return -1;
    }

    @NotNull
    public static String getProjectName(MavenDomProjectModel model) {
        MavenProject mavenProject = MavenDomUtil.findProject(model);
        if (mavenProject != null) {
            String string = mavenProject.getDisplayName();
            if (string == null) {
                MavenDomUtil.$$$reportNull$$$0(40);
            }
            return string;
        }
        String name = model.getName().getStringValue();
        if (!StringUtil.isEmptyOrSpaces((String)name)) {
            String string = name;
            if (string == null) {
                MavenDomUtil.$$$reportNull$$$0(41);
            }
            return string;
        }
        if ("pom.xml" == null) {
            MavenDomUtil.$$$reportNull$$$0(42);
        }
        return "pom.xml";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 28: 
            case 29: 
            case 31: 
            case 33: 
            case 35: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 42: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 28: 
            case 29: 
            case 31: 
            case 33: 
            case 35: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 42: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectDom";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 19: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 20: 
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 12: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "domElement";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propName";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenProject";
                break;
            }
            case 28: 
            case 29: 
            case 31: 
            case 33: 
            case 35: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/dom/MavenDomUtil";
                break;
            }
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 36: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencies";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/dom/MavenDomUtil";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "describe";
                break;
            }
            case 31: 
            case 33: 
            case 35: 
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "createDomDependency";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findContainingMavenizedModule";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getVirtualFile";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findProject";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findContainingProject";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getMavenDomProjectModel";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getMavenDomProfilesModel";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getMavenDomModel";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getMavenDomFile";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findTag";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getPropertiesFile";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "findProperty";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "findPropertyValue";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getFilteredResourcesRoots";
                break;
            }
            case 28: 
            case 29: 
            case 31: 
            case 33: 
            case 35: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 42: {
                break;
            }
            case 30: 
            case 32: 
            case 34: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "createDomDependency";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getCollectionIndex";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 28: 
            case 29: 
            case 31: 
            case 33: 
            case 35: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 42: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

