/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.settings;

import com.intellij.javascript.trace.TraceBundle;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Predicate;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.XCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.NotNull;

@State(name="SpyJsConfiguration", storages={@Storage(value="spy-js.xml")})
public class TraceProjectSettings
implements PersistentStateComponent<TraceSettingsState> {
    private TraceSettingsState myState = new TraceSettingsState();

    @NotNull
    public static TraceProjectSettings getInstance(Project project) {
        TraceProjectSettings traceProjectSettings = (TraceProjectSettings)ServiceManager.getService((Project)project, TraceProjectSettings.class);
        if (traceProjectSettings == null) {
            TraceProjectSettings.$$$reportNull$$$0(0);
        }
        return traceProjectSettings;
    }

    @NotNull
    public TraceSettingsState getState() {
        TraceSettingsState traceSettingsState = this.myState;
        if (traceSettingsState == null) {
            TraceProjectSettings.$$$reportNull$$$0(1);
        }
        return traceSettingsState;
    }

    public void loadState(@NotNull TraceSettingsState state) {
        if (state == null) {
            TraceProjectSettings.$$$reportNull$$$0(2);
        }
        this.myState = state;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/trace/settings/TraceProjectSettings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/trace/settings/TraceProjectSettings";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @Tag(value="event-filter-condition")
    public static class EventFilterConditionState
    implements Cloneable {
        private String myValue = "";
        private String myType = "event";
        private boolean myIsInverted = false;
        public static final String EVENT_TYPE = "event";
        public static final String FILE_TYPE = "file";
        private static final Map<String, String> TYPE_NAMES = new HashMap<String, String>();
        private boolean isMyPatternCompiled;
        private Pattern myPattern;

        @Attribute(value="value")
        public String getValue() {
            return this.myValue;
        }

        public void setValue(@NotNull String value) {
            if (value == null) {
                EventFilterConditionState.$$$reportNull$$$0(0);
            }
            this.myValue = value;
            this.myIsInverted = this.myValue.startsWith("!");
            this.isMyPatternCompiled = false;
        }

        @Attribute(value="type")
        public String getType() {
            return this.myType;
        }

        public void setType(@NotNull String type) {
            if (type == null) {
                EventFilterConditionState.$$$reportNull$$$0(1);
            }
            this.myType = type;
        }

        @NotNull
        public String getTypeDisplayName() {
            String string = TYPE_NAMES.get(this.getType());
            if (string == null) {
                EventFilterConditionState.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public static String getTypeDisplayName(String type) {
            String string = TYPE_NAMES.get(type);
            if (string == null) {
                EventFilterConditionState.$$$reportNull$$$0(3);
            }
            return string;
        }

        @NotNull
        public static String[] getTypes() {
            Set<String> types = TYPE_NAMES.keySet();
            String[] stringArray = types.toArray(ArrayUtil.EMPTY_STRING_ARRAY);
            if (stringArray == null) {
                EventFilterConditionState.$$$reportNull$$$0(4);
            }
            return stringArray;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EventFilterConditionState state = (EventFilterConditionState)o;
            if (!this.myType.equals(state.myType)) {
                return false;
            }
            return this.myValue.equals(state.myValue);
        }

        public int hashCode() {
            int result = this.myValue.hashCode();
            result = 31 * result + this.myType.hashCode();
            return result;
        }

        public Object clone() {
            EventFilterConditionState condition = new EventFilterConditionState();
            condition.setType(this.getType());
            condition.setValue(this.getValue());
            return condition;
        }

        private boolean matches(@NotNull String value) {
            Pattern pattern;
            if (value == null) {
                EventFilterConditionState.$$$reportNull$$$0(5);
            }
            if ((pattern = this.getPattern()) == null) {
                return false;
            }
            Matcher matcher = pattern.matcher(value);
            boolean matches = matcher.matches();
            return this.myIsInverted ? !matches : matches;
        }

        private Pattern getPattern() {
            if (this.isMyPatternCompiled) {
                return this.myPattern;
            }
            String regExString = EventFilterConditionState.convertGlobToRegEx(this.myValue);
            if (this.myIsInverted) {
                regExString = regExString.substring(1);
            }
            try {
                this.myPattern = Pattern.compile(regExString, 2);
            }
            catch (PatternSyntaxException e) {
                this.myPattern = null;
            }
            this.isMyPatternCompiled = true;
            return this.myPattern;
        }

        private static String convertGlobToRegEx(String glob) {
            glob = glob.trim();
            int strLen = glob.length();
            StringBuilder sb = new StringBuilder(strLen);
            boolean escaping = false;
            int inCurlyBraces = 0;
            block9: for (char currentChar : glob.toCharArray()) {
                switch (currentChar) {
                    case '*': {
                        if (escaping) {
                            sb.append("\\*");
                        } else {
                            sb.append(".*");
                        }
                        escaping = false;
                        continue block9;
                    }
                    case '?': {
                        if (escaping) {
                            sb.append("\\?");
                        } else {
                            sb.append('.');
                        }
                        escaping = false;
                        continue block9;
                    }
                    case '$': 
                    case '%': 
                    case '(': 
                    case ')': 
                    case '+': 
                    case '.': 
                    case '@': 
                    case '^': 
                    case '|': {
                        sb.append('\\');
                        sb.append(currentChar);
                        escaping = false;
                        continue block9;
                    }
                    case '\\': {
                        if (escaping) {
                            sb.append("\\\\");
                            escaping = false;
                            continue block9;
                        }
                        escaping = true;
                        continue block9;
                    }
                    case '{': {
                        if (escaping) {
                            sb.append("\\{");
                        } else {
                            sb.append('(');
                            ++inCurlyBraces;
                        }
                        escaping = false;
                        continue block9;
                    }
                    case '}': {
                        if (inCurlyBraces > 0 && !escaping) {
                            sb.append(')');
                            --inCurlyBraces;
                        } else if (escaping) {
                            sb.append("\\}");
                        } else {
                            sb.append("}");
                        }
                        escaping = false;
                        continue block9;
                    }
                    case ',': {
                        if (inCurlyBraces > 0 && !escaping) {
                            sb.append('|');
                            continue block9;
                        }
                        if (escaping) {
                            sb.append("\\,");
                            continue block9;
                        }
                        sb.append(",");
                        continue block9;
                    }
                    default: {
                        escaping = false;
                        sb.append(currentChar);
                    }
                }
            }
            return sb.toString();
        }

        static {
            TYPE_NAMES.put(EVENT_TYPE, TraceBundle.message("settings.eventFilters.conditionType.event", new Object[0]));
            TYPE_NAMES.put(FILE_TYPE, TraceBundle.message("settings.eventFilters.conditionType.file", new Object[0]));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javascript/trace/settings/TraceProjectSettings$EventFilterConditionState";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javascript/trace/settings/TraceProjectSettings$EventFilterConditionState";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTypeDisplayName";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTypes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "setValue";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setType";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "matches";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    @Tag(value="event-filter")
    public static class EventFilterState
    implements Cloneable {
        public static final EventFilterState NULL_FILTER = new EventFilterState(TraceBundle.message("console.trace.toolbar.filterEvents.allName", new Object[0]), true){

            @Override
            public boolean matchesEventName(@NotNull String eventName) {
                if (eventName == null) {
                    1.$$$reportNull$$$0(0);
                }
                return false;
            }

            @Override
            public boolean matchesFileName(@NotNull String fileName) {
                if (fileName == null) {
                    1.$$$reportNull$$$0(1);
                }
                return false;
            }

            @Override
            public boolean matchesAllFileNames(@NotNull String[] fileNames) {
                if (fileNames == null) {
                    1.$$$reportNull$$$0(2);
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "eventName";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "fileName";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "fileNames";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/javascript/trace/settings/TraceProjectSettings$EventFilterState$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "matchesEventName";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "matchesFileName";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "matchesAllFileNames";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        public static final EventFilterState ALL_FILTER = new EventFilterState(TraceBundle.message("console.trace.toolbar.filterEvents.nothingName", new Object[0]), true){

            @Override
            public boolean matchesEventName(@NotNull String eventName) {
                if (eventName == null) {
                    2.$$$reportNull$$$0(0);
                }
                return true;
            }

            @Override
            public boolean matchesFileName(@NotNull String fileName) {
                if (fileName == null) {
                    2.$$$reportNull$$$0(1);
                }
                return false;
            }

            @Override
            public boolean matchesAllFileNames(@NotNull String[] fileNames) {
                if (fileNames == null) {
                    2.$$$reportNull$$$0(2);
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "eventName";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "fileName";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "fileNames";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/javascript/trace/settings/TraceProjectSettings$EventFilterState$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "matchesEventName";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "matchesFileName";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "matchesAllFileNames";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        private String myName;
        private List<EventFilterConditionState> myEventFilterConditions;
        private boolean myIsActive;

        public static boolean isAllOrNothingFilter(EventFilterState filter) {
            return NULL_FILTER == filter || ALL_FILTER == filter;
        }

        public EventFilterState() {
            this.myName = "";
            this.myEventFilterConditions = new SmartList();
            this.myIsActive = true;
        }

        public EventFilterState(@NotNull String name, boolean isActive) {
            if (name == null) {
                EventFilterState.$$$reportNull$$$0(0);
            }
            this.myName = "";
            this.myEventFilterConditions = new SmartList();
            this.myIsActive = true;
            this.myName = name;
            this.myIsActive = isActive;
        }

        @Attribute(value="name")
        public String getName() {
            return this.myName;
        }

        public void setName(String name) {
            this.myName = name;
        }

        @Attribute(value="active")
        public boolean isActive() {
            return this.myIsActive;
        }

        public void setActive(boolean isActive) {
            this.myIsActive = isActive;
        }

        @XCollection(propertyElementName="event-filter-conditions")
        public List<EventFilterConditionState> getEventFilterConditions() {
            return this.myEventFilterConditions;
        }

        public void setEventFilterConditions(List<EventFilterConditionState> eventFilterConditions) {
            this.myEventFilterConditions = eventFilterConditions;
        }

        public boolean isEmpty() {
            return this.myEventFilterConditions.isEmpty();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EventFilterState state = (EventFilterState)o;
            if (this.myIsActive != state.myIsActive) {
                return false;
            }
            if (!this.myEventFilterConditions.equals(state.myEventFilterConditions)) {
                return false;
            }
            return this.myName.equals(state.myName);
        }

        public int hashCode() {
            int result = this.myName.hashCode();
            result = 31 * result + this.myEventFilterConditions.hashCode();
            result = 31 * result + (this.myIsActive ? 1 : 0);
            return result;
        }

        public Object clone() {
            EventFilterState filter = new EventFilterState(this.getName(), this.isActive());
            filter.setEventFilterConditions(new ArrayList<EventFilterConditionState>(ContainerUtil.map(this.getEventFilterConditions(), cond -> (EventFilterConditionState)cond.clone())));
            return filter;
        }

        public void addEventFilterCondition(@NotNull EventFilterConditionState condition) {
            if (condition == null) {
                EventFilterState.$$$reportNull$$$0(1);
            }
            this.myEventFilterConditions.add(condition);
        }

        public void removeEventFilterCondition(EventFilterConditionState condition) {
            this.myEventFilterConditions.remove(condition);
        }

        public boolean matchesEventName(@NotNull String eventName) {
            if (eventName == null) {
                EventFilterState.$$$reportNull$$$0(2);
            }
            return this.getEventNamePredicate().apply((Object)eventName);
        }

        public boolean matchesFileName(@NotNull String fileName) {
            if (fileName == null) {
                EventFilterState.$$$reportNull$$$0(3);
            }
            return this.getFileNamePredicate().apply((Object)fileName);
        }

        public boolean matchesAllFileNames(@NotNull String[] fileNames) {
            if (fileNames == null) {
                EventFilterState.$$$reportNull$$$0(4);
            }
            return !ContainerUtil.exists((Object[])fileNames, file -> !this.matchesFileName((String)file));
        }

        private Predicate<String> getEventNamePredicate() {
            return this.getTypePredicate("event");
        }

        private Predicate<String> getFileNamePredicate() {
            return this.getTypePredicate("file");
        }

        private Predicate<String> getTypePredicate(@NotNull String type) {
            if (type == null) {
                EventFilterState.$$$reportNull$$$0(5);
            }
            List eventNameConditions = ContainerUtil.filter(this.getEventFilterConditions(), state -> {
                if (type == null) {
                    EventFilterState.$$$reportNull$$$0(8);
                }
                return state.getType().equals(type);
            });
            return input -> ContainerUtil.exists((Iterable)eventNameConditions, state -> {
                assert (input != null);
                return ((EventFilterConditionState)state).matches(input);
            });
        }

        public Collection<String> getEventNameRegularExpressions() {
            return this.getRegularExpressions("event");
        }

        public Collection<String> getFileNameRegularExpressions() {
            return this.getRegularExpressions("file");
        }

        private Collection<String> getRegularExpressions(@NotNull String type) {
            if (type == null) {
                EventFilterState.$$$reportNull$$$0(6);
            }
            return ContainerUtil.map((Collection)ContainerUtil.filter(this.getEventFilterConditions(), state -> {
                if (type == null) {
                    EventFilterState.$$$reportNull$$$0(7);
                }
                return state.getType().equals(type);
            }), condition -> EventFilterConditionState.convertGlobToRegEx(condition.getValue()));
        }

        static {
            EventFilterConditionState condition = new EventFilterConditionState();
            condition.setType("event");
            condition.setValue("!#");
            ALL_FILTER.addEventFilterCondition(condition);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "condition";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "eventName";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileName";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileNames";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/javascript/trace/settings/TraceProjectSettings$EventFilterState";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addEventFilterCondition";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "matchesEventName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "matchesFileName";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "matchesAllFileNames";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getTypePredicate";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getRegularExpressions";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$getRegularExpressions$5";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$getTypePredicate$2";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class TraceSettingsState
    implements Cloneable {
        private List<EventFilterState> myEventFilters = new SmartList();

        @XCollection(propertyElementName="event-filters")
        public List<EventFilterState> getEventFilters() {
            return this.myEventFilters;
        }

        public void setEventFilters(List<EventFilterState> eventFilters) {
            this.myEventFilters = eventFilters;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TraceSettingsState state = (TraceSettingsState)o;
            return this.myEventFilters.equals(state.myEventFilters);
        }

        public int hashCode() {
            return this.myEventFilters.hashCode();
        }

        public Object clone() {
            TraceSettingsState state = new TraceSettingsState();
            state.setEventFilters(new ArrayList<EventFilterState>(ContainerUtil.map(this.getEventFilters(), filter -> (EventFilterState)filter.clone())));
            return state;
        }

        public void addEventFilter(EventFilterState filter) {
            this.myEventFilters.add(filter);
        }

        public void removeEventFilter(EventFilterState filter) {
            this.myEventFilters.remove(filter);
        }

        public EventFilterState findEventFilterByName(String name) {
            if (name == null) {
                return null;
            }
            return (EventFilterState)ContainerUtil.find(this.getEventFilters(), state -> state.getName().equals(name));
        }

        public EventFilterState findEventFilterByOnlyCondition(String value) {
            if (value == null) {
                return null;
            }
            return (EventFilterState)ContainerUtil.find(this.getEventFilters(), state -> {
                if (!state.isActive()) {
                    return false;
                }
                List<EventFilterConditionState> conditions = state.getEventFilterConditions();
                return conditions.size() == 1 && value.equals(conditions.get(0).getValue());
            });
        }
    }
}

