/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution.fileDependency;

import com.intellij.javascript.trace.execution.fileDependency.FileNode;
import com.intellij.javascript.trace.execution.fileDependency.RuntimeDependencyEdge;
import com.intellij.openapi.graph.builder.GraphDataModel;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileDependencyGraph
extends GraphDataModel<FileNode, RuntimeDependencyEdge> {
    private final HashMap<String, FileNode> myNodeHashMap;
    private final HashSet<RuntimeDependencyEdge> myEdges;
    private final List<Predicate<FileNode>> myNodeFilters;
    private static final int MAX_NODES = 1000;
    private final String myStreamId;

    public FileDependencyGraph(@NotNull String streamId) {
        if (streamId == null) {
            FileDependencyGraph.$$$reportNull$$$0(0);
        }
        this.myNodeHashMap = new HashMap();
        this.myEdges = new HashSet();
        this.myNodeFilters = new ArrayList<Predicate<FileNode>>();
        this.myStreamId = streamId;
    }

    @NotNull
    public Collection<FileNode> getNodes() {
        Collection<FileNode> fileNodes = this.myNodeHashMap.values();
        if (this.myNodeFilters.isEmpty()) {
            Collection<FileNode> collection = fileNodes;
            if (collection == null) {
                FileDependencyGraph.$$$reportNull$$$0(1);
            }
            return collection;
        }
        List list = ContainerUtil.filter(fileNodes, fileNode -> this.matchesAllFilters((FileNode)fileNode));
        if (list == null) {
            FileDependencyGraph.$$$reportNull$$$0(2);
        }
        return list;
    }

    private boolean matchesAllFilters(FileNode fileNode) {
        return ContainerUtil.find(this.myNodeFilters, predicate -> !predicate.apply((Object)fileNode)) == null;
    }

    @NotNull
    public Collection<RuntimeDependencyEdge> getEdges() {
        if (this.myNodeFilters.isEmpty()) {
            HashSet<RuntimeDependencyEdge> hashSet = this.myEdges;
            if (hashSet == null) {
                FileDependencyGraph.$$$reportNull$$$0(3);
            }
            return hashSet;
        }
        List list = ContainerUtil.filter(this.myEdges, edge -> this.matchesAllFilters(edge.getSource()) && this.matchesAllFilters(edge.getTarget()));
        if (list == null) {
            FileDependencyGraph.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    public FileNode getSourceNode(RuntimeDependencyEdge edge) {
        FileNode fileNode = edge.getSource();
        if (fileNode == null) {
            FileDependencyGraph.$$$reportNull$$$0(5);
        }
        return fileNode;
    }

    @NotNull
    public FileNode getTargetNode(RuntimeDependencyEdge edge) {
        FileNode fileNode = edge.getTarget();
        if (fileNode == null) {
            FileDependencyGraph.$$$reportNull$$$0(6);
        }
        return fileNode;
    }

    @NotNull
    public String getNodeName(FileNode node) {
        String string = node.getUrl();
        if (string == null) {
            FileDependencyGraph.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public String getEdgeName(RuntimeDependencyEdge edge) {
        String string = edge.getName();
        if (string == null) {
            FileDependencyGraph.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Nullable
    public RuntimeDependencyEdge createEdge(@NotNull FileNode from, @NotNull FileNode to) {
        if (from == null) {
            FileDependencyGraph.$$$reportNull$$$0(9);
        }
        if (to == null) {
            FileDependencyGraph.$$$reportNull$$$0(10);
        }
        if (this.myNodeHashMap.size() >= 1000) {
            return null;
        }
        this.myNodeHashMap.putIfAbsent(from.getId(), from);
        this.myNodeHashMap.putIfAbsent(to.getId(), to);
        RuntimeDependencyEdge dependencyEdge = new RuntimeDependencyEdge(from, to);
        this.myEdges.add(dependencyEdge);
        from.addOutgoingEdge(dependencyEdge);
        to.addIncomingEdge(dependencyEdge);
        return dependencyEdge;
    }

    public void dispose() {
    }

    public void addNodeFilter(@NotNull Predicate<FileNode> nodeFilter) {
        if (nodeFilter == null) {
            FileDependencyGraph.$$$reportNull$$$0(11);
        }
        this.myNodeFilters.add(nodeFilter);
    }

    @Nullable
    public FileNode getNode(@NotNull String fileId) {
        if (fileId == null) {
            FileDependencyGraph.$$$reportNull$$$0(12);
        }
        return this.myNodeHashMap.get(fileId);
    }

    @NotNull
    public String getStreamId() {
        String string = this.myStreamId;
        if (string == null) {
            FileDependencyGraph.$$$reportNull$$$0(13);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "streamId";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/trace/execution/fileDependency/FileDependencyGraph";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeFilter";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/trace/execution/fileDependency/FileDependencyGraph";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodes";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdges";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceNode";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetNode";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdgeName";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getStreamId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 13: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createEdge";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addNodeFilter";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getNode";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

