/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution;

import com.intellij.javascript.trace.TraceBundle;
import com.intellij.javascript.trace.settings.TraceProjectSettings;
import com.intellij.javascript.trace.settings.TraceSettingsManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeModuleUtils {
    private static final String SEPARATOR = StringUtil.escapeBackSlashes((String)File.separator);
    private static final String NODE_MODULES_PATTERN = "*" + SEPARATOR + "node_modules" + SEPARATOR + "*";

    public static boolean containsNodeModulesPattern(@NotNull TraceProjectSettings.EventFilterState activeFilter) {
        if (activeFilter == null) {
            NodeModuleUtils.$$$reportNull$$$0(0);
        }
        return NodeModuleUtils.contains(activeFilter, NODE_MODULES_PATTERN);
    }

    public static boolean containsNodeModulePattern(@NotNull TraceProjectSettings.EventFilterState activeFilter, @NotNull String module) {
        if (activeFilter == null) {
            NodeModuleUtils.$$$reportNull$$$0(1);
        }
        if (module == null) {
            NodeModuleUtils.$$$reportNull$$$0(2);
        }
        return NodeModuleUtils.contains(activeFilter, NodeModuleUtils.getModulePattern(module));
    }

    private static boolean contains(TraceProjectSettings.EventFilterState activeFilter, @NotNull String conditionValue) {
        if (conditionValue == null) {
            NodeModuleUtils.$$$reportNull$$$0(3);
        }
        return ContainerUtil.exists(activeFilter.getEventFilterConditions(), condition -> {
            if (conditionValue == null) {
                NodeModuleUtils.$$$reportNull$$$0(8);
            }
            return conditionValue.equals(condition.getValue());
        });
    }

    public static void muteNodeModules(@NotNull TraceSettingsManager traceSettingsManager) {
        if (traceSettingsManager == null) {
            NodeModuleUtils.$$$reportNull$$$0(4);
        }
        NodeModuleUtils.mute(traceSettingsManager, null);
    }

    public static void muteNodeModule(@NotNull TraceSettingsManager traceSettingsManager, @NotNull String nodeModule) {
        if (traceSettingsManager == null) {
            NodeModuleUtils.$$$reportNull$$$0(5);
        }
        if (nodeModule == null) {
            NodeModuleUtils.$$$reportNull$$$0(6);
        }
        NodeModuleUtils.mute(traceSettingsManager, nodeModule);
    }

    private static void mute(@NotNull TraceSettingsManager traceSettingsManager, @Nullable String module) {
        if (traceSettingsManager == null) {
            NodeModuleUtils.$$$reportNull$$$0(7);
        }
        boolean specificModule = !StringUtil.isEmpty((String)module);
        String conditionValue = !specificModule ? NODE_MODULES_PATTERN : NodeModuleUtils.getModulePattern(module);
        TraceProjectSettings.EventFilterState activeFilter = traceSettingsManager.getActiveFilter();
        if (NodeModuleUtils.containsNodeModulesPattern(activeFilter)) {
            return;
        }
        if (traceSettingsManager.setAndApplyFilterByCondition(conditionValue)) {
            return;
        }
        TraceProjectSettings.EventFilterConditionState condition = new TraceProjectSettings.EventFilterConditionState();
        condition.setType("file");
        condition.setValue(conditionValue);
        traceSettingsManager.addToActiveOrCreateNewFilterAndApply(condition, specificModule ? String.format(TraceBundle.message("console.trace.toolbar.filterEvents.muteNodeModuleSuggestion", new Object[0]), module) : TraceBundle.message("console.trace.toolbar.filterEvents.muteNodeModulesSuggestion", new Object[0]));
    }

    private static String getModulePattern(String module) {
        return StringUtil.trimEnd((String)NODE_MODULES_PATTERN, (String)"*") + module + SEPARATOR + "*";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activeFilter";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conditionValue";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "traceSettingsManager";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeModule";
                break;
            }
        }
        objectArray2[1] = "com/intellij/javascript/trace/execution/NodeModuleUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "containsNodeModulesPattern";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "containsNodeModulePattern";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "contains";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "muteNodeModules";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "muteNodeModule";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "mute";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$contains$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

