/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.util.control.effectpicker.editors;

import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.DoubleField;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.EditorUtils;
import com.oracle.javafx.scenebuilder.kit.util.control.effectpicker.EffectPickerController;
import com.oracle.javafx.scenebuilder.kit.util.control.effectpicker.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.control.Label;
import javafx.scene.control.Slider;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.GridPane;

public class SliderControl
extends GridPane {
    @FXML
    private Slider editor_slider;
    @FXML
    private Label editor_label;
    @FXML
    private DoubleField editor_textfield;
    private boolean intMode;
    private double incDecValue;
    private final DoubleProperty value = new SimpleDoubleProperty();
    private final EffectPickerController effectPickerController;
    private final int roundingFactor = 100;

    public SliderControl(EffectPickerController effectPickerController, String labelString, double min, double max, double initVal, double incDec, boolean integerMode) {
        this.effectPickerController = effectPickerController;
        this.initialize(labelString, min, max, initVal, incDec, integerMode);
    }

    public DoubleProperty valueProperty() {
        return this.value;
    }

    public double getValue() {
        return this.value.get();
    }

    public Slider getSlider() {
        return this.editor_slider;
    }

    public TextField getTextField() {
        return this.editor_textfield;
    }

    @FXML
    void textfieldTyped(KeyEvent e) {
        if (e.getCode() == KeyCode.UP) {
            this.incOrDecValue(this.incDecValue);
        } else if (e.getCode() == KeyCode.DOWN) {
            this.incOrDecValue(-this.incDecValue);
        } else if (e.getCode() == KeyCode.ENTER) {
            double inputValue = Double.parseDouble(this.editor_textfield.getText());
            this.setValue(inputValue);
            this.editor_slider.setValue(this.getValue());
            this.editor_textfield.selectAll();
        }
    }

    private void incOrDecValue(double delta) {
        this.setValue(this.getValue() + delta);
    }

    private void setValue(Number n) {
        if (this.intMode) {
            long rounded = Math.round(n.doubleValue());
            this.value.set((double)rounded);
            this.editor_textfield.setText(Long.toString(rounded));
        } else {
            double val = Utils.clamp(this.editor_slider.getMin(), n.doubleValue(), this.editor_slider.getMax());
            double rounded = EditorUtils.round(val, 100);
            this.value.set(rounded);
            this.editor_textfield.setText(Double.toString(rounded));
        }
        this.editor_slider.setValue(this.value.get());
    }

    private void initialize(String labelString, double min, double max, double initVal, double incDec, boolean integerMode) {
        URL layoutURL = SliderControl.class.getResource("SliderControl.fxml");
        try (InputStream is = layoutURL.openStream();){
            FXMLLoader loader = new FXMLLoader();
            loader.setController((Object)this);
            loader.setRoot((Object)this);
            loader.setLocation(layoutURL);
            Parent p = (Parent)loader.load(is);
            assert (p == this);
        }
        catch (IOException x) {
            throw new RuntimeException(x);
        }
        this.editor_label.setText(labelString);
        this.incDecValue = incDec;
        this.intMode = integerMode;
        this.editor_slider.setMin(min);
        this.editor_slider.setMax(max);
        this.editor_slider.setValue(initVal);
        this.setValue(initVal);
        this.editor_slider.valueProperty().addListener((ov, oldVal, newVal) -> {
            this.setValue((Number)newVal);
            this.effectPickerController.incrementRevision();
        });
        this.editor_slider.pressedProperty().addListener((ov, oldValue, newValue) -> this.effectPickerController.setLiveUpdate((boolean)newValue));
        this.editor_textfield.focusedProperty().addListener((ov, oldValue, newValue) -> {
            if (!newValue.booleanValue()) {
                double inputValue = Double.parseDouble(this.editor_textfield.getText());
                this.setValue(inputValue);
                this.effectPickerController.incrementRevision();
            }
        });
        this.editor_textfield.setOnAction(e -> e.consume());
    }
}

