/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.fxom.glue;

import com.oracle.javafx.scenebuilder.kit.fxom.glue.QualifiedName;
import java.util.Comparator;
import java.util.Map;

class XMLAttrComparator
implements Comparator<Map.Entry<String, String>> {
    XMLAttrComparator() {
    }

    @Override
    public int compare(Map.Entry<String, String> attr1, Map.Entry<String, String> attr2) {
        int result;
        assert (attr1 != null);
        assert (attr2 != null);
        int aoi1 = this.getAttrOrderIndex(attr1);
        int aoi2 = this.getAttrOrderIndex(attr2);
        if (aoi1 == 2 && aoi2 == 2) {
            QualifiedName qn1 = new QualifiedName(attr1.getKey());
            QualifiedName qn2 = new QualifiedName(attr2.getKey());
            result = qn1.compareTo(qn2);
        } else {
            result = Integer.compare(aoi1, aoi2);
        }
        return result;
    }

    private int getAttrOrderIndex(Map.Entry<String, String> attr) {
        int result;
        assert (attr != null);
        switch (attr.getKey()) {
            case "id": {
                result = 0;
                break;
            }
            case "fx:id": {
                if (attr.getValue().startsWith("x")) {
                    result = 10000;
                    break;
                }
                result = 1;
                break;
            }
            default: {
                result = 2;
                break;
            }
            case "fx:value": {
                result = 3;
                break;
            }
            case "fx:factory": {
                result = 4;
                break;
            }
            case "xmlns": {
                result = 5;
                break;
            }
            case "xmlns:fx": {
                result = 5;
                break;
            }
            case "fx:controller": {
                result = 6;
            }
        }
        return result;
    }
}

