/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.fxom.glue;

import java.util.Objects;

class QualifiedName
implements Comparable<QualifiedName> {
    private final String qualifier;
    private final String name;

    public QualifiedName(String qualifier, String name) {
        assert (name != null);
        this.qualifier = qualifier;
        this.name = name;
    }

    public QualifiedName(String qualifiedName) {
        int dotIndex = qualifiedName.indexOf(46);
        if (dotIndex == -1) {
            this.qualifier = null;
            this.name = qualifiedName;
        } else {
            this.qualifier = qualifiedName.substring(0, dotIndex);
            this.name = qualifiedName.substring(dotIndex + 1);
        }
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        int hash = 7;
        hash = 71 * hash + Objects.hashCode(this.qualifier);
        hash = 71 * hash + Objects.hashCode(this.name);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        QualifiedName other = (QualifiedName)obj;
        if (!Objects.equals(this.qualifier, other.qualifier)) {
            return false;
        }
        return Objects.equals(this.name, other.name);
    }

    @Override
    public int compareTo(QualifiedName o) {
        int result;
        if (this == o) {
            result = 0;
        } else if (o == null) {
            result = -1;
        } else {
            result = this.qualifier == null && o.qualifier == null ? 0 : (this.qualifier == null ? -1 : (o.qualifier == null ? 1 : this.qualifier.compareTo(o.qualifier)));
            if (result == 0) {
                assert (this.name != null);
                assert (o.name != null);
                result = this.name.compareTo(o.name);
            }
        }
        return result;
    }
}

