/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.util.dialog;

import com.oracle.javafx.scenebuilder.kit.editor.i18n.I18N;
import com.oracle.javafx.scenebuilder.kit.editor.panel.util.dialog.AbstractModalDialog;
import java.util.HashMap;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.TextArea;
import javafx.scene.input.Clipboard;
import javafx.scene.input.DataFormat;
import javafx.stage.Window;

public class TextViewDialog
extends AbstractModalDialog {
    @FXML
    private TextArea textArea;

    public TextViewDialog(Window owner) {
        super(TextViewDialog.class.getResource("TextViewDialog.fxml"), null, owner);
        this.setOKButtonVisible(false);
        this.setActionButtonVisible(true);
        this.setCancelButtonTitle(I18N.getString("label.close"));
        this.setActionButtonTitle(I18N.getString("label.copy"));
    }

    public void setText(String text) {
        this.textArea.setText(text);
    }

    public String getText() {
        return this.textArea.getText();
    }

    @Override
    protected void controllerDidLoadContentFxml() {
        assert (this.textArea != null);
    }

    @Override
    protected void okButtonPressed(ActionEvent e) {
        throw new IllegalStateException();
    }

    @Override
    protected void cancelButtonPressed(ActionEvent e) {
        this.getStage().close();
    }

    @Override
    protected void actionButtonPressed(ActionEvent e) {
        HashMap<DataFormat, String> content = new HashMap<DataFormat, String>();
        content.put(DataFormat.PLAIN_TEXT, this.getText());
        Clipboard.getSystemClipboard().setContent(content);
    }
}

