/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.hierarchy.treeview;

import com.oracle.javafx.scenebuilder.kit.util.Deprecation;
import java.util.List;
import java.util.Set;
import javafx.scene.Node;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;

public abstract class HierarchyTreeViewUtils {
    public static <T> Set<Node> getTreeCells(TreeView<T> treeView) {
        assert (treeView != null);
        return treeView.lookupAll(".hierarchy-tree-cell");
    }

    public static TreeCell<?> getTreeCell(TreeView<?> treeView, TreeItem<?> treeItem) {
        return HierarchyTreeViewUtils.getTreeCell(HierarchyTreeViewUtils.getTreeCells(treeView), treeItem);
    }

    public static TreeCell<?> getTreeCell(TreeView<?> treeView, int index) {
        return HierarchyTreeViewUtils.getTreeCell(HierarchyTreeViewUtils.getTreeCells(treeView), index);
    }

    public static TreeCell<?> getTreeCell(Set<Node> treeCells, TreeItem<?> treeItem) {
        assert (treeCells != null);
        assert (treeItem != null);
        for (Node node : treeCells) {
            assert (node instanceof TreeCell);
            TreeCell treeCell = (TreeCell)node;
            if (treeItem.getValue() == null || !treeItem.getValue().equals(treeCell.getItem())) continue;
            return treeCell;
        }
        return null;
    }

    public static TreeCell<?> getTreeCell(Set<Node> treeCells, int index) {
        assert (treeCells != null);
        for (Node node : treeCells) {
            assert (node instanceof TreeCell);
            TreeCell treeCell = (TreeCell)node;
            if (treeCell.getIndex() != index) continue;
            return treeCell;
        }
        return null;
    }

    public static <T> boolean canReparentTreeItem(TreeItem<T> child, TreeItem<T> parent) {
        if (child == parent) {
            return false;
        }
        int childLevel = Deprecation.getNodeLevel(child);
        for (int parentLevel = Deprecation.getNodeLevel(parent); parentLevel >= childLevel; --parentLevel) {
            if (parent == child) {
                return false;
            }
            parent = parent.getParent();
        }
        return true;
    }

    public static <T> TreeItem<T> getCommonParentTreeItem(List<TreeItem<T>> treeItems) {
        assert (treeItems != null && !treeItems.isEmpty());
        for (TreeItem<T> treeItem : treeItems) {
            if (Deprecation.getNodeLevel(treeItem) != 0) continue;
            return treeItem;
        }
        if (treeItems.size() == 1) {
            return treeItems.get(0).getParent();
        }
        assert (treeItems.size() >= 2);
        TreeItem<T> parent = null;
        TreeItem<T> child = treeItems.get(0);
        for (int index = 1; index < treeItems.size() && Deprecation.getNodeLevel(parent = HierarchyTreeViewUtils.getCommonParentTreeItem(child, treeItems.get(index))) != 0; ++index) {
            child = parent;
        }
        return parent;
    }

    private static <T> TreeItem<T> getCommonParentTreeItem(TreeItem<T> child1, TreeItem<T> child2) {
        int child2Level;
        int child1Level;
        assert (child1 != null && child2 != null);
        assert (child1Level > 0 && child2Level > 0);
        TreeItem parent1 = child1.getParent();
        TreeItem parent2 = child2.getParent();
        if (child1Level < child2Level) {
            for (child2Level = Deprecation.getNodeLevel(child2); child1Level < child2Level; --child2Level) {
                parent2 = parent2.getParent();
            }
            if (parent1 == parent2) {
                return parent1;
            }
            while (parent1 != parent2) {
                parent1 = parent1.getParent();
                parent2 = parent2.getParent();
            }
            return parent1;
        }
        for (child1Level = Deprecation.getNodeLevel(child1); child1Level > child2Level; --child1Level) {
            parent1 = parent1.getParent();
        }
        if (parent1 == parent2) {
            return parent1;
        }
        while (parent1 != parent2) {
            parent1 = parent1.getParent();
            parent2 = parent2.getParent();
        }
        return parent1;
    }
}

