/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.pring;

import com.oracle.javafx.scenebuilder.kit.editor.panel.content.AbstractDecoration;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.ContentPanelController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.gesture.AbstractGesture;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import javafx.scene.Node;
import javafx.scene.paint.Paint;

public abstract class AbstractPring<T>
extends AbstractDecoration<T> {
    public static final String PARENT_RING_CLASS = "parent-ring";
    private static final String PRING = "PRING";

    public AbstractPring(ContentPanelController contentPanelController, FXOMObject fxomObject, Class<T> sceneGraphClass) {
        super(contentPanelController, fxomObject, sceneGraphClass);
    }

    public abstract void changeStroke(Paint var1);

    public abstract AbstractGesture findGesture(Node var1);

    public static AbstractPring<?> lookupPring(Node node) {
        AbstractPring result;
        assert (node != null);
        assert (!node.isMouseTransparent());
        Object value = node.getProperties().get((Object)PRING);
        if (value instanceof AbstractPring) {
            result = (AbstractPring)value;
        } else {
            assert (value == null);
            result = null;
        }
        return result;
    }

    public static void attachPring(Node node, AbstractPring<?> pring) {
        assert (node != null);
        assert (!node.isMouseTransparent());
        assert (AbstractPring.lookupPring(node) == null);
        if (pring == null) {
            node.getProperties().remove((Object)PRING);
        } else {
            node.getProperties().put((Object)PRING, pring);
        }
    }
}

