/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.job.BatchDocumentJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.job.UseComputedSizesObjectJob;
import com.oracle.javafx.scenebuilder.kit.editor.selection.GridSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.ObjectSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.Selection;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.metadata.util.DesignHierarchyMask;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class UseComputedSizesSelectionJob
extends BatchDocumentJob {
    public UseComputedSizesSelectionJob(EditorController editorController) {
        super(editorController);
    }

    @Override
    protected List<Job> makeSubJobs() {
        ArrayList<Job> result = new ArrayList<Job>();
        HashSet<FXOMInstance> candidates = new HashSet<FXOMInstance>();
        Selection selection = this.getEditorController().getSelection();
        if (selection.getGroup() instanceof ObjectSelectionGroup) {
            ObjectSelectionGroup osg = (ObjectSelectionGroup)selection.getGroup();
            for (FXOMObject fxomObject : osg.getItems()) {
                if (!(fxomObject instanceof FXOMInstance)) continue;
                candidates.add((FXOMInstance)fxomObject);
            }
        } else if (selection.getGroup() instanceof GridSelectionGroup) {
            GridSelectionGroup gsg = (GridSelectionGroup)selection.getGroup();
            FXOMObject gridPane = gsg.getParentObject();
            DesignHierarchyMask mask = new DesignHierarchyMask(gridPane);
            for (int index : gsg.getIndexes()) {
                FXOMObject constraints;
                switch (gsg.getType()) {
                    case COLUMN: {
                        constraints = mask.getColumnConstraintsAtIndex(index);
                        break;
                    }
                    case ROW: {
                        constraints = mask.getRowConstraintsAtIndex(index);
                        break;
                    }
                    default: {
                        assert (false);
                        return result;
                    }
                }
                assert (constraints instanceof FXOMInstance);
                candidates.add((FXOMInstance)constraints);
            }
        } else assert (selection.getGroup() == null) : "Add implementation for " + selection.getGroup();
        for (FXOMInstance candidate : candidates) {
            UseComputedSizesObjectJob subJob = new UseComputedSizesObjectJob(candidate, this.getEditorController());
            if (!subJob.isExecutable()) continue;
            result.add(subJob);
        }
        return result;
    }

    @Override
    protected String makeDescription() {
        String result;
        switch (this.getSubJobs().size()) {
            case 0: {
                result = "Unexecutable Use Computed Sizes";
                break;
            }
            case 1: {
                result = this.getSubJobs().get(0).getDescription();
                break;
            }
            default: {
                result = this.makeMultipleSelectionDescription();
            }
        }
        return result;
    }

    private String makeMultipleSelectionDescription() {
        StringBuilder result = new StringBuilder();
        result.append("Use Computed Sizes on ");
        result.append(this.getSubJobs().size());
        result.append(" Objects");
        return result.toString();
    }
}

