/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.rest.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.ws.inspections.fixes.RemoveElementFix;
import com.intellij.ws.rest.RSBundle;
import com.intellij.ws.rest.inspections.AbstractRestJavaInspection;
import com.intellij.ws.rest.utils.RSUtils;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ValidMimeAnnotationInspection
extends AbstractRestJavaInspection {
    @NonNls
    private static final Pattern myPattern = Pattern.compile("[^\\p{Cc}^\\s]+/[^\\p{Cc}^\\s]+");

    @Override
    protected void checkMethod(@NotNull PsiMethod psiMethod, @NotNull ProblemsHolder problemsHolder, @NotNull Module module) {
        PsiModifierList modifiers;
        if (psiMethod == null) {
            ValidMimeAnnotationInspection.$$$reportNull$$$0(0);
        }
        if (problemsHolder == null) {
            ValidMimeAnnotationInspection.$$$reportNull$$$0(1);
        }
        if (module == null) {
            ValidMimeAnnotationInspection.$$$reportNull$$$0(2);
        }
        if ((modifiers = psiMethod.getModifierList()) == null) {
            return;
        }
        ValidMimeAnnotationInspection.checkMime(modifiers.findAnnotation("javax.ws.rs.ConsumeMime"), problemsHolder);
        ValidMimeAnnotationInspection.checkMime(modifiers.findAnnotation("javax.ws.rs.Consumes"), problemsHolder);
        ValidMimeAnnotationInspection.checkMime(modifiers.findAnnotation("javax.ws.rs.ProduceMime"), problemsHolder);
        ValidMimeAnnotationInspection.checkMime(modifiers.findAnnotation("javax.ws.rs.Produces"), problemsHolder);
    }

    private static void checkMime(PsiAnnotation anno, ProblemsHolder problemsHolder) {
        if (anno == null) {
            return;
        }
        String mime = RSUtils.getAnnotationValue(anno);
        PsiNameValuePair[] attrs = anno.getParameterList().getAttributes();
        if (mime == null || attrs.length == 0) {
            return;
        }
        if (!myPattern.matcher(mime).matches()) {
            problemsHolder.registerProblem((PsiElement)attrs[0], RSBundle.message("webservices.inspections.rest.annotation.has.wrong.mime.type.problem", new Object[0]), ProblemHighlightType.ERROR, new LocalQuickFix[]{new RemoveElementFix((PsiElement)attrs[0], RSBundle.message("webservices.inspections.rest.annotation.has.wrong.mime.type.fix", new Object[0]))});
        }
    }

    protected void doCheckClass(PsiClass c, ProblemsHolder problemsHolder) {
    }

    @NotNull
    public String getDisplayName() {
        String string = RSBundle.message("webservices.inspections.rest.annotation.has.wrong.mime.type.display.name", new Object[0]);
        if (string == null) {
            ValidMimeAnnotationInspection.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        String string = RSBundle.message("webservices.inspections.rest.annotation.has.wrong.mime.type.short.name", new Object[0]);
        if (string == null) {
            ValidMimeAnnotationInspection.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemsHolder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/rest/inspections/ValidMimeAnnotationInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/rest/inspections/ValidMimeAnnotationInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkMethod";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

