/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.rest.inspections;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.javaee.util.UriTemplateParser;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.impl.java.stubs.index.JavaAnnotationIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ws.rest.RSBundle;
import com.intellij.ws.rest.inspections.AbstractRestJavaInspection;
import com.intellij.ws.rest.inspections.fixes.AnnotateElementWithPathParamFix;
import com.intellij.ws.rest.inspections.fixes.CreateFieldWithPathParamFix;
import com.intellij.ws.rest.inspections.fixes.CreateMethodParamWithPathParamFix;
import com.intellij.ws.rest.utils.RSUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PathAnnotationInspection
extends AbstractRestJavaInspection {
    @Override
    protected void checkMethod(@NotNull PsiMethod psiMethod, @NotNull ProblemsHolder holder, @NotNull Module module) {
        if (psiMethod == null) {
            PathAnnotationInspection.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            PathAnnotationInspection.$$$reportNull$$$0(1);
        }
        if (module == null) {
            PathAnnotationInspection.$$$reportNull$$$0(2);
        }
        PathAnnotationInspection.checkPathSyntax((PsiTypeParameterListOwner)psiMethod, holder);
    }

    @Override
    protected void checkClass(PsiClass aClass, ProblemsHolder holder, @NotNull Module module) {
        if (module == null) {
            PathAnnotationInspection.$$$reportNull$$$0(3);
        }
        PathAnnotationInspection.checkPathSyntax((PsiTypeParameterListOwner)aClass, holder);
    }

    private static void checkPathSyntax(PsiTypeParameterListOwner c, ProblemsHolder problemsHolder) {
        PsiAnnotation pathAnno = AnnotationUtil.findAnnotation((PsiModifierListOwner)c, (String[])new String[]{"javax.ws.rs.Path"});
        if (pathAnno != null) {
            ArrayList<String> names;
            String path = RSUtils.getAnnotationValue(pathAnno);
            if (StringUtil.isEmpty((String)path)) {
                return;
            }
            PsiNameValuePair[] attributes = pathAnno.getParameterList().getAttributes();
            if (attributes.length != 1 || attributes[0] == null) {
                return;
            }
            PsiNameValuePair valueAttr = attributes[0];
            try {
                UriTemplateParser parser = new UriTemplateParser(path);
                names = new ArrayList<String>(parser.getNames());
            }
            catch (Exception e) {
                problemsHolder.registerProblem((PsiElement)valueAttr, RSBundle.message("webservices.inspections.wrong.path.annotation.value.problem", new Object[0]), ProblemHighlightType.GENERIC_ERROR, new LocalQuickFix[0]);
                return;
            }
            if (!names.isEmpty()) {
                PathAnnotationInspection.checkPathNames((PsiElement)c, names, problemsHolder, pathAnno);
            }
        }
    }

    private static void findSamePathAnnotations(PsiTypeParameterListOwner c, ProblemsHolder problemsHolder, PsiAnnotation pathAnno, String path) {
        Project project = c.getProject();
        Collection annos = JavaAnnotationIndex.getInstance().get("Path", project, GlobalSearchScope.projectScope((Project)project));
        if (annos.size() > 1) {
            for (PsiAnnotation anno : annos) {
                if (anno == pathAnno || !RSUtils.isNonAbstractAndPublicClass(RSUtils.getParent(anno)) || !path.equals(RSUtils.getAnnotationValue(anno))) continue;
                PsiClass parent = RSUtils.getParent(anno);
                problemsHolder.registerProblem((PsiElement)pathAnno, RSBundle.message("webservices.inspections.ambiguous.path.annotation.problem", parent == null ? "" : parent.getQualifiedName()), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
            }
        }
    }

    private static void checkPathNames(PsiElement c, final List<String> names, ProblemsHolder problemsHolder, PsiAnnotation pathAnno) {
        c.acceptChildren((PsiElementVisitor)new PsiRecursiveElementVisitor(){

            public void visitElement(PsiElement element) {
                if (element instanceof PsiAnnotation && "javax.ws.rs.PathParam".equals(((PsiAnnotation)element).getQualifiedName())) {
                    String param = RSUtils.getAnnotationValue((PsiAnnotation)element);
                    if (names.contains(param)) {
                        names.remove(param);
                    }
                } else {
                    super.visitElement(element);
                }
            }
        });
        for (String name : names) {
            PathAnnotationInspection.selectNotUsedPathTemplate(name, pathAnno, problemsHolder);
        }
    }

    private static void selectNotUsedPathTemplate(String name, PsiAnnotation pathAnno, ProblemsHolder problemsHolder) {
        PsiNameValuePair[] attributes = pathAnno.getParameterList().getAttributes();
        if (attributes.length == 1) {
            PsiClass context;
            PsiAnnotationMemberValue value = attributes[0].getValue();
            String problemText = "{" + name + "}";
            if (value instanceof PsiLiteralExpression && value.getText().contains(problemText)) {
                int start = value.getText().indexOf(problemText);
                int end = start + problemText.length();
                PsiClass context2 = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)pathAnno, PsiClass.class);
                if (context2 != null) {
                    PsiField field = null;
                    for (PsiField psiField : context2.getFields()) {
                        if (!name.equals(psiField.getName())) continue;
                        field = psiField;
                        break;
                    }
                    PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)value, PsiMethod.class);
                    problemsHolder.registerProblem((PsiElement)value, RSBundle.message("webservices.inspections.unused.path.template", name), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new TextRange(start, end), new LocalQuickFix[]{method != null ? new CreateMethodParamWithPathParamFix(name, method) : (field == null ? new CreateFieldWithPathParamFix(name, context2) : new AnnotateElementWithPathParamFix(field, name))});
                }
            } else if (value instanceof PsiReferenceExpression && (context = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)pathAnno, PsiClass.class)) != null) {
                PsiField field = null;
                for (PsiField psiField : context.getFields()) {
                    if (!name.equals(psiField.getName())) continue;
                    field = psiField;
                    break;
                }
                problemsHolder.registerProblem((PsiElement)value, RSBundle.message("webservices.inspections.unused.path.template", name), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{field == null ? new CreateFieldWithPathParamFix(name, context) : new AnnotateElementWithPathParamFix(field, name)});
            }
        }
    }

    @NotNull
    public String getDisplayName() {
        String string = RSBundle.message("webservices.inspections.ambiguous.path.annotation.display.name", new Object[0]);
        if (string == null) {
            PathAnnotationInspection.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("PathAnnotation" == null) {
            PathAnnotationInspection.$$$reportNull$$$0(5);
        }
        return "PathAnnotation";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/rest/inspections/PathAnnotationInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/rest/inspections/PathAnnotationInspection";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkMethod";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkClass";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

