/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.rest;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProvider;
import com.intellij.icons.AllIcons;
import com.intellij.javaee.model.xml.ParamValue;
import com.intellij.javaee.model.xml.web.Filter;
import com.intellij.javaee.model.xml.web.WebApp;
import com.intellij.javaee.web.WebUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.jsp.WebDirectoryElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ConstantFunction;
import com.intellij.util.Function;
import com.intellij.ws.rest.JaxRsLineMarkerInfo;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JaxRsLineMarkerProvider
implements LineMarkerProvider {
    @NonNls
    private static final String[] JSP_EXT = new String[]{"jsp", "jspx"};
    @NonNls
    private static final String[] ALLOWED_EXTENSIONS = new String[]{"jsp", "jspx", "conf", "ssp", "scaml", "jade"};

    public LineMarkerInfo getLineMarkerInfo(@NotNull PsiElement context) {
        if (context == null) {
            JaxRsLineMarkerProvider.$$$reportNull$$$0(0);
        }
        if (context instanceof PsiIdentifier) {
            PsiElement element = context.getParent();
            if (element instanceof PsiClass) {
                Module module;
                PsiClass psiClass = (PsiClass)element;
                String fqn = psiClass.getQualifiedName();
                WebFacet facet = WebUtil.getWebFacet((PsiElement)psiClass);
                if (fqn != null && facet != null && (module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element)) != null && JaxRsLineMarkerProvider.isRestEnabled(module)) {
                    VirtualFile file;
                    String path = JaxRsLineMarkerProvider.fixPath(facet, fqn.replaceAll("\\.", "/"));
                    WebDirectoryElement webElement = WebUtil.getWebUtil().findWebDirectoryElement(path, facet);
                    if (webElement != null && (file = webElement.getOriginalVirtualFile()) != null && file.isDirectory()) {
                        boolean enabled = false;
                        for (VirtualFile f : file.getChildren()) {
                            if (!JaxRsLineMarkerProvider.isAllowedExt(f)) continue;
                            enabled = true;
                            break;
                        }
                        if (enabled) {
                            JaxRsLineMarkerInfo info = new JaxRsLineMarkerInfo((PsiIdentifier)context, file);
                            return info;
                        }
                    }
                }
            }
        } else if (context instanceof PsiJavaFile && JaxRsLineMarkerProvider.isJSP(context.getContainingFile().getVirtualFile())) {
            WebApp app;
            WebFacet facet = WebUtil.getWebFacet((PsiElement)context);
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)context);
            if (facet != null && module != null && (app = facet.getRoot()) != null && JaxRsLineMarkerProvider.isRestEnabled(module)) {
                String path;
                VirtualFile vf = context.getContainingFile().getVirtualFile();
                assert (vf != null);
                String jspPath = vf.getPath();
                String base = JaxRsLineMarkerProvider.fixPath(facet, null);
                if (base == null && jspPath != null) {
                    for (VirtualFile file : facet.getFacetRoots()) {
                        if (!jspPath.startsWith(file.getPath())) continue;
                        base = file.getPath();
                    }
                }
                if (base != null && (path = vf.getParent().getPath()).startsWith(base) && base.length() < path.length()) {
                    String fqn = path.substring(base.length() + 1).replaceAll("\\\\", "/").replaceAll("/", ".");
                    PsiClass psiClass = JavaPsiFacade.getInstance((Project)module.getProject()).findClass(fqn, module.getModuleWithDependenciesAndLibrariesScope(false));
                    if (psiClass != null) {
                        LineMarkerInfo info = new LineMarkerInfo(context, context.getTextRange(), AllIcons.Nodes.PpWeb, 11, (Function)new ConstantFunction((Object)"Go to class"), (e, elt) -> psiClass.navigate(true), GutterIconRenderer.Alignment.RIGHT);
                        return info;
                    }
                }
            }
        }
        return null;
    }

    public static boolean isRestEnabled(Module module) {
        GlobalSearchScope scope = module.getModuleWithDependenciesAndLibrariesScope(false);
        return JavaPsiFacade.getInstance((Project)module.getProject()).findClass("javax.ws.rs.GET", scope) != null;
    }

    private static boolean isJSP(VirtualFile vf) {
        String extension;
        if (vf != null && (extension = vf.getExtension()) != null) {
            for (String ext : JSP_EXT) {
                if (!ext.equalsIgnoreCase(extension)) continue;
                return true;
            }
        }
        return false;
    }

    static boolean isAllowedExt(VirtualFile vf) {
        String extension;
        if (vf != null && (extension = vf.getExtension()) != null) {
            for (String ext : ALLOWED_EXTENSIONS) {
                if (!ext.equalsIgnoreCase(extension)) continue;
                return true;
            }
        }
        return false;
    }

    private static String fixPath(WebFacet facet, String s) {
        WebApp app = facet.getRoot();
        if (app != null) {
            for (Filter filter : app.getFilters()) {
                PsiClass psiClass = (PsiClass)filter.getFilterClass().getValue();
                if (psiClass == null || !"com.sun.jersey.spi.container.servlet.ServletContainer".equals(psiClass.getQualifiedName())) continue;
                for (ParamValue initParam : filter.getInitParams()) {
                    if (!"com.sun.jersey.config.property.JSPTemplatesBasePath".equals(initParam.getParamName().getStringValue())) continue;
                    String value = (String)initParam.getParamValue().getValue();
                    if (value == null) break;
                    String end = s == null ? "" : s;
                    return value.endsWith("/") ? value + end : value + "/" + end;
                }
                return s;
            }
        }
        return s;
    }

    private static void log(long offset) {
        long time = System.currentTimeMillis() - offset;
        if (time > 0L) {
            System.out.println(time + "ms");
        }
    }

    public void collectSlowLineMarkers(@NotNull List<PsiElement> elements, @NotNull Collection<LineMarkerInfo> result) {
        if (elements == null) {
            JaxRsLineMarkerProvider.$$$reportNull$$$0(1);
        }
        if (result == null) {
            JaxRsLineMarkerProvider.$$$reportNull$$$0(2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ws/rest/JaxRsLineMarkerProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getLineMarkerInfo";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "collectSlowLineMarkers";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

