/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.beanValidation.toolWindow.tree.nodes;

import com.intellij.beanValidation.model.xml.Bean;
import com.intellij.beanValidation.model.xml.BvField;
import com.intellij.beanValidation.model.xml.BvGetter;
import com.intellij.beanValidation.model.xml.Constraint;
import com.intellij.beanValidation.model.xml.ConstraintMappings;
import com.intellij.beanValidation.toolWindow.tree.nodes.AbstractBVNode;
import com.intellij.beanValidation.toolWindow.tree.nodes.AnnotatedMembersNode;
import com.intellij.beanValidation.toolWindow.tree.nodes.PsiMemberInXmlNode;
import com.intellij.beanValidation.toolWindow.tree.nodes.PsiMemberSimpleNode;
import com.intellij.beanValidation.toolWindow.tree.nodes.ValidatorNode;
import com.intellij.beanValidation.utils.BVUtils;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedMembersSearch;
import com.intellij.psi.xml.XmlFile;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.util.PlatformIcons;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SortedList;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import icons.BVCoreIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnnotationTypeNode
extends PsiMemberSimpleNode<PsiClass> {
    protected Module myModule;
    protected PsiClass myAnnoClass;
    private static final Comparator<AbstractBVNode> CONSTRAINT_OWNERS_COMPARATOR = (o1, o2) -> {
        if (((Object)o1).getClass() != ((Object)o2).getClass()) {
            return o1 instanceof AnnotatedMembersNode ? -1 : (o1 instanceof PsiMemberInXmlNode ? -1 : 1);
        }
        if (o1 instanceof AnnotatedMembersNode) {
            return Comparing.compare((Comparable)((Object)((AnnotatedMembersNode)((Object)o1)).getMember().getName()), (Comparable)((Object)((AnnotatedMembersNode)((Object)o2)).getMember().getName()));
        }
        if (o1 instanceof PsiMemberInXmlNode) {
            return Comparing.compare((Comparable)((Object)((PsiMemberInXmlNode)((Object)o1)).getMember().getName()), (Comparable)((Object)((PsiMemberInXmlNode)((Object)o2)).getMember().getName()));
        }
        if (o1 instanceof ValidatorNode) {
            return Comparing.compare((Comparable)((Object)((PsiClass)((ValidatorNode)((Object)o1)).getMember()).getName()), (Comparable)((Object)((PsiClass)((ValidatorNode)((Object)o2)).getMember()).getName()));
        }
        return 0;
    };

    public AnnotationTypeNode(@NotNull Module module, @NotNull PsiClass annoClass, SimpleNode parent) {
        if (module == null) {
            AnnotationTypeNode.$$$reportNull$$$0(0);
        }
        if (annoClass == null) {
            AnnotationTypeNode.$$$reportNull$$$0(1);
        }
        super(parent, annoClass);
        this.myModule = module;
        this.myAnnoClass = annoClass;
    }

    protected void update(@NotNull PresentationData presentation) {
        if (presentation == null) {
            AnnotationTypeNode.$$$reportNull$$$0(2);
        }
        super.update(presentation);
        Icon icon = BVUtils.isInLibrary((PsiElement)this.myAnnoClass) ? BVCoreIcons.LibAnnotation : PlatformIcons.ANNOTATION_TYPE_ICON;
        presentation.setIcon(icon);
        presentation.setTooltip(this.myAnnoClass.getQualifiedName());
        presentation.addText(this.myAnnoClass.getName(), this.getPlainAttributes());
    }

    protected void doUpdate() {
        super.doUpdate();
    }

    @Override
    @NotNull
    public SimpleNode[] getChildren() {
        SortedList children = new SortedList(CONSTRAINT_OWNERS_COMPARATOR);
        for (PsiMember psiMember : AnnotatedMembersSearch.search((PsiClass)this.myAnnoClass, (SearchScope)GlobalSearchScope.moduleWithLibrariesScope((Module)this.myModule)).findAll()) {
            children.add(new AnnotatedMembersNode<PsiMember>(psiMember, this));
        }
        Project project = this.myAnnoClass.getProject();
        for (XmlFile xmlFile : BVUtils.getConstraintFiles(this.myModule)) {
            DomFileElement fileElement = DomManager.getDomManager((Project)project).getFileElement(xmlFile, ConstraintMappings.class);
            if (fileElement == null) continue;
            ConstraintMappings mappings = (ConstraintMappings)fileElement.getRootElement();
            for (Bean bean : mappings.getBeans()) {
                PsiMember value;
                for (BvField field : bean.getFields()) {
                    for (Constraint constraint : field.getConstraints()) {
                        if (!this.myAnnoClass.equals(constraint.getAnnotation().getValue()) || (value = (PsiMember)field.getName().getValue()) == null) continue;
                        children.add(new PsiMemberInXmlNode(value, this, field.getName().getXmlAttributeValue()));
                    }
                }
                for (BvGetter getter : bean.getGetters()) {
                    for (Constraint constraint : getter.getConstraints()) {
                        if (!this.myAnnoClass.equals(constraint.getAnnotation().getValue()) || (value = (PsiMember)getter.getName().getValue()) == null) continue;
                        children.add(new PsiMemberInXmlNode(value, this, getter.getName().getXmlAttributeValue()));
                    }
                }
            }
        }
        for (PsiClass validator : AnnotationTypeNode.getValidators(this.myAnnoClass)) {
            children.add(new ValidatorNode((SimpleNode)this, validator));
        }
        SimpleNode[] simpleNodeArray = children.toArray(new SimpleNode[0]);
        if (simpleNodeArray == null) {
            AnnotationTypeNode.$$$reportNull$$$0(3);
        }
        return simpleNodeArray;
    }

    @NotNull
    public Object[] getEqualityObjects() {
        Object[] objectArray = new Object[]{this.myAnnoClass};
        if (objectArray == null) {
            AnnotationTypeNode.$$$reportNull$$$0(4);
        }
        return objectArray;
    }

    protected List<PsiClass> findAnnotatedClasses() {
        return this.findAnnotatedMembers(PsiClass.class);
    }

    protected List<PsiMethod> findAnnotatedMethods() {
        return this.findAnnotatedMembers(PsiMethod.class);
    }

    protected <T extends PsiModifierListOwner> List<T> findAnnotatedMembers(Class<T> clazz) {
        ArrayList result = ContainerUtil.newArrayList();
        Processor processor = t -> {
            ContainerUtil.addIfNotNull((Collection)result, (Object)t);
            return true;
        };
        JamCommonUtil.findAnnotatedElements(clazz, (String)this.myAnnoClass.getQualifiedName(), (PsiManager)PsiManager.getInstance((Project)this.myModule.getProject()), (GlobalSearchScope)GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)this.myModule), (Processor)processor);
        return result;
    }

    private static List<PsiClass> getValidators(PsiClass constraint) {
        PsiAnnotation annotation;
        PsiModifierList modifierList = constraint.getModifierList();
        if (modifierList != null && (annotation = modifierList.findAnnotation("javax.validation.Constraint")) != null) {
            PsiAnnotationMemberValue memberValue = annotation.findAttributeValue("validatedBy");
            return ContainerUtil.mapNotNull((Collection)AnnotationUtil.arrayAttributeValues((PsiAnnotationMemberValue)memberValue), AnnotationTypeNode::getPsiClass);
        }
        return Collections.emptyList();
    }

    @Nullable
    public static PsiClass getPsiClass(PsiAnnotationMemberValue psiAnnotationMemberValue) {
        Object value;
        PsiClass psiClass = null;
        if (psiAnnotationMemberValue instanceof PsiClassObjectAccessExpression) {
            PsiType type = ((PsiClassObjectAccessExpression)psiAnnotationMemberValue).getOperand().getType();
            if (type instanceof PsiClassType) {
                psiClass = ((PsiClassType)type).resolve();
            }
        } else if (psiAnnotationMemberValue instanceof PsiExpression && (value = JamCommonUtil.computeMemberValue((PsiElement)psiAnnotationMemberValue)) instanceof String) {
            String className = StringUtil.stripQuotesAroundValue((String)((String)value));
            psiClass = JavaPsiFacade.getInstance((Project)psiAnnotationMemberValue.getProject()).findClass(className, psiAnnotationMemberValue.getResolveScope());
        }
        if (psiClass != null && "java.lang.Object".equals(psiClass.getQualifiedName())) {
            return null;
        }
        return psiClass;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annoClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/beanValidation/toolWindow/tree/nodes/AnnotationTypeNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/beanValidation/toolWindow/tree/nodes/AnnotationTypeNode";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getEqualityObjects";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

