/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.aspectj.setup;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.facet.FacetType;
import com.intellij.lang.aspectj.AspectJBundle;
import com.intellij.lang.aspectj.build.config.AjIdeaCompilerSettings;
import com.intellij.lang.aspectj.facet.AjFacet;
import com.intellij.lang.aspectj.facet.AjFacetConfiguration;
import com.intellij.lang.aspectj.facet.AjFacetType;
import com.intellij.lang.aspectj.util.LibraryUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.util.PairConsumer;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.importing.FacetImporter;
import org.jetbrains.idea.maven.importing.MavenRootModelAdapter;
import org.jetbrains.idea.maven.importing.configurers.MavenCompilerConfigurer;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenPlugin;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectsProcessorTask;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.utils.MavenJDOMUtil;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class AjMavenImporter
extends FacetImporter<AjFacet, AjFacetConfiguration, AjFacetType> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.aspectj.setup.AjMavenImporter");

    public AjMavenImporter() {
        super("org.codehaus.mojo", "aspectj-maven-plugin", FacetType.findInstance(AjFacetType.class));
    }

    public boolean isApplicable(MavenProject mavenProject) {
        return this.findActivePlugin(mavenProject) != null;
    }

    public void collectSourceRoots(MavenProject mavenProject, PairConsumer<String, JpsModuleSourceRootType<?>> result) {
        MavenPlugin plugin = this.findActivePlugin(mavenProject);
        if (plugin != null) {
            Element configuration = AjMavenImporter.getConfiguration(plugin);
            String srcPath = MavenJDOMUtil.findChildValueByPath((Element)configuration, (String)"aspectDirectory", (String)"src/main/aspect");
            result.consume((Object)(mavenProject.getDirectory() + "/" + srcPath), (Object)JavaSourceRootType.SOURCE);
            String testPath = MavenJDOMUtil.findChildValueByPath((Element)configuration, (String)"testAspectDirectory", (String)"src/test/aspect");
            result.consume((Object)(mavenProject.getDirectory() + "/" + testPath), (Object)JavaSourceRootType.TEST_SOURCE);
        }
    }

    protected void setupFacet(AjFacet facet, MavenProject mavenProject) {
    }

    protected void reimportFacet(IdeModifiableModelsProvider modelsProvider, Module module, MavenRootModelAdapter rootModel, AjFacet facet, MavenProjectsTree mavenTree, MavenProject mavenProject, MavenProjectChanges changes, Map<MavenProject, String> mavenProjectToModuleName, List<MavenProjectsProcessorTask> postTasks) {
        MavenPlugin plugin = this.findActivePlugin(mavenProject);
        if (plugin != null) {
            Element pluginConfig = AjMavenImporter.getConfiguration(plugin);
            AjMavenImporter.setCompilationOptions(module, rootModel, pluginConfig);
            AjMavenImporter.setAspectPath(facet, rootModel, mavenProject, pluginConfig);
        }
    }

    @Nullable
    private MavenPlugin findActivePlugin(MavenProject project) {
        return AjMavenImporter.findActivePlugin(project, this.myPluginGroupID, this.myPluginArtifactID);
    }

    @Nullable
    static MavenPlugin findActivePlugin(MavenProject project, @Nullable String groupId, @Nullable String artifactId) {
        MavenPlugin plugin = project.findPlugin(groupId, artifactId, true);
        if (plugin != null && !"true".equals(MavenJDOMUtil.findChildValueByPath((Element)plugin.getConfigurationElement(), (String)"skip"))) {
            for (MavenPlugin.Execution exec : plugin.getExecutions()) {
                for (String goal : exec.getGoals()) {
                    if (!"compile".equals(goal) && !"test-compile".equals(goal)) continue;
                    return plugin;
                }
            }
        }
        return null;
    }

    private static Element getConfiguration(MavenPlugin plugin) {
        Element configuration = plugin.getConfigurationElement();
        if (configuration == null) {
            configuration = plugin.getGoalConfiguration("compile");
        }
        if (configuration == null) {
            configuration = plugin.getGoalConfiguration("test-compile");
        }
        return configuration;
    }

    private static void setCompilationOptions(Module module, MavenRootModelAdapter rootModel, Element pluginConfig) {
        String showWeaveInfo;
        String lint;
        LanguageLevel languageLevel;
        String source;
        String target;
        String compliance = MavenJDOMUtil.findChildValueByPath((Element)pluginConfig, (String)"complianceLevel");
        String string = target = compliance != null ? compliance : MavenJDOMUtil.findChildValueByPath((Element)pluginConfig, (String)"target");
        if (target != null) {
            CompilerConfiguration configuration = CompilerConfiguration.getInstance((Project)module.getProject());
            configuration.setBytecodeTargetLevel(module, target);
            module.putUserData(MavenCompilerConfigurer.IGNORE_MAVEN_COMPILER_TARGET_KEY, (Object)Boolean.TRUE);
        }
        String string2 = source = compliance != null ? compliance : MavenJDOMUtil.findChildValueByPath((Element)pluginConfig, (String)"source");
        if (source != null && (languageLevel = LanguageLevel.parse((String)source)) != null) {
            rootModel.setLanguageLevel(languageLevel);
        }
        if ((lint = MavenJDOMUtil.findChildValueByPath((Element)pluginConfig, (String)"Xlint")) != null) {
            AjIdeaCompilerSettings.getSettings(module.getProject()).setOption("-Xlint.*", "-Xlint:" + lint);
        }
        if ("true".equals(showWeaveInfo = MavenJDOMUtil.findChildValueByPath((Element)pluginConfig, (String)"showWeaveInfo"))) {
            AjIdeaCompilerSettings.getSettings(module.getProject()).setOption("-showWeaveInfo", "-showWeaveInfo");
        }
    }

    private static void setAspectPath(AjFacet facet, MavenRootModelAdapter rootModel, MavenProject mavenProject, Element pluginConfig) {
        ArrayList aspectPath = ContainerUtil.newArrayList();
        Element libraries = MavenJDOMUtil.findChildByPath((Element)pluginConfig, (String)"aspectLibraries");
        if (libraries != null) {
            Project project = rootModel.getRootModel().getProject();
            String moduleName = rootModel.getModule().getName();
            for (Element child : libraries.getChildren()) {
                String groupId = child.getChildTextTrim("groupId");
                String artifactId = child.getChildTextTrim("artifactId");
                if (groupId == null || artifactId == null) continue;
                List artifacts = mavenProject.findDependencies(groupId, artifactId);
                Iterator iterator = artifacts.iterator();
                while (iterator.hasNext()) {
                    MavenArtifact artifact = (MavenArtifact)iterator.next();
                    String scope = artifact.getScope();
                    if ("compile".equals(scope) || "provided".equals(scope)) continue;
                    iterator.remove();
                }
                if (artifacts.size() != 1) {
                    LOG.info("looking for [" + groupId + ":" + artifactId + "], found " + artifacts);
                    AjMavenImporter.warn(AspectJBundle.message("maven.importer.aspect.library", groupId, artifactId, moduleName), project);
                    continue;
                }
                Library library = rootModel.findLibrary((MavenArtifact)artifacts.get(0));
                if (library != null) {
                    aspectPath.add(LibraryUtil.create(library));
                    continue;
                }
                Module module = rootModel.findModuleByName(artifactId);
                if (module != null) {
                    aspectPath.add(LibraryUtil.create(module));
                    continue;
                }
                AjMavenImporter.warn(AspectJBundle.message("maven.importer.aspect.library", groupId, artifactId, moduleName), project);
            }
        }
        AjFacetConfiguration.getSettings((AjFacet)facet).aspectPath = aspectPath;
    }

    static void warn(String message, @Nullable Project project) {
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            String title = AspectJBundle.message("plugin.title", new Object[0]);
            Notifications.Bus.notify((Notification)new Notification("AspectJ", title, message, NotificationType.WARNING), (Project)project);
        } else {
            LOG.error(message);
        }
    }
}

