/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.aspectj.refactoring.pushIn;

import com.intellij.lang.aspectj.AspectJBundle;
import com.intellij.lang.aspectj.psi.PsiAspect;
import com.intellij.lang.aspectj.psi.PsiInterTypeClass;
import com.intellij.lang.aspectj.psi.PsiInterTypeField;
import com.intellij.lang.aspectj.psi.PsiInterTypeMethod;
import com.intellij.lang.aspectj.refactoring.pushIn.InterTypeUsageInfo;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.refactoring.util.RefactoringConflictsUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PushInConflictsUtil {
    private PushInConflictsUtil() {
    }

    public static void checkNameConflicts(@NotNull Collection<InterTypeUsageInfo> usages, @NotNull MultiMap<PsiElement, String> conflicts) {
        if (usages == null) {
            PushInConflictsUtil.$$$reportNull$$$0(0);
        }
        if (conflicts == null) {
            PushInConflictsUtil.$$$reportNull$$$0(1);
        }
        MultiMap methods = MultiMap.create();
        MultiMap fields = MultiMap.create();
        MultiMap classes = MultiMap.create();
        Iterator<InterTypeUsageInfo> iterator = usages.iterator();
        while (iterator.hasNext()) {
            PsiClass conflict;
            InterTypeUsageInfo usage = iterator.next();
            PsiClass target = usage.getTarget();
            if (target == null) continue;
            PsiElement element = usage.getElement();
            if (element instanceof PsiInterTypeMethod) {
                PsiInterTypeMethod method = (PsiInterTypeMethod)element;
                conflict = PushInConflictsUtil.checkMethodConflicts(method, target, (MultiMap<PsiClass, PsiInterTypeMethod>)methods);
                if (conflict != null) {
                    conflicts.putValue((Object)element, (Object)AspectJBundle.message("action.push.in.method.conflict", method.getName(), conflict.getQualifiedName()));
                    iterator.remove();
                    continue;
                }
                methods.putValue((Object)target, (Object)method);
                continue;
            }
            if (element instanceof PsiInterTypeField) {
                PsiInterTypeField field = (PsiInterTypeField)element;
                conflict = PushInConflictsUtil.checkFieldConflicts(field, target, (MultiMap<PsiClass, PsiInterTypeField>)fields);
                if (conflict != null) {
                    conflicts.putValue((Object)element, (Object)AspectJBundle.message("action.push.in.field.conflict", field.getName(), conflict.getQualifiedName()));
                    iterator.remove();
                    continue;
                }
                fields.putValue((Object)target, (Object)field);
                continue;
            }
            if (!(element instanceof PsiInterTypeClass)) continue;
            PsiInterTypeClass aClass = (PsiInterTypeClass)element;
            conflict = PushInConflictsUtil.checkClassConflicts(aClass, target, (MultiMap<PsiClass, PsiInterTypeClass>)classes);
            if (conflict != null) {
                String name = target.getName() + "." + aClass.getName();
                conflicts.putValue((Object)element, (Object)AspectJBundle.message("action.push.in.class.conflict", name, conflict.getQualifiedName()));
                iterator.remove();
                continue;
            }
            classes.putValue((Object)target, (Object)aClass);
        }
    }

    @Nullable
    private static PsiClass checkMethodConflicts(PsiInterTypeMethod method, PsiClass target, MultiMap<PsiClass, PsiInterTypeMethod> methods) {
        PsiMethod[] ownMethods;
        for (PsiMethod ownMethod : ownMethods = target.findMethodsBySignature((PsiMethod)method, false)) {
            if (ownMethod == method || ownMethod.getParent() != target) continue;
            return target;
        }
        MethodSignature signature = method.getSignature(PsiSubstitutor.EMPTY);
        Collection extMethods = methods.get((Object)target);
        for (PsiInterTypeMethod extMethod : extMethods) {
            if (extMethod == method || !MethodSignatureUtil.areSignaturesEqual((MethodSignature)signature, (MethodSignature)extMethod.getSignature(PsiSubstitutor.EMPTY))) continue;
            return extMethod.getAspect();
        }
        return null;
    }

    @Nullable
    private static PsiClass checkFieldConflicts(PsiInterTypeField field, PsiClass target, MultiMap<PsiClass, PsiInterTypeField> fields) {
        String name = field.getName();
        PsiField ownField = target.findFieldByName(name, false);
        if (ownField != null && ownField != field && ownField.getParent() == target) {
            return target;
        }
        Collection extFields = fields.get((Object)target);
        for (PsiInterTypeField extField : extFields) {
            if (!name.equals(extField.getName())) continue;
            return extField.getAspect();
        }
        return null;
    }

    @Nullable
    private static PsiClass checkClassConflicts(PsiInterTypeClass aClass, PsiClass target, MultiMap<PsiClass, PsiInterTypeClass> classes) {
        String name = aClass.getName();
        PsiClass ownClass = target.findInnerClassByName(name, false);
        if (ownClass != null && ownClass != aClass && ownClass.getParent() == target) {
            return target;
        }
        Collection extClasses = classes.get((Object)target);
        for (PsiInterTypeClass extClass : extClasses) {
            if (!name.equals(extClass.getName())) continue;
            return extClass.getAspect();
        }
        return null;
    }

    public static void checkReferenceConflicts(@NotNull Collection<? extends InterTypeUsageInfo> usages, @NotNull MultiMap<PsiElement, String> conflicts) {
        PsiClass target;
        if (usages == null) {
            PushInConflictsUtil.$$$reportNull$$$0(2);
        }
        if (conflicts == null) {
            PushInConflictsUtil.$$$reportNull$$$0(3);
        }
        MultiMap groups = MultiMap.create();
        for (InterTypeUsageInfo interTypeUsageInfo : usages) {
            target = interTypeUsageInfo.getTarget();
            PsiAspect source = interTypeUsageInfo.getSource();
            PsiElement element = interTypeUsageInfo.getElement();
            if (target == null || source == null || !(element instanceof PsiMember)) continue;
            groups.putValue((Object)Pair.create((Object)target, (Object)source), (Object)((PsiMember)element));
        }
        for (Map.Entry entry : groups.entrySet()) {
            target = (PsiClass)((Pair)entry.getKey()).first;
            HashSet members = ContainerUtil.newHashSet((Iterable)((Iterable)entry.getValue()));
            for (PsiMember member : members) {
                RefactoringConflictsUtil.checkUsedElements((PsiMember)member, (PsiElement)member, (Set)members, null, (PsiClass)target, (PsiElement)target, conflicts);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflicts";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/aspectj/refactoring/pushIn/PushInConflictsUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkNameConflicts";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "checkReferenceConflicts";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

