/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.aspectj.psi.stub;

import com.intellij.lang.ASTNode;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.aspectj.psi.PsiAspect;
import com.intellij.lang.aspectj.psi.impl.PsiAspectImpl;
import com.intellij.lang.aspectj.psi.stub.AjStubElementType;
import com.intellij.lang.aspectj.psi.stub.PsiAspectStub;
import com.intellij.lang.aspectj.psi.stub.impl.PsiAspectStubImpl;
import com.intellij.lang.aspectj.psi.stub.impl.StubBaseWithFlags;
import com.intellij.lang.aspectj.psi.tree.AspectElement;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.impl.cache.RecordUtil;
import com.intellij.psi.impl.java.stubs.PsiClassStub;
import com.intellij.psi.impl.java.stubs.PsiJavaFileStub;
import com.intellij.psi.impl.java.stubs.index.JavaStubIndexKeys;
import com.intellij.psi.impl.source.tree.JavaDocElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.CharTable;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class AjAspectElementType
extends AjStubElementType<PsiAspectStub, PsiAspect> {
    public AjAspectElementType() {
        super("ASPECT");
    }

    @NotNull
    public ASTNode createCompositeNode() {
        AspectElement aspectElement = new AspectElement();
        if (aspectElement == null) {
            AjAspectElementType.$$$reportNull$$$0(0);
        }
        return aspectElement;
    }

    public PsiAspect createPsi(@NotNull PsiAspectStub stub) {
        if (stub == null) {
            AjAspectElementType.$$$reportNull$$$0(1);
        }
        return new PsiAspectImpl(stub);
    }

    @Override
    public PsiAspect createPsi(ASTNode node) {
        return new PsiAspectImpl(node);
    }

    @NotNull
    public PsiAspectStub createStub(@NotNull LighterAST tree, @NotNull LighterASTNode node, @NotNull StubElement parentStub) {
        if (tree == null) {
            AjAspectElementType.$$$reportNull$$$0(2);
        }
        if (node == null) {
            AjAspectElementType.$$$reportNull$$$0(3);
        }
        if (parentStub == null) {
            AjAspectElementType.$$$reportNull$$$0(4);
        }
        boolean isDeprecatedByComment = false;
        boolean hasDeprecatedAnnotation = false;
        boolean hasDocComment = false;
        String qualifiedName = null;
        String name = null;
        for (LighterASTNode child : tree.getChildren(node)) {
            IElementType type = child.getTokenType();
            if (type == JavaDocElementType.DOC_COMMENT) {
                hasDocComment = true;
                isDeprecatedByComment = RecordUtil.isDeprecatedByDocComment((LighterAST)tree, (LighterASTNode)child);
                continue;
            }
            if (type == JavaElementType.MODIFIER_LIST) {
                hasDeprecatedAnnotation = RecordUtil.isDeprecatedByAnnotation((LighterAST)tree, (LighterASTNode)child);
                continue;
            }
            if (type != JavaTokenType.IDENTIFIER) continue;
            name = RecordUtil.intern((CharTable)tree.getCharTable(), (LighterASTNode)child);
        }
        if (name != null) {
            if (parentStub instanceof PsiJavaFileStub) {
                String pkg = ((PsiJavaFileStub)parentStub).getPackageName();
                qualifiedName = pkg.length() > 0 ? pkg + '.' + name : name;
            } else if (parentStub instanceof PsiClassStub) {
                String parentFqn = ((PsiClassStub)parentStub).getQualifiedName();
                qualifiedName = parentFqn != null ? parentFqn + '.' + name : null;
            }
        }
        byte flags = StubBaseWithFlags.pack(isDeprecatedByComment, hasDeprecatedAnnotation, hasDocComment);
        PsiAspectStubImpl psiAspectStubImpl = new PsiAspectStubImpl(parentStub, name, qualifiedName, flags);
        if (psiAspectStubImpl == null) {
            AjAspectElementType.$$$reportNull$$$0(5);
        }
        return psiAspectStubImpl;
    }

    public void serialize(@NotNull PsiAspectStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            AjAspectElementType.$$$reportNull$$$0(6);
        }
        if (dataStream == null) {
            AjAspectElementType.$$$reportNull$$$0(7);
        }
        dataStream.writeName(stub.getName());
        dataStream.writeName(stub.getQualifiedName());
        dataStream.writeByte((int)((PsiAspectStubImpl)stub).getFlags());
    }

    @NotNull
    public PsiAspectStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            AjAspectElementType.$$$reportNull$$$0(8);
        }
        String name = dataStream.readNameString();
        String qualifiedName = dataStream.readNameString();
        byte flags = dataStream.readByte();
        PsiAspectStubImpl psiAspectStubImpl = new PsiAspectStubImpl(parentStub, name, qualifiedName, flags);
        if (psiAspectStubImpl == null) {
            AjAspectElementType.$$$reportNull$$$0(9);
        }
        return psiAspectStubImpl;
    }

    public void indexStub(@NotNull PsiAspectStub stub, @NotNull IndexSink sink) {
        String qualifiedName;
        String name;
        if (stub == null) {
            AjAspectElementType.$$$reportNull$$$0(10);
        }
        if (sink == null) {
            AjAspectElementType.$$$reportNull$$$0(11);
        }
        if ((name = stub.getName()) != null) {
            sink.occurrence(JavaStubIndexKeys.CLASS_SHORT_NAMES, (Object)name);
        }
        if ((qualifiedName = stub.getQualifiedName()) != null) {
            sink.occurrence(JavaStubIndexKeys.CLASS_FQN, (Object)qualifiedName.hashCode());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/aspectj/psi/stub/AjAspectElementType";
                break;
            }
            case 1: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentStub";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStream";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createCompositeNode";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/aspectj/psi/stub/AjAspectElementType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createStub";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "deserialize";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createPsi";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createStub";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "indexStub";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

