/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2ee.webSphere.runDebug.configuration;

import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.j2ee.webSphere.admin.WebSphereAdminServerParameters;
import com.intellij.j2ee.webSphere.configuration.WebSphereVersion;
import com.intellij.j2ee.webSphere.runDebug.configuration.WebSphereFullHandler;
import com.intellij.j2ee.webSphere.runDebug.configuration.WebSphereRemoteModel;
import com.intellij.javaee.oss.server.JavaeeParameters;
import com.intellij.javaee.run.localRun.ExecutableObject;
import com.intellij.javaee.ui.packaging.ExplodedEarArtifactType;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.packaging.artifacts.ArtifactType;
import java.util.Set;

public class WebSphereFullRemoteHandler
extends WebSphereFullHandler {
    public WebSphereFullRemoteHandler(WebSphereRemoteModel serverModel, WebSphereVersion version) {
        super(serverModel, version);
    }

    @Override
    public int getLocalHttpPort() {
        return this.getServerModel().getDefaultPort();
    }

    @Override
    public int getServerPort() {
        return this.getServerModel().SOAP_PORT;
    }

    @Override
    public String getLogFilePath() {
        return null;
    }

    @Override
    public ExecutableObject createStartupExecutable() {
        return null;
    }

    @Override
    public void getShutdownParameters(JavaeeParameters params, boolean debug) {
    }

    @Override
    protected WebSphereAdminServerParameters getAdminServerParameters() {
        return new WebSphereAdminServerParameters(){

            @Override
            public boolean isSecured() {
                return ((WebSphereFullRemoteHandler)WebSphereFullRemoteHandler.this).getRemoteServerModel().SECURED;
            }

            @Override
            public String getTrustStorePath() {
                return FileUtil.toSystemDependentName((String)((WebSphereFullRemoteHandler)WebSphereFullRemoteHandler.this).getRemoteServerModel().CLIENT_TRUST_FILE_PATH);
            }

            @Override
            public String getTrustStorePassword() {
                return ((WebSphereFullRemoteHandler)WebSphereFullRemoteHandler.this).getRemoteServerModel().CLIENT_TRUST_PASSWORD;
            }

            @Override
            public String getKeyStorePath() {
                return FileUtil.toSystemDependentName((String)((WebSphereFullRemoteHandler)WebSphereFullRemoteHandler.this).getRemoteServerModel().CLIENT_KEY_FILE_PATH);
            }

            @Override
            public String getKeyStorePassword() {
                return ((WebSphereFullRemoteHandler)WebSphereFullRemoteHandler.this).getRemoteServerModel().CLIENT_KEY_PASSWORD;
            }

            @Override
            public String getCellName() {
                return WebSphereFullRemoteHandler.this.getServerModel().CELL_NAME;
            }

            @Override
            public String getNodeName() {
                return WebSphereFullRemoteHandler.this.getServerModel().NODE_NAME;
            }

            @Override
            public String getServerName() {
                return WebSphereFullRemoteHandler.this.getServerModel().SERVER_NAME;
            }

            @Override
            public boolean isUploadEARBeforeDeploy() {
                return true;
            }
        };
    }

    private WebSphereRemoteModel getRemoteServerModel() {
        return (WebSphereRemoteModel)this.getServerModel();
    }

    @Override
    protected boolean isDeploymentSupported() {
        return this.getVersion().hasAutoUpload();
    }

    @Override
    public void updateChangedFiles(Set<String> paths) {
    }

    @Override
    protected void checkArtifactType(ArtifactType type) throws RuntimeConfigurationException {
        if (type instanceof ExplodedEarArtifactType) {
            throw new RuntimeConfigurationError("WebSphere Full profile doesn't support remote deployment of exploded application");
        }
    }
}

