/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.appengine.facet;

import com.intellij.appengine.cloud.AppEngineAuthData;
import com.intellij.appengine.cloud.AppEngineCloudConfigurable;
import com.intellij.appengine.cloud.AppEngineServerConfiguration;
import com.intellij.credentialStore.CredentialAttributesKt;
import com.intellij.credentialStore.Credentials;
import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AppEngineAccountDialog {
    private static final String PASSWORD_KEY = "GOOGLE_APP_ENGINE_PASSWORD";

    @Nullable
    public static AppEngineAuthData createAuthData(@NotNull Project project, @NotNull AppEngineServerConfiguration configuration) {
        String password;
        if (project == null) {
            AppEngineAccountDialog.$$$reportNull$$$0(0);
        }
        if (configuration == null) {
            AppEngineAccountDialog.$$$reportNull$$$0(1);
        }
        if (configuration.isOAuth2()) {
            return AppEngineAuthData.oauth2();
        }
        String email = configuration.getEmail();
        if (!StringUtil.isEmpty((String)email) && configuration.isPasswordStored() && !StringUtil.isEmpty((String)(password = AppEngineAccountDialog.getStoredPassword(email)))) {
            return AppEngineAuthData.login(email, password);
        }
        AppEngineCloudConfigurable configurable = new AppEngineCloudConfigurable(configuration, project, false);
        boolean ok = ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)configurable);
        if (!ok) {
            return null;
        }
        if (configurable.isOAuth2()) {
            return AppEngineAuthData.oauth2();
        }
        return AppEngineAuthData.login(configurable.getEmail(), configurable.getPassword());
    }

    public static void storePassword(@NotNull String email, @NotNull String password) {
        if (email == null) {
            AppEngineAccountDialog.$$$reportNull$$$0(2);
        }
        if (password == null) {
            AppEngineAccountDialog.$$$reportNull$$$0(3);
        }
        String accountName = AppEngineAccountDialog.getPasswordKey(email);
        PasswordSafe.getInstance().set(CredentialAttributesKt.CredentialAttributes(AppEngineAccountDialog.class, (String)accountName), password == null ? null : new Credentials(accountName, password));
    }

    private static String getPasswordKey(String email) {
        return "GOOGLE_APP_ENGINE_PASSWORD_" + email;
    }

    @Nullable
    private static String getStoredPassword(String email) {
        if (StringUtil.isEmpty((String)email)) {
            return null;
        }
        return PasswordSafe.getInstance().getPassword(CredentialAttributesKt.CredentialAttributes(AppEngineAccountDialog.class, (String)AppEngineAccountDialog.getPasswordKey(email)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "email";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "password";
                break;
            }
        }
        objectArray2[1] = "com/intellij/appengine/facet/AppEngineAccountDialog";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createAuthData";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "storePassword";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

