/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.mvc.lifecycle.mappings.model.impl;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class LiveRequestMappingPredicateParser {
    private static final String REQUEST_METHODS = "methods";
    private static final String PRODUCES = "produces";
    private static final String CONSUMES = "consumes";
    private static final String HEADERS = "headers";
    private static final String PARAMS = "params";

    LiveRequestMappingPredicateParser() {
    }

    static LiveRequestMappingPredicateParser getParser(@NotNull String mapping) {
        if (mapping == null) {
            LiveRequestMappingPredicateParser.$$$reportNull$$$0(0);
        }
        if (!mapping.startsWith("{")) {
            return SimplePredicateParser.INSTANCE;
        }
        if (mapping.startsWith("{[/")) {
            return MappingPredicateParser.INSTANCE;
        }
        return MappingPredicateParser211.INSTANCE;
    }

    @NotNull
    abstract List<String> getPaths(@NotNull String var1);

    @Nullable
    protected abstract String getPartPattern();

    @NotNull
    List<String> getRequestMethods(@NotNull String mapping) {
        if (mapping == null) {
            LiveRequestMappingPredicateParser.$$$reportNull$$$0(1);
        }
        List<String> list = LiveRequestMappingPredicateParser.parsePartValues(mapping, this.getPartPattern(), REQUEST_METHODS, "||", Function.identity());
        if (list == null) {
            LiveRequestMappingPredicateParser.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    List<Pair<String, String>> getParams(@NotNull String mapping) {
        if (mapping == null) {
            LiveRequestMappingPredicateParser.$$$reportNull$$$0(3);
        }
        List<Pair<String, String>> list = LiveRequestMappingPredicateParser.parsePartValues(mapping, this.getPartPattern(), PARAMS, "&&", LiveRequestMappingPredicateParser::parseKeyValuePair);
        if (list == null) {
            LiveRequestMappingPredicateParser.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    List<Pair<String, String>> getHeaders(@NotNull String mapping) {
        if (mapping == null) {
            LiveRequestMappingPredicateParser.$$$reportNull$$$0(5);
        }
        List<Pair<String, String>> list = LiveRequestMappingPredicateParser.parsePartValues(mapping, this.getPartPattern(), HEADERS, "&&", LiveRequestMappingPredicateParser::parseKeyValuePair);
        if (list == null) {
            LiveRequestMappingPredicateParser.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    List<String> getProduces(@NotNull String mapping) {
        if (mapping == null) {
            LiveRequestMappingPredicateParser.$$$reportNull$$$0(7);
        }
        List<String> list = LiveRequestMappingPredicateParser.parsePartValues(mapping, this.getPartPattern(), PRODUCES, "||", Function.identity());
        if (list == null) {
            LiveRequestMappingPredicateParser.$$$reportNull$$$0(8);
        }
        return list;
    }

    @NotNull
    List<String> getConsumes(@NotNull String mapping) {
        if (mapping == null) {
            LiveRequestMappingPredicateParser.$$$reportNull$$$0(9);
        }
        List<String> list = LiveRequestMappingPredicateParser.parsePartValues(mapping, this.getPartPattern(), CONSUMES, "||", Function.identity());
        if (list == null) {
            LiveRequestMappingPredicateParser.$$$reportNull$$$0(10);
        }
        return list;
    }

    @NotNull
    private static <P> List<P> parsePartValues(@NotNull String mapping, @Nullable String partPattern, @NotNull String part, @NotNull String separator, @NotNull Function<String, P> mapper) {
        int end;
        if (mapping == null) {
            LiveRequestMappingPredicateParser.$$$reportNull$$$0(11);
        }
        if (part == null) {
            LiveRequestMappingPredicateParser.$$$reportNull$$$0(12);
        }
        if (separator == null) {
            LiveRequestMappingPredicateParser.$$$reportNull$$$0(13);
        }
        if (mapper == null) {
            LiveRequestMappingPredicateParser.$$$reportNull$$$0(14);
        }
        if (partPattern == null) {
            List list = Collections.emptyList();
            if (list == null) {
                LiveRequestMappingPredicateParser.$$$reportNull$$$0(15);
            }
            return list;
        }
        String partPrefix = String.format(partPattern, part);
        int partIndex = mapping.indexOf(partPrefix);
        if (partIndex >= 0 && (end = mapping.indexOf(93, partIndex)) > partIndex) {
            String values = mapping.substring(partIndex + partPrefix.length(), end);
            List list = Arrays.stream(values.split(Pattern.quote(separator))).map(String::trim).map(mapper).collect(Collectors.toList());
            if (list == null) {
                LiveRequestMappingPredicateParser.$$$reportNull$$$0(16);
            }
            return list;
        }
        List list = Collections.emptyList();
        if (list == null) {
            LiveRequestMappingPredicateParser.$$$reportNull$$$0(17);
        }
        return list;
    }

    private static Pair<String, String> parseKeyValuePair(String keyValue) {
        int separatorIndex = keyValue.indexOf("=");
        if (separatorIndex >= 0) {
            String value;
            boolean negative = separatorIndex > 0 && keyValue.charAt(separatorIndex - 1) == '!';
            String key = negative ? keyValue.substring(0, separatorIndex - 1) : keyValue.substring(0, separatorIndex);
            String string = value = separatorIndex < keyValue.length() - 1 ? keyValue.substring(separatorIndex + 1) : "";
            if (negative) {
                value = "!" + value;
            }
            return Pair.create((Object)key, (Object)value);
        }
        return Pair.create((Object)keyValue, (Object)"");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 15: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 15: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/mvc/lifecycle/mappings/model/impl/LiveRequestMappingPredicateParser";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "part";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/mvc/lifecycle/mappings/model/impl/LiveRequestMappingPredicateParser";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequestMethods";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getParams";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getHeaders";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getProduces";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getConsumes";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "parsePartValues";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getParser";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getRequestMethods";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getParams";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getHeaders";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getProduces";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getConsumes";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "parsePartValues";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MappingPredicateParser211
    extends LiveRequestMappingPredicateParser {
        static LiveRequestMappingPredicateParser INSTANCE = new MappingPredicateParser211();

        private MappingPredicateParser211() {
        }

        @Override
        @NotNull
        List<String> getPaths(@NotNull String mapping) {
            String paths;
            if (mapping == null) {
                MappingPredicateParser211.$$$reportNull$$$0(0);
            }
            if ((paths = MappingPredicateParser211.extractPaths(mapping)) == null) {
                List list = ContainerUtil.newSmartList((Object)mapping);
                if (list == null) {
                    MappingPredicateParser211.$$$reportNull$$$0(1);
                }
                return list;
            }
            List list = StringUtil.split((String)paths, (String)", ");
            if (list == null) {
                MappingPredicateParser211.$$$reportNull$$$0(2);
            }
            return list;
        }

        @Override
        protected String getPartPattern() {
            return ", %s [";
        }

        @Override
        @NotNull
        List<String> getRequestMethods(@NotNull String mapping) {
            if (mapping == null) {
                MappingPredicateParser211.$$$reportNull$$$0(3);
            }
            assert (mapping.length() > 1);
            if (mapping.startsWith("{[")) {
                int start = 2;
                int end = mapping.indexOf(93);
                if (end < start) {
                    List<String> list = Collections.emptyList();
                    if (list == null) {
                        MappingPredicateParser211.$$$reportNull$$$0(4);
                    }
                    return list;
                }
                String methodsPart = mapping.substring(start, end);
                List<String> list = Arrays.asList(methodsPart.split(Pattern.quote(", ")));
                if (list == null) {
                    MappingPredicateParser211.$$$reportNull$$$0(5);
                }
                return list;
            }
            int end = mapping.indexOf(32);
            if (end < 2) {
                List<String> list = Collections.emptyList();
                if (list == null) {
                    MappingPredicateParser211.$$$reportNull$$$0(6);
                }
                return list;
            }
            List list = ContainerUtil.newSmartList((Object)mapping.substring(1, end));
            if (list == null) {
                MappingPredicateParser211.$$$reportNull$$$0(7);
            }
            return list;
        }

        @Nullable
        private static String extractPaths(@NotNull String mapping) {
            String methodsEndMarker;
            int methodsEnd;
            if (mapping == null) {
                MappingPredicateParser211.$$$reportNull$$$0(8);
            }
            if ((methodsEnd = mapping.indexOf(methodsEndMarker = mapping.startsWith("{[") ? "] " : " ")) < 0) {
                return null;
            }
            int start = methodsEnd + methodsEndMarker.length();
            if (start == mapping.length()) {
                return null;
            }
            if (mapping.charAt(start) == '[') {
                if (++start == mapping.length()) {
                    return null;
                }
                int end = mapping.indexOf("], ", start);
                if (end < 0 && (end = mapping.length() - 2) < start) {
                    return null;
                }
                return mapping.substring(start, end);
            }
            int end = mapping.indexOf(", ", start);
            if (end < 0 && (end = mapping.length() - 1) < start) {
                return null;
            }
            return mapping.substring(start, end);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mapping";
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/spring/boot/mvc/lifecycle/mappings/model/impl/LiveRequestMappingPredicateParser$MappingPredicateParser211";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/spring/boot/mvc/lifecycle/mappings/model/impl/LiveRequestMappingPredicateParser$MappingPredicateParser211";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPaths";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRequestMethods";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getPaths";
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getRequestMethods";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "extractPaths";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MappingPredicateParser
    extends LiveRequestMappingPredicateParser {
        static LiveRequestMappingPredicateParser INSTANCE = new MappingPredicateParser();

        private MappingPredicateParser() {
        }

        @Override
        @NotNull
        List<String> getPaths(@NotNull String mapping) {
            if (mapping == null) {
                MappingPredicateParser.$$$reportNull$$$0(0);
            }
            assert (mapping.length() > 2);
            int start = 2;
            int end = mapping.indexOf(93);
            if (end < start) {
                List list = ContainerUtil.newSmartList((Object)mapping);
                if (list == null) {
                    MappingPredicateParser.$$$reportNull$$$0(1);
                }
                return list;
            }
            List list = ContainerUtil.map((Collection)StringUtil.split((String)mapping.substring(start, end), (String)"||"), String::trim);
            if (list == null) {
                MappingPredicateParser.$$$reportNull$$$0(2);
            }
            return list;
        }

        @Override
        protected String getPartPattern() {
            return ",%s=[";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mapping";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/spring/boot/mvc/lifecycle/mappings/model/impl/LiveRequestMappingPredicateParser$MappingPredicateParser";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/spring/boot/mvc/lifecycle/mappings/model/impl/LiveRequestMappingPredicateParser$MappingPredicateParser";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPaths";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getPaths";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class SimplePredicateParser
    extends LiveRequestMappingPredicateParser {
        static LiveRequestMappingPredicateParser INSTANCE = new SimplePredicateParser();

        private SimplePredicateParser() {
        }

        @Override
        @NotNull
        List<String> getPaths(@NotNull String mapping) {
            if (mapping == null) {
                SimplePredicateParser.$$$reportNull$$$0(0);
            }
            List list = ContainerUtil.newSmartList((Object)mapping);
            if (list == null) {
                SimplePredicateParser.$$$reportNull$$$0(1);
            }
            return list;
        }

        @Override
        @Nullable
        protected String getPartPattern() {
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mapping";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/spring/boot/mvc/lifecycle/mappings/model/impl/LiveRequestMappingPredicateParser$SimplePredicateParser";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/spring/boot/mvc/lifecycle/mappings/model/impl/LiveRequestMappingPredicateParser$SimplePredicateParser";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPaths";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getPaths";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

