/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.persistence.util;

import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.persistence.PersistenceHelper;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistenceMappings;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.persistence.roles.PersistenceClassRole;
import com.intellij.persistence.util.PersistenceCommonUtil;
import com.intellij.psi.PsiClass;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.GenericValue;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PersistenceUtil {
    @NotNull
    public static Collection<DbDataSource> getDataSources(Project project, Iterable<? extends PersistencePackage> units) {
        DbPsiFacade facade = DbPsiFacade.getInstance((Project)project);
        THashSet set = new THashSet();
        for (PersistencePackage persistencePackage : units) {
            List facets = PersistenceHelper.getHelper().getSharedModelBrowser().getPersistenceFacets(persistencePackage);
            if (!facets.isEmpty()) {
                for (PersistenceFacet facet : facets) {
                    String dataSourceName = facet.getDataSourceId(persistencePackage);
                    if (dataSourceName == null) continue;
                    ContainerUtil.addIfNotNull((Collection)set, (Object)facade.findDataSource(dataSourceName));
                }
                continue;
            }
            GenericValue value = persistencePackage.getModelHelper().getDataSourceName();
            String dataSourceName = value != null ? (String)value.getValue() : null;
            if (dataSourceName == null) continue;
            ContainerUtil.addIfNotNull((Collection)set, (Object)ContainerUtil.find((Iterable)facade.getDataSources(), element -> Comparing.equal((String)element.getUniqueId(), (String)dataSourceName) || Comparing.equal((String)element.getName(), (String)dataSourceName)));
        }
        THashSet tHashSet = set;
        if (tHashSet == null) {
            PersistenceUtil.$$$reportNull$$$0(0);
        }
        return tHashSet;
    }

    @NotNull
    public static Collection<DbDataSource> getDataSources(PersistenceMappings entityMappings) {
        if (entityMappings == null) {
            List<DbDataSource> list = Collections.emptyList();
            if (list == null) {
                PersistenceUtil.$$$reportNull$$$0(1);
            }
            return list;
        }
        Collection<DbDataSource> collection = PersistenceUtil.getDataSources(entityMappings.getPsiManager().getProject(), PersistenceHelper.getHelper().getSharedModelBrowser().getPersistenceUnits(entityMappings));
        if (collection == null) {
            PersistenceUtil.$$$reportNull$$$0(2);
        }
        return collection;
    }

    @NotNull
    public static Collection<DbDataSource> getDataSources(PsiClass psiClass) {
        if (psiClass == null) {
            List<DbDataSource> list = Collections.emptyList();
            if (list == null) {
                PersistenceUtil.$$$reportNull$$$0(3);
            }
            return list;
        }
        DbPsiFacade dbPsiFacade = DbPsiFacade.getInstance((Project)psiClass.getProject());
        HashSet<DbDataSource> set = new HashSet<DbDataSource>();
        for (PersistenceClassRole role : PersistenceCommonUtil.getPersistenceRoles((PsiClass)psiClass)) {
            DbDataSource o;
            String dataSourceName = role.getFacet().getDataSourceId(role.getPersistenceUnit());
            if (dataSourceName == null || (o = dbPsiFacade.findDataSource(dataSourceName)) == null) continue;
            set.add(o);
        }
        HashSet<DbDataSource> hashSet = set;
        if (hashSet == null) {
            PersistenceUtil.$$$reportNull$$$0(4);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/persistence/util/PersistenceUtil", "getDataSources"));
    }
}

