/*
 * Decompiled with CFR 0.152.
 */
package gherkin.parser;

import gherkin.formatter.Formatter;
import gherkin.formatter.model.Background;
import gherkin.formatter.model.Builder;
import gherkin.formatter.model.Comment;
import gherkin.formatter.model.DocString;
import gherkin.formatter.model.Examples;
import gherkin.formatter.model.Feature;
import gherkin.formatter.model.Scenario;
import gherkin.formatter.model.ScenarioOutline;
import gherkin.formatter.model.Step;
import gherkin.formatter.model.Tag;
import gherkin.lexer.Listener;
import java.util.ArrayList;
import java.util.List;

public class FormatterListener
implements Listener {
    private final Formatter formatter;
    private Stash stash;
    private Builder currentBuilder;

    public FormatterListener(Formatter formatter) {
        this.formatter = formatter;
        this.stash = new Stash();
        this.stash.reset();
    }

    @Override
    public void comment(String comment, Integer line) {
        this.stash.comment(new Comment(comment, line));
    }

    @Override
    public void tag(String tag, Integer line) {
        this.stash.tag(new Tag(tag, line));
    }

    @Override
    public void feature(String keyword, String name, String description, Integer line) {
        this.formatter.feature(new Feature(this.stash.comments, this.stash.tags, keyword, name, description, line, this.stash.featureId(name)));
        this.stash.reset();
    }

    @Override
    public void background(String keyword, String name, String description, Integer line) {
        this.formatter.background(new Background(this.stash.comments, keyword, name, description, line));
        this.stash.reset();
    }

    @Override
    public void scenario(String keyword, String name, String description, Integer line) {
        this.replayStepsOrExamples();
        this.formatter.scenario(new Scenario(this.stash.comments, this.stash.tags, keyword, name, description, line, this.stash.featureElementId(name)));
        this.stash.reset();
    }

    @Override
    public void scenarioOutline(String keyword, String name, String description, Integer line) {
        this.replayStepsOrExamples();
        this.formatter.scenarioOutline(new ScenarioOutline(this.stash.comments, this.stash.tags, keyword, name, description, line, this.stash.featureElementId(name)));
        this.stash.reset();
    }

    @Override
    public void examples(String keyword, String name, String description, Integer line) {
        this.replayStepsOrExamples();
        this.currentBuilder = new Examples.Builder(this.stash.comments, this.stash.tags, keyword, name, description, line, this.stash.examplesId(name));
        this.stash.reset();
    }

    @Override
    public void step(String keyword, String name, Integer line) {
        this.replayStepsOrExamples();
        this.currentBuilder = new Step.Builder(this.stash.comments, keyword, name, line);
        this.stash.reset();
    }

    @Override
    public void row(List<String> cells, Integer line) {
        this.currentBuilder.row(this.stash.comments, cells, line, this.stash.nextExampleId());
        this.stash.reset();
    }

    @Override
    public void docString(String contentType, String content, Integer line) {
        this.currentBuilder.docString(new DocString(contentType, content, line));
    }

    @Override
    public void eof() {
        this.replayStepsOrExamples();
        this.formatter.eof();
    }

    public void syntaxError(String state, String event, List<String> legalEvents, String uri, Integer line) {
        this.formatter.syntaxError(state, event, legalEvents, uri, line);
    }

    private void replayStepsOrExamples() {
        if (this.currentBuilder != null) {
            this.currentBuilder.replay(this.formatter);
            this.currentBuilder = null;
        }
    }

    private class Stash {
        private List<Comment> comments;
        private List<Tag> tags;
        private String featureId;
        private String featureElementId;
        private String examplesId;
        private int rowIndex = 0;

        private Stash() {
        }

        public void comment(Comment comment) {
            this.comments.add(comment);
        }

        public void tag(Tag tag) {
            this.tags.add(tag);
        }

        public void reset() {
            this.comments = new ArrayList<Comment>();
            this.tags = new ArrayList<Tag>();
        }

        public String featureId(String name) {
            this.featureId = this.id(name);
            return this.featureId;
        }

        public String featureElementId(String name) {
            this.featureElementId = this.featureId + ";" + this.id(name);
            return this.featureElementId;
        }

        public String examplesId(String name) {
            this.rowIndex = 0;
            this.examplesId = this.featureElementId + ";" + this.id(name);
            return this.examplesId;
        }

        private String id(String name) {
            return name.replaceAll("[\\s_]", "-").toLowerCase();
        }

        public String nextExampleId() {
            ++this.rowIndex;
            return "" + this.examplesId + ";" + this.rowIndex;
        }
    }
}

