/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.weblogic.agent.version9.mbeansModel.runtime;

import com.intellij.javaee.weblogic.agent.WebLogicTarget;
import com.intellij.javaee.weblogic.agent.version9.mbeansModel.AbstractWL9MBean;
import com.intellij.javaee.weblogic.agent.version9.mbeansModel.runtime.DeploymentTaskRuntimeWL9MBean;
import java.io.IOException;
import java.lang.reflect.Field;
import javax.management.JMException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

public class DeployerRuntimeWL9MBean
extends AbstractWL9MBean {
    private static final String DEPLOYMENT_DATA_CLASS_NAME = "weblogic.management.deploy.DeploymentData";
    private static final String[] DEPLOY_PARAMETER_TYPES = new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "weblogic.management.deploy.DeploymentData", "java.lang.String", "java.lang.Boolean"};
    private static final String[] UNDEPLOY_PARAM_TYPES = new String[]{"java.lang.String", "weblogic.management.deploy.DeploymentData", "java.lang.String", "java.lang.Boolean"};
    private static final AbstractWL9MBean.MethodSignature DEPLOY_SIGNATURE = new AbstractWL9MBean.MethodSignature("deploy", DEPLOY_PARAMETER_TYPES);
    private static final AbstractWL9MBean.MethodSignature ACTIVATE_SIGNATURE = new AbstractWL9MBean.MethodSignature("activate", DEPLOY_PARAMETER_TYPES);
    private static final AbstractWL9MBean.MethodSignature UNDEPLOY_SIGNATURE = new AbstractWL9MBean.MethodSignature("undeploy", UNDEPLOY_PARAM_TYPES);
    private static final AbstractWL9MBean.MethodSignature REMOVE_SIGNATURE = new AbstractWL9MBean.MethodSignature("remove", UNDEPLOY_PARAM_TYPES);
    private static final String ADD_GLOBAL_TARGET_NAME = "addGlobalTarget";
    private static final String SET_TARGET_TYPE_NAME = "setTargetType";
    private static final String SET_LIBRARY_NAME = "setLibrary";
    private static final String SET_DEPLOYMENT_PLAN_NAME = "setDeploymentPlan";
    private static final Boolean START_TASK_IMMEDIATELY = Boolean.FALSE;
    private static final Boolean ADD_TARGET_BEFORE_STARTING = true;

    public DeployerRuntimeWL9MBean(MBeanServerConnection connection, ObjectName beanName) {
        super(connection, beanName);
    }

    private DeploymentTaskRuntimeWL9MBean configureAndStartTask(ObjectName objectName, WebLogicTarget target) throws IOException, JMException {
        DeploymentTaskRuntimeWL9MBean task = new DeploymentTaskRuntimeWL9MBean(this.getConnection(), objectName);
        if (!START_TASK_IMMEDIATELY.booleanValue()) {
            if (!ADD_TARGET_BEFORE_STARTING.booleanValue()) {
                Object deploymentData = task.getDeploymentData();
                DeployerRuntimeWL9MBean.addTarget(deploymentData, target);
            }
            task.start();
        }
        return task;
    }

    private static void addTarget(Object deploymentData, WebLogicTarget target) {
        try {
            Field typeField = deploymentData.getClass().getField(target.getType().getValue());
            deploymentData.getClass().getMethod(SET_TARGET_TYPE_NAME, String.class, Integer.TYPE).invoke(deploymentData, target.getName(), typeField.getInt(deploymentData));
            deploymentData.getClass().getMethod(ADD_GLOBAL_TARGET_NAME, String.class).invoke(deploymentData, target.getName());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public DeploymentTaskRuntimeWL9MBean deploy(String source, String name, WebLogicTarget target, boolean asLibrary, String plan) throws IOException, JMException {
        ObjectName objectName = (ObjectName)this.invoke(DEPLOY_SIGNATURE, source, name, null, DeployerRuntimeWL9MBean.createDeploymentData(target, asLibrary, plan), null, START_TASK_IMMEDIATELY);
        return this.configureAndStartTask(objectName, target);
    }

    private static Object createDeploymentData(WebLogicTarget target, boolean asLibrary, String plan) {
        if (!(ADD_TARGET_BEFORE_STARTING.booleanValue() || asLibrary || plan != null && plan.length() != 0)) {
            return null;
        }
        Object data = DeployerRuntimeWL9MBean.createDeploymentData();
        if (ADD_TARGET_BEFORE_STARTING.booleanValue()) {
            DeployerRuntimeWL9MBean.addTarget(data, target);
        }
        if (asLibrary) {
            DeployerRuntimeWL9MBean.setLibrary(data);
        } else if (plan != null && plan.length() > 0) {
            DeployerRuntimeWL9MBean.setDeploymentPlan(data, plan);
        }
        return data;
    }

    private static Object createDeploymentData() {
        try {
            Class<?> aClass = Class.forName(DEPLOYMENT_DATA_CLASS_NAME, true, Thread.currentThread().getContextClassLoader());
            return aClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void setLibrary(Object deploymentData) {
        try {
            deploymentData.getClass().getMethod(SET_LIBRARY_NAME, Boolean.TYPE).invoke(deploymentData, Boolean.TRUE);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void setDeploymentPlan(Object deploymentData, String plan) {
        try {
            deploymentData.getClass().getMethod(SET_DEPLOYMENT_PLAN_NAME, String.class).invoke(deploymentData, plan);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public DeploymentTaskRuntimeWL9MBean activate(String source, String name, WebLogicTarget target) throws IOException, JMException {
        ObjectName objectName = (ObjectName)this.invoke(ACTIVATE_SIGNATURE, source, name, null, DeployerRuntimeWL9MBean.createDeploymentData(target), null, START_TASK_IMMEDIATELY);
        return this.configureAndStartTask(objectName, target);
    }

    private static Object createDeploymentData(WebLogicTarget target) {
        if (!ADD_TARGET_BEFORE_STARTING.booleanValue()) {
            return null;
        }
        Object data = DeployerRuntimeWL9MBean.createDeploymentData();
        DeployerRuntimeWL9MBean.addTarget(data, target);
        return data;
    }

    public DeploymentTaskRuntimeWL9MBean undeploy(String name, WebLogicTarget target) throws IOException, JMException {
        ObjectName objectName = (ObjectName)this.invoke(UNDEPLOY_SIGNATURE, name, DeployerRuntimeWL9MBean.createDeploymentData(target), null, START_TASK_IMMEDIATELY);
        return this.configureAndStartTask(objectName, target);
    }

    public DeploymentTaskRuntimeWL9MBean remove(String name, WebLogicTarget target) throws IOException, JMException {
        ObjectName objectName = (ObjectName)this.invoke(REMOVE_SIGNATURE, name, DeployerRuntimeWL9MBean.createDeploymentData(target), null, START_TASK_IMMEDIATELY);
        return this.configureAndStartTask(objectName, target);
    }
}

