/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.hash.HashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.GrControlFlowOwner;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMember;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.processors.PropertyResolverProcessor;
import org.jetbrains.plugins.groovy.refactoring.NameValidator;

public class DefaultGroovyVariableNameValidator
implements NameValidator {
    private final GroovyPsiElement myContext;
    private final Set<String> mySet = new HashSet();

    public DefaultGroovyVariableNameValidator(GroovyPsiElement context) {
        this(context, Collections.emptyList(), true, false);
    }

    public DefaultGroovyVariableNameValidator(GroovyPsiElement context, Collection<String> restrictedNames) {
        this(context, restrictedNames, true, false);
    }

    public DefaultGroovyVariableNameValidator(GroovyPsiElement context, Collection<String> restrictedNames, boolean includeFields) {
        this(context, restrictedNames, includeFields, false);
    }

    public DefaultGroovyVariableNameValidator(GroovyPsiElement context, Collection<String> restrictedNames, final boolean includeFields, final boolean checkIntoInner) {
        GroovyResolveResult[] results;
        this.myContext = context;
        this.mySet.addAll(restrictedNames);
        PropertyResolverProcessor processor = new PropertyResolverProcessor(null, this.myContext);
        ResolveUtil.treeWalkUp(this.myContext, processor, true);
        for (GroovyResolveResult result2 : results = processor.getCandidates()) {
            PsiElement element = result2.getElement();
            if (!(element instanceof PsiNamedElement) || !includeFields && element instanceof PsiField) continue;
            this.mySet.add(((PsiNamedElement)element).getName());
        }
        GroovyPsiElement scope = (GroovyPsiElement)PsiTreeUtil.getParentOfType((PsiElement)context, (Class[])new Class[]{GrControlFlowOwner.class, GrMember.class});
        if (scope == null) {
            scope = context;
        }
        scope.accept(new GroovyRecursiveElementVisitor(){

            @Override
            public void visitVariable(@NotNull GrVariable variable) {
                if (variable == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (includeFields || !(variable instanceof PsiField)) {
                    DefaultGroovyVariableNameValidator.this.mySet.add(variable.getName());
                }
                super.visitVariable(variable);
            }

            @Override
            public void visitClosure(@NotNull GrClosableBlock closure) {
                if (closure == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (checkIntoInner) {
                    super.visitClosure(closure);
                }
            }

            @Override
            public void visitTypeDefinition(@NotNull GrTypeDefinition typeDefinition) {
                if (typeDefinition == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (checkIntoInner && !typeDefinition.hasModifierProperty("static")) {
                    super.visitTypeDefinition(typeDefinition);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "variable";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "closure";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "typeDefinition";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/plugins/groovy/refactoring/DefaultGroovyVariableNameValidator$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitVariable";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitClosure";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitTypeDefinition";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @Override
    public String validateName(String name, boolean increaseNumber) {
        if (!this.mySet.contains(name)) {
            return name;
        }
        if (increaseNumber) {
            int i = 1;
            while (this.mySet.contains(name + i)) {
                ++i;
            }
            return name + i;
        }
        return "";
    }

    @Override
    public Project getProject() {
        return this.myContext.getProject();
    }
}

