/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.impl.compiled.ClsClassImpl;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.util.GrTraitUtil;
import org.jetbrains.plugins.groovy.transformations.TransformationUtilKt;

public class CollectClassMembersUtil {
    private static final Key<CachedValue<ClassMembers>> CACHED_MEMBERS = Key.create((String)"CACHED_CLASS_MEMBERS");
    private static final Key<CachedValue<ClassMembers>> CACHED_MEMBERS_INCLUDING_SYNTHETIC = Key.create((String)"CACHED_MEMBERS_INCLUDING_SYNTHETIC");

    private CollectClassMembersUtil() {
    }

    @NotNull
    public static Map<String, List<CandidateInfo>> getAllMethods(@NotNull PsiClass aClass, boolean includeSynthetic) {
        if (aClass == null) {
            CollectClassMembersUtil.$$$reportNull$$$0(0);
        }
        Map map2 = CollectClassMembersUtil.getCachedMembers(aClass, includeSynthetic).methods;
        if (map2 == null) {
            CollectClassMembersUtil.$$$reportNull$$$0(1);
        }
        return map2;
    }

    @NotNull
    private static ClassMembers getCachedMembers(@NotNull PsiClass aClass, boolean includeSynthetic) {
        CachedValue cached;
        if (aClass == null) {
            CollectClassMembersUtil.$$$reportNull$$$0(2);
        }
        if ((cached = (CachedValue)aClass.getUserData(CollectClassMembersUtil.getMemberCacheKey(includeSynthetic))) != null && cached.hasUpToDateValue()) {
            ClassMembers classMembers = (ClassMembers)cached.getValue();
            if (classMembers == null) {
                CollectClassMembersUtil.$$$reportNull$$$0(3);
            }
            return classMembers;
        }
        ClassMembers classMembers = CollectClassMembersUtil.buildCache(aClass, includeSynthetic && CollectClassMembersUtil.checkClass(aClass));
        if (classMembers == null) {
            CollectClassMembersUtil.$$$reportNull$$$0(4);
        }
        return classMembers;
    }

    private static boolean checkClass(@NotNull PsiClass aClass) {
        if (aClass == null) {
            CollectClassMembersUtil.$$$reportNull$$$0(5);
        }
        HashSet visited = ContainerUtil.newHashSet();
        LinkedList queue = ContainerUtil.newLinkedList((Object[])new PsiClass[]{aClass});
        while (!queue.isEmpty()) {
            PsiClass current = (PsiClass)queue.remove();
            if (current instanceof ClsClassImpl) continue;
            if (visited.add(current)) {
                if (TransformationUtilKt.isUnderTransformation(current)) {
                    return false;
                }
                for (PsiClass superClass : CollectClassMembersUtil.getSupers(current, false)) {
                    queue.offer(superClass);
                }
                continue;
            }
            if (current.isInterface() || "java.lang.Object".equals(current.getQualifiedName())) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public static Map<String, CandidateInfo> getAllInnerClasses(@NotNull PsiClass aClass, boolean includeSynthetic) {
        if (aClass == null) {
            CollectClassMembersUtil.$$$reportNull$$$0(6);
        }
        Map map2 = CollectClassMembersUtil.getCachedMembers(aClass, includeSynthetic).innerClasses;
        if (map2 == null) {
            CollectClassMembersUtil.$$$reportNull$$$0(7);
        }
        return map2;
    }

    @NotNull
    public static Map<String, CandidateInfo> getAllFields(@NotNull PsiClass aClass, boolean includeSynthetic) {
        if (aClass == null) {
            CollectClassMembersUtil.$$$reportNull$$$0(8);
        }
        Map map2 = CollectClassMembersUtil.getCachedMembers(aClass, includeSynthetic).fields;
        if (map2 == null) {
            CollectClassMembersUtil.$$$reportNull$$$0(9);
        }
        return map2;
    }

    @NotNull
    public static Map<String, CandidateInfo> getAllFields(@NotNull PsiClass aClass) {
        if (aClass == null) {
            CollectClassMembersUtil.$$$reportNull$$$0(10);
        }
        Map<String, CandidateInfo> map2 = CollectClassMembersUtil.getAllFields(aClass, true);
        if (map2 == null) {
            CollectClassMembersUtil.$$$reportNull$$$0(11);
        }
        return map2;
    }

    @NotNull
    private static ClassMembers buildCache(@NotNull PsiClass aClass, boolean includeSynthetic) {
        if (aClass == null) {
            CollectClassMembersUtil.$$$reportNull$$$0(12);
        }
        ClassMembers classMembers = (ClassMembers)CachedValuesManager.getManager((Project)aClass.getProject()).getCachedValue((UserDataHolder)aClass, CollectClassMembersUtil.getMemberCacheKey(includeSynthetic), () -> {
            if (aClass == null) {
                CollectClassMembersUtil.$$$reportNull$$$0(36);
            }
            ClassMembers result2 = new ClassMembers();
            CollectClassMembersUtil.processClass(aClass, result2.fields, result2.methods, result2.innerClasses, new HashSet(), PsiSubstitutor.EMPTY, includeSynthetic);
            return CachedValueProvider.Result.create((Object)result2, (Object[])new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT});
        }, false);
        if (classMembers == null) {
            CollectClassMembersUtil.$$$reportNull$$$0(13);
        }
        return classMembers;
    }

    @NotNull
    private static Key<CachedValue<ClassMembers>> getMemberCacheKey(boolean includeSynthetic) {
        Key<CachedValue<ClassMembers>> key = includeSynthetic ? CACHED_MEMBERS_INCLUDING_SYNTHETIC : CACHED_MEMBERS;
        if (key == null) {
            CollectClassMembersUtil.$$$reportNull$$$0(14);
        }
        return key;
    }

    private static void processClass(@NotNull PsiClass aClass, @NotNull Map<String, CandidateInfo> allFields, @NotNull Map<String, List<CandidateInfo>> allMethods, @NotNull Map<String, CandidateInfo> allInnerClasses, @NotNull Set<? super PsiClass> visitedClasses, @NotNull PsiSubstitutor substitutor, boolean includeSynthetic) {
        String name;
        if (aClass == null) {
            CollectClassMembersUtil.$$$reportNull$$$0(15);
        }
        if (allFields == null) {
            CollectClassMembersUtil.$$$reportNull$$$0(16);
        }
        if (allMethods == null) {
            CollectClassMembersUtil.$$$reportNull$$$0(17);
        }
        if (allInnerClasses == null) {
            CollectClassMembersUtil.$$$reportNull$$$0(18);
        }
        if (visitedClasses == null) {
            CollectClassMembersUtil.$$$reportNull$$$0(19);
        }
        if (substitutor == null) {
            CollectClassMembersUtil.$$$reportNull$$$0(20);
        }
        PsiUtilCore.ensureValid((PsiElement)aClass);
        if (!visitedClasses.add((PsiClass)aClass)) {
            return;
        }
        if (visitedClasses.size() == 1 || !GrTraitUtil.isTrait(aClass)) {
            for (PsiField psiField : CollectClassMembersUtil.getFields(aClass, includeSynthetic)) {
                name = psiField.getName();
                if (allFields.containsKey(name)) continue;
                allFields.put(name, new CandidateInfo((PsiElement)psiField, substitutor));
            }
        }
        for (PsiField psiField : CollectClassMembersUtil.getMethods(aClass, includeSynthetic)) {
            CollectClassMembersUtil.addMethod(allMethods, (PsiMethod)psiField, substitutor);
        }
        for (PsiField psiField : CollectClassMembersUtil.getInnerClasses(aClass, includeSynthetic)) {
            name = psiField.getName();
            if (name == null || allInnerClasses.containsKey(name)) continue;
            allInnerClasses.put(name, new CandidateInfo((PsiElement)psiField, substitutor));
        }
        for (PsiField psiField : CollectClassMembersUtil.getSupers(aClass, includeSynthetic)) {
            PsiSubstitutor superSubstitutor = includeSynthetic ? TypeConversionUtil.getSuperClassSubstitutor((PsiClass)psiField, (PsiClass)aClass, (PsiSubstitutor)substitutor) : PsiSubstitutor.EMPTY;
            CollectClassMembersUtil.processClass((PsiClass)psiField, allFields, allMethods, allInnerClasses, visitedClasses, superSubstitutor, includeSynthetic);
        }
    }

    @NotNull
    private static PsiField[] filterProperties(PsiField[] fields) {
        if (fields.length == 0) {
            if (PsiField.EMPTY_ARRAY == null) {
                CollectClassMembersUtil.$$$reportNull$$$0(21);
            }
            return PsiField.EMPTY_ARRAY;
        }
        List fieldNamesList = ContainerUtil.mapNotNull((Object[])fields, it -> CollectClassMembersUtil.hasExplicitVisibilityModifiers(it) ? it.getName() : null);
        if (fieldNamesList.isEmpty()) {
            if (fields == null) {
                CollectClassMembersUtil.$$$reportNull$$$0(22);
            }
            return fields;
        }
        HashSet fieldNames = new HashSet(fieldNamesList);
        PsiField[] psiFieldArray = ContainerUtil.filter((Object[])fields, it -> CollectClassMembersUtil.hasExplicitVisibilityModifiers(it) || !fieldNames.remove(it.getName())).toArray(PsiField.EMPTY_ARRAY);
        if (psiFieldArray == null) {
            CollectClassMembersUtil.$$$reportNull$$$0(23);
        }
        return psiFieldArray;
    }

    @NotNull
    public static PsiField[] getFields(@NotNull PsiClass aClass, boolean includeSynthetic) {
        if (aClass == null) {
            CollectClassMembersUtil.$$$reportNull$$$0(24);
        }
        PsiField[] fields = includeSynthetic || !(aClass instanceof GrTypeDefinition) ? aClass.getFields() : ((GrTypeDefinition)aClass).getCodeFields();
        PsiField[] psiFieldArray = CollectClassMembersUtil.filterProperties(fields);
        if (psiFieldArray == null) {
            CollectClassMembersUtil.$$$reportNull$$$0(25);
        }
        return psiFieldArray;
    }

    @NotNull
    public static PsiMethod[] getMethods(@NotNull PsiClass aClass, boolean includeSynthetic) {
        if (aClass == null) {
            CollectClassMembersUtil.$$$reportNull$$$0(26);
        }
        Object[] objectArray = includeSynthetic || !(aClass instanceof GrTypeDefinition) ? aClass.getMethods() : ((GrTypeDefinition)aClass).getCodeMethods();
        if (objectArray == null) {
            CollectClassMembersUtil.$$$reportNull$$$0(27);
        }
        return objectArray;
    }

    @NotNull
    public static PsiClass[] getInnerClasses(@NotNull PsiClass aClass, boolean includeSynthetic) {
        if (aClass == null) {
            CollectClassMembersUtil.$$$reportNull$$$0(28);
        }
        Object[] objectArray = includeSynthetic || !(aClass instanceof GrTypeDefinition) ? aClass.getInnerClasses() : ((GrTypeDefinition)aClass).getCodeInnerClasses();
        if (objectArray == null) {
            CollectClassMembersUtil.$$$reportNull$$$0(29);
        }
        return objectArray;
    }

    @NotNull
    public static PsiClass[] getSupers(@NotNull PsiClass aClass, boolean includeSynthetic) {
        if (aClass == null) {
            CollectClassMembersUtil.$$$reportNull$$$0(30);
        }
        PsiClass[] psiClassArray = aClass instanceof GrTypeDefinition ? ((GrTypeDefinition)aClass).getSupers(includeSynthetic) : aClass.getSupers();
        if (psiClassArray == null) {
            CollectClassMembersUtil.$$$reportNull$$$0(31);
        }
        return psiClassArray;
    }

    private static boolean hasExplicitVisibilityModifiers(@NotNull PsiField field) {
        if (field == null) {
            CollectClassMembersUtil.$$$reportNull$$$0(32);
        }
        if (field instanceof GrField) {
            GrModifierList list = (GrModifierList)field.getModifierList();
            return list == null || list.hasExplicitVisibilityModifiers();
        }
        return true;
    }

    private static void addMethod(@NotNull Map<String, List<CandidateInfo>> allMethods, @NotNull PsiMethod method, @NotNull PsiSubstitutor substitutor) {
        String name;
        List<CandidateInfo> methods;
        if (allMethods == null) {
            CollectClassMembersUtil.$$$reportNull$$$0(33);
        }
        if (method == null) {
            CollectClassMembersUtil.$$$reportNull$$$0(34);
        }
        if (substitutor == null) {
            CollectClassMembersUtil.$$$reportNull$$$0(35);
        }
        if ((methods = allMethods.get(name = method.getName())) == null) {
            methods = new ArrayList<CandidateInfo>();
            allMethods.put(name, methods);
        }
        methods.add(new CandidateInfo((PsiElement)method, substitutor));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 31: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 31: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/resolve/CollectClassMembersUtil";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allFields";
                break;
            }
            case 17: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allMethods";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allInnerClasses";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitedClasses";
                break;
            }
            case 20: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/resolve/CollectClassMembersUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllMethods";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachedMembers";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllInnerClasses";
                break;
            }
            case 9: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllFields";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "buildCache";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getMemberCacheKey";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "filterProperties";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getFields";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethods";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getInnerClasses";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAllMethods";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 31: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getCachedMembers";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkClass";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAllInnerClasses";
                break;
            }
            case 8: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getAllFields";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "buildCache";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "processClass";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getFields";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getMethods";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getInnerClasses";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getSupers";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "hasExplicitVisibilityModifiers";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "addMethod";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "lambda$buildCache$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 31: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ClassMembers {
        private final Map<String, CandidateInfo> fields = ContainerUtil.newLinkedHashMap();
        private final Map<String, List<CandidateInfo>> methods = ContainerUtil.newLinkedHashMap();
        private final Map<String, CandidateInfo> innerClasses = ContainerUtil.newLinkedHashMap();

        private ClassMembers() {
        }
    }
}

