/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.exception;

import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.exception.CatchParameterUsedVisitor;
import org.jetbrains.plugins.groovy.codeInspection.exception.GrExceptionUtil;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrCatchClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;

public class GroovyUnusedCatchParameterInspection
extends BaseInspection {
    public boolean isEnabledByDefault() {
        return true;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Unused catch parameter" == null) {
            GroovyUnusedCatchParameterInspection.$$$reportNull$$$0(0);
        }
        return "Unused catch parameter";
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        Visitor visitor2 = new Visitor();
        if (visitor2 == null) {
            GroovyUnusedCatchParameterInspection.$$$reportNull$$$0(1);
        }
        return visitor2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/plugins/groovy/codeInspection/exception/GroovyUnusedCatchParameterInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitCatchClause(@NotNull GrCatchClause catchClause) {
            if (catchClause == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super.visitCatchClause(catchClause);
            GrOpenBlock block = catchClause.getBody();
            if (block == null) {
                return;
            }
            GrParameter parameter = catchClause.getParameter();
            if (parameter == null) {
                return;
            }
            if (GrExceptionUtil.ignore(parameter)) {
                return;
            }
            CatchParameterUsedVisitor visitor2 = new CatchParameterUsedVisitor(parameter);
            block.accept(visitor2);
            if (!visitor2.isUsed()) {
                PsiElement nameIdentifier = parameter.getNameIdentifierGroovy();
                this.registerError(nameIdentifier, "Unused catch parameter '#ref' #loc", new LocalQuickFix[]{QuickFixFactory.getInstance().createRenameElementFix((PsiNamedElement)parameter, "ignored")}, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "catchClause", "org/jetbrains/plugins/groovy/codeInspection/exception/GroovyUnusedCatchParameterInspection$Visitor", "visitCatchClause"));
        }
    }
}

