/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.actions.create;

import com.intellij.ide.IdeView;
import com.intellij.ide.actions.CreateElementActionBase;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ws.utils.FileUtils;
import com.intellij.ws.utils.WSUtilsBundle;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public abstract class AbstractCreateWebServiceAction
extends CreateElementActionBase {
    public AbstractCreateWebServiceAction(@NotNull String text, @NotNull String description, @Nullable Icon icon) {
        if (text == null) {
            AbstractCreateWebServiceAction.$$$reportNull$$$0(0);
        }
        if (description == null) {
            AbstractCreateWebServiceAction.$$$reportNull$$$0(1);
        }
        super(text, description, icon);
    }

    protected abstract String getKindName();

    protected String getErrorTitle() {
        return WSUtilsBundle.message("title.cannot.create.filetype", this.getKindName());
    }

    protected String getCommandName() {
        return WSUtilsBundle.message("command.name.create.new.file", this.getKindName());
    }

    protected String getActionName(PsiDirectory psiDirectory, String s) {
        return WSUtilsBundle.message("progress.creating.filetype.in.directory", this.getKindName(), s, psiDirectory.getName());
    }

    protected Pair<String, PsiDirectory> getTargetFileDirectoryPair(String className, PsiDirectory dir) {
        if (className.contains(".")) {
            String[] names = className.split("\\.");
            for (int i = 0; i < names.length - 1; ++i) {
                String name = names[i];
                PsiDirectory subDir = dir.findSubdirectory(name);
                if (subDir == null) {
                    subDir = dir.createSubdirectory(name);
                }
                dir = subDir;
            }
            className = names[names.length - 1];
        }
        return Pair.create((Object)className, (Object)dir);
    }

    @NotNull
    public PsiElement[] create(String className, PsiDirectory dir) throws Exception {
        Pair<String, PsiDirectory> pair = this.getTargetFileDirectoryPair(className, dir);
        className = (String)pair.first;
        dir = (PsiDirectory)pair.second;
        PsiFile file = dir.createFile(className + ".java");
        String packageQName = JavaDirectoryService.getInstance().getPackage(dir).getQualifiedName();
        String text = this.buildText(packageQName, className, file);
        VirtualFile virtualFile = file.getVirtualFile();
        FileUtils.saveText(virtualFile, text);
        FileEditor[] fileEditors = FileEditorManager.getInstance((Project)dir.getProject()).openFile(virtualFile, true);
        Editor editor = null;
        for (FileEditor fe : fileEditors) {
            if (!(fe instanceof TextEditor)) continue;
            editor = ((TextEditor)fe).getEditor();
            break;
        }
        this.createAdditionalFiles(className, packageQName, dir, editor, virtualFile);
        PsiElement[] psiElementArray = new PsiElement[]{file};
        if (psiElementArray == null) {
            AbstractCreateWebServiceAction.$$$reportNull$$$0(2);
        }
        return psiElementArray;
    }

    protected void createAdditionalFiles(String className, String packageQName, PsiDirectory psiDirectory, Editor editor, VirtualFile vfile) throws Exception {
    }

    protected abstract String buildText(String var1, String var2, PsiFile var3);

    @NotNull
    protected PsiElement[] invokeDialog(Project project, PsiDirectory psiDirectory) {
        CreateElementActionBase.MyInputValidator validator = new CreateElementActionBase.MyInputValidator((CreateElementActionBase)this, project, psiDirectory);
        Messages.showInputDialog((Project)project, (String)WSUtilsBundle.message("prompt.enter.new.0", this.getKindName()), (String)WSUtilsBundle.message("title.new.filetype", this.getKindName()), (Icon)Messages.getQuestionIcon(), (String)"", (InputValidator)validator);
        PsiElement[] psiElementArray = validator.getCreatedElements();
        if (psiElementArray == null) {
            AbstractCreateWebServiceAction.$$$reportNull$$$0(3);
        }
        return psiElementArray;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            AbstractCreateWebServiceAction.$$$reportNull$$$0(4);
        }
        super.update(e);
        DataContext dataContext = e.getDataContext();
        Project project = (Project)dataContext.getData(CommonDataKeys.PROJECT);
        Presentation presentation = e.getPresentation();
        if (presentation.isEnabled()) {
            IdeView ideView = (IdeView)LangDataKeys.IDE_VIEW.getData(dataContext);
            assert (ideView != null);
            ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
            for (PsiDirectory dir : ideView.getDirectories()) {
                if (!fileIndex.isUnderSourceRootOfType(dir.getVirtualFile(), JavaModuleSourceRootTypes.SOURCES) || JavaDirectoryService.getInstance().getPackage(dir) == null) continue;
                return;
            }
            presentation.setEnabled(false);
            presentation.setVisible(false);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/actions/create/AbstractCreateWebServiceAction";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/actions/create/AbstractCreateWebServiceAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "invokeDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

