/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils.library;

import b.a.lb;
import com.intellij.jarRepository.JarRepositoryManager;
import com.intellij.jarRepository.RepositoryLibraryType;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.AnnotationOrderRootType;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.roots.libraries.ui.OrderRoot;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.NewLibraryEditor;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.JBIterable;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryProperties;

public class RepositoryUtils {
    private static final Logger a;
    private static final long b;

    public static boolean libraryHasSources(@Nullable Library library) {
        return library != null && library.getUrls(OrderRootType.SOURCES).length > 0;
    }

    public static boolean libraryHasSources(@Nullable LibraryEditor libraryEditor) {
        return libraryEditor != null && libraryEditor.getUrls(OrderRootType.SOURCES).length > 0;
    }

    public static boolean libraryHasJavaDocs(@Nullable Library library) {
        return library != null && library.getUrls(JavadocOrderRootType.getInstance()).length > 0;
    }

    public static boolean libraryHasJavaDocs(@Nullable LibraryEditor libraryEditor) {
        return libraryEditor != null && libraryEditor.getUrls(JavadocOrderRootType.getInstance()).length > 0;
    }

    public static boolean libraryHasExternalAnnotations(@Nullable LibraryEditor libraryEditor) {
        return libraryEditor != null && libraryEditor.getUrls(AnnotationOrderRootType.getInstance()).length > 0;
    }

    public static String getStorageRoot(Library library, Project project2) {
        return RepositoryUtils.getStorageRoot(library.getUrls(OrderRootType.CLASSES), project2);
    }

    public static String getStorageRoot(String[] urls, Project project2) {
        if (urls.length == 0) {
            return null;
        }
        String string = FileUtil.toSystemIndependentName((String)JarRepositoryManager.getLocalRepositoryPath().getAbsolutePath());
        List list2 = JBIterable.of((Object[])urls).transform(string2 -> {
            long l2 = b ^ 0x64457C76AE62L;
            String string3 = StringUtil.trimStart((String)string2, (String)"jar://");
            return string3.startsWith(string) ? null : FileUtil.toSystemDependentName((String)PathUtil.getParentPath((String)string3));
        }).toList();
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            String string3;
            Integer n2 = (Integer)hashMap.get(string3 = (String)iterator.next());
            hashMap.put(string3, n2 != null ? n2 + 1 : 1);
        }
        return (String)Collections.max(hashMap.entrySet(), Comparator.comparing(Map.Entry::getValue)).getKey();
    }

    public static Promise<List<OrderRoot>> loadDependenciesToLibrary(@NotNull Project project2, @NotNull LibraryEx library, boolean downloadSources, boolean downloadJavaDocs, @Nullable String copyTo) {
        if (project2 == null) {
            RepositoryUtils.a(0);
        }
        if (library == null) {
            RepositoryUtils.a(1);
        }
        if (library.getKind() != RepositoryLibraryType.REPOSITORY_LIBRARY_KIND) {
            return Promise.resolve(Collections.emptyList());
        }
        RepositoryLibraryProperties repositoryLibraryProperties = (RepositoryLibraryProperties)library.getProperties();
        String[] stringArray = library.getUrls(AnnotationOrderRootType.getInstance());
        String[] stringArray2 = library.getExcludedRootUrls();
        return JarRepositoryManager.loadDependenciesAsync(project2, repositoryLibraryProperties, downloadSources, downloadJavaDocs, null, copyTo).thenAsync(list2 -> {
            if (project2 == null) {
                RepositoryUtils.a(4);
            }
            if (library == null) {
                RepositoryUtils.a(5);
            }
            AsyncPromise asyncPromise = new AsyncPromise();
            ApplicationManager.getApplication().invokeLater(list2 == null || list2.isEmpty() ? () -> {
                long l2 = b ^ 0x3D710F7E34C5L;
                if (project2 == null) {
                    RepositoryUtils.a(8);
                }
                String string = "No files were downloaded for " + repositoryLibraryProperties.getMavenId();
                Notifications.Bus.notify((Notification)new Notification("Repository", "Repository library synchronization", string, NotificationType.ERROR), (Project)project2);
                asyncPromise.setError(string);
            } : () -> {
                long l2 = b ^ 0x59B72551420CL;
                if (library == null) {
                    RepositoryUtils.a(6);
                }
                if (!library.isDisposed()) {
                    a.debug("Loaded dependencies for '" + repositoryLibraryProperties.getMavenId() + "' repository library");
                    WriteAction.run(() -> {
                        if (library == null) {
                            RepositoryUtils.a(7);
                        }
                        NewLibraryEditor newLibraryEditor = new NewLibraryEditor(null, (LibraryProperties)repositoryLibraryProperties);
                        newLibraryEditor.setKeepInvalidUrls(false);
                        newLibraryEditor.removeAllRoots();
                        newLibraryEditor.addRoots((Collection<? extends OrderRoot>)list2);
                        for (String string : stringArray) {
                            newLibraryEditor.addRoot(string, AnnotationOrderRootType.getInstance());
                        }
                        List list3 = newLibraryEditor.getOrderRootTypes().stream().flatMap(orderRootType -> Arrays.stream(newLibraryEditor.getUrls((OrderRootType)orderRootType))).collect(Collectors.toList());
                        for (LibraryEx.ModifiableModelEx modifiableModelEx2 : stringArray2) {
                            if (!VfsUtilCore.isUnder((String)modifiableModelEx2, list3)) continue;
                            newLibraryEditor.addExcludedRoot((String)modifiableModelEx2);
                        }
                        LibraryEx.ModifiableModelEx modifiableModelEx3 = library.getModifiableModel();
                        newLibraryEditor.applyTo(modifiableModelEx3);
                        modifiableModelEx3.commit();
                    });
                }
                asyncPromise.setResult(list2);
            });
            return asyncPromise;
        });
    }

    public static Promise<List<OrderRoot>> reloadDependencies(@NotNull Project project2, @NotNull LibraryEx library) {
        if (project2 == null) {
            RepositoryUtils.a(2);
        }
        if (library == null) {
            RepositoryUtils.a(3);
        }
        return RepositoryUtils.loadDependenciesToLibrary(project2, library, RepositoryUtils.libraryHasSources((Library)library), RepositoryUtils.libraryHasJavaDocs((Library)library), RepositoryUtils.getStorageRoot((Library)library, project2));
    }

    static {
        b = lb.a(-2386944998602234704L, -1549855234381565626L, MethodHandles.lookup().lookupClass()).a(225966674642135L);
        long l2 = b ^ 0x235D152FC68EL;
        a = Logger.getInstance((String)"#org.jetbrains.idea.maven.utils.library.RepositoryUtils");
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = b ^ 0x1F469C5D6240L;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/maven/utils/library/RepositoryUtils";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "loadDependenciesToLibrary";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "reloadDependencies";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$loadDependenciesToLibrary$5";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$null$4";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$null$3";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$null$1";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

