/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.libraries.ui.download;

import b.a.lb;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.download.DownloadableFileSetVersions;
import com.intellij.webcore.libraries.LangScriptingContextProvider;
import com.intellij.webcore.libraries.ui.download.AdditionalDownloadableLibraryProvider;
import com.intellij.webcore.libraries.ui.download.DefaultDownloadableWebLibrariesSource;
import com.intellij.webcore.libraries.ui.download.DownloadableFileSetDescriptionWithUrl;
import com.intellij.webcore.libraries.ui.download.DownloadableWebLibrariesSource;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DownloadWebLibraryDialog
extends DialogWrapper {
    private JPanel d;
    private JBTable b;
    private JLabel c;
    private DownloadableFileSetDescriptionWithUrl a;
    private static final long e = lb.a(-9175890475607650214L, 6101762609128387673L, MethodHandles.lookup().lookupClass()).a(85081903509467L);

    public DownloadWebLibraryDialog(@NotNull Project project2, LangScriptingContextProvider provider) {
        long l2 = e ^ 0x47AB2F9FD42L;
        if (project2 == null) {
            DownloadWebLibraryDialog.a(0);
        }
        super(project2);
        this.a();
        this.setTitle("Download Library");
        this.setOKButtonText("Download and Install");
        this.setCancelButtonText("Close");
        this.setOKActionEnabled(false);
        this.b.setSelectionMode(0);
        DefaultComboBoxModel<DefaultDownloadableWebLibrariesSource> defaultComboBoxModel = new DefaultComboBoxModel<DefaultDownloadableWebLibrariesSource>();
        defaultComboBoxModel.addElement(new DefaultDownloadableWebLibrariesSource(project2, provider));
        DownloadableWebLibrariesSource downloadableWebLibrariesSource = AdditionalDownloadableLibraryProvider.getLibrary(project2);
        if (downloadableWebLibrariesSource != null) {
            this.c.setText(downloadableWebLibrariesSource.toString());
            this.a(project2, downloadableWebLibrariesSource, provider);
        }
        this.init();
        TableColumnModel tableColumnModel = this.b.getColumnModel();
        int[] nArray = new int[]{100, 20, 300};
        for (int i10 = 0; i10 < tableColumnModel.getColumnCount(); ++i10) {
            tableColumnModel.getColumn(i10).setPreferredWidth(nArray[i10]);
        }
        new TableSpeedSearch((JTable)this.b).setComparator(new SpeedSearchComparator(true));
        this.b.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e10) {
                TableModel tableModel = DownloadWebLibraryDialog.this.b.getModel();
                if (tableModel instanceof MyLibraryTableModel) {
                    DownloadWebLibraryDialog.this.setOKActionEnabled(true);
                    DownloadWebLibraryDialog.this.a = ((MyLibraryTableModel)tableModel).getDescriptionAt(DownloadWebLibraryDialog.this.b.getSelectedRow());
                }
            }
        });
    }

    private void a(final @NotNull Project project2, final @NotNull DownloadableWebLibrariesSource downloadableWebLibrariesSource, final @NotNull LangScriptingContextProvider langScriptingContextProvider) {
        long l2 = e ^ 0x202C18B1F521L;
        if (project2 == null) {
            DownloadWebLibraryDialog.a(1);
        }
        if (downloadableWebLibrariesSource == null) {
            DownloadWebLibraryDialog.a(2);
        }
        if (langScriptingContextProvider == null) {
            DownloadWebLibraryDialog.a(3);
        }
        final DefaultTableModel defaultTableModel = new DefaultTableModel(new Object[]{"Fetching a list of libraries..."}, 1){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.setOKActionEnabled(false);
        this.b.setModel((TableModel)defaultTableModel);
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (downloadableWebLibrariesSource == null) {
                DownloadWebLibraryDialog.a(4);
            }
            if (langScriptingContextProvider == null) {
                DownloadWebLibraryDialog.a(5);
            }
            if (project2 == null) {
                DownloadWebLibraryDialog.a(6);
            }
            downloadableWebLibrariesSource.prepareTableModel(new DownloadableFileSetVersions.FileSetVersionsCallback<DownloadableFileSetDescriptionWithUrl>(){
                private static final long a = lb.a(3764563447237294171L, -4547431893376394527L, MethodHandles.lookup().lookupClass()).a(48352169442090L);

                public void onSuccess(@NotNull List<? extends DownloadableFileSetDescriptionWithUrl> versions) {
                    if (versions == null) {
                        3.a(0);
                    }
                    if (versions.size() > 0) {
                        langScriptingContextProvider.filterExistingLibraries(project2, versions);
                        ApplicationManager.getApplication().invokeLater(() -> {
                            if (versions == null) {
                                3.a(3);
                            }
                            if (downloadableWebLibrariesSource == null) {
                                3.a(4);
                            }
                            DownloadWebLibraryDialog.this.b.setModel((TableModel)new MyLibraryTableModel(versions, downloadableWebLibrariesSource.includeVersionColumn()));
                        }, ModalityState.any());
                    }
                }

                public void onError(@NotNull String errorMessage) {
                    if (errorMessage == null) {
                        3.a(1);
                    }
                    ApplicationManager.getApplication().invokeLater(() -> {
                        long l2 = a ^ 0x56E605D7CF63L;
                        if (errorMessage == null) {
                            3.a(2);
                        }
                        defaultTableModel.setColumnIdentifiers(new Object[]{"Error while fetching list of libraries: " + errorMessage});
                    }, ModalityState.any());
                }

                private static /* synthetic */ void a(int n2) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    long l2 = a ^ 0x18747220FB62L;
                    Object[] objectArray3 = new Object[3];
                    switch (n2) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "versions";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "errorMessage";
                            break;
                        }
                        case 4: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "librariesSource";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/webcore/libraries/ui/download/DownloadWebLibraryDialog$3";
                    switch (n2) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onSuccess";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onError";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "lambda$onError$1";
                            break;
                        }
                        case 3: 
                        case 4: {
                            objectArray = objectArray2;
                            objectArray2[2] = "lambda$onSuccess$0";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        });
    }

    @Nullable
    protected String getHelpId() {
        long l2 = e ^ 0x33A010F5A8FFL;
        return "JavaScript.Libraries";
    }

    protected JComponent createCenterPanel() {
        return this.d;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.d;
    }

    @Nullable
    public DownloadableFileSetDescriptionWithUrl getSelection() {
        return this.a;
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = e ^ 0x691C79ED3B8CL;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "librariesSource";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
        }
        objectArray2[1] = "com/intellij/webcore/libraries/ui/download/DownloadWebLibraryDialog";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "populate";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$populate$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private /* synthetic */ void a() {
        JLabel jLabel;
        JBTable jBTable;
        JPanel jPanel;
        long l2 = e ^ 0x36F756983CD5L;
        this.d = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel2.add((Component)jBScrollPane, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.b = jBTable = new JBTable();
        jBTable.setAutoResizeMode(2);
        jBTable.setStriped(true);
        jBScrollPane.setViewportView((Component)jBTable);
        this.c = jLabel = new JLabel();
        jLabel.setText("No libraries available");
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.d;
    }

    private static class MyLibraryTableModel
    extends AbstractTableModel {
        private final int b;
        private final int d;
        private final int e;
        private final List<? extends DownloadableFileSetDescriptionWithUrl> a;
        private final boolean c;
        private static final long f = lb.a(3448481850745458992L, -7436569717344653442L, MethodHandles.lookup().lookupClass()).a(196748248986443L);

        MyLibraryTableModel(List<? extends DownloadableFileSetDescriptionWithUrl> descriptions, boolean includeVersionColumn) {
            this.a = descriptions;
            this.c = includeVersionColumn;
            this.b = 0;
            this.d = this.c ? 1 : -1;
            this.e = this.c ? 2 : 1;
            Collections.sort(this.a, (downloadableFileSetDescription, downloadableFileSetDescription2) -> {
                if (downloadableFileSetDescription.getName().equals(downloadableFileSetDescription2.getName())) {
                    return downloadableFileSetDescription.getVersionString().compareTo(downloadableFileSetDescription2.getVersionString());
                }
                return downloadableFileSetDescription.getName().compareToIgnoreCase(downloadableFileSetDescription2.getName());
            });
        }

        @Override
        public int getRowCount() {
            return this.a.size();
        }

        @Override
        public int getColumnCount() {
            return this.c ? 3 : 2;
        }

        @Override
        @Nullable
        public Object getValueAt(int rowIndex, int columnIndex) {
            DownloadableFileSetDescriptionWithUrl downloadableFileSetDescriptionWithUrl = this.a.get(rowIndex);
            if (columnIndex == this.b) {
                return downloadableFileSetDescriptionWithUrl.getName();
            }
            if (columnIndex == this.d) {
                return downloadableFileSetDescriptionWithUrl.getVersionString();
            }
            if (columnIndex == this.e) {
                return downloadableFileSetDescriptionWithUrl.getUrl();
            }
            return null;
        }

        @Override
        @Nullable
        public String getColumnName(int column) {
            long l2 = f ^ 0x4148470F4164L;
            if (column == this.b) {
                return "Name";
            }
            if (column == this.d) {
                return "Version";
            }
            if (column == this.e) {
                return "URL";
            }
            return "";
        }

        @Nullable
        public DownloadableFileSetDescriptionWithUrl getDescriptionAt(int rowIndex) {
            if (rowIndex < 0 || rowIndex >= this.a.size()) {
                return null;
            }
            return this.a.get(rowIndex);
        }
    }
}

