/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.ui;

import b.a.lb;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.highlighting.DomElementAnnotationsManager;
import com.intellij.util.xml.highlighting.DomElementProblemDescriptor;
import com.intellij.util.xml.highlighting.DomElementsProblemsHolder;
import com.intellij.util.xml.ui.BaseModifiableControl;
import com.intellij.util.xml.ui.DomWrapper;
import java.awt.Color;
import java.awt.Component;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public abstract class EditorTextFieldControl<T extends JComponent>
extends BaseModifiableControl<T, String> {
    private static final JTextField c;
    private final boolean a;
    private final DocumentListener b = new DocumentListener(){
        private static final long a = lb.a(4508377985921029335L, -5619788838382983413L, MethodHandles.lookup().lookupClass()).a(19083153697793L);

        public void documentChanged(@NotNull DocumentEvent e10) {
            if (e10 == null) {
                2.a(0);
            }
            EditorTextFieldControl.this.setModified();
            if (EditorTextFieldControl.this.a) {
                EditorTextFieldControl.this.commit();
            }
        }

        private static /* synthetic */ void a(int n2) {
            long l2 = a ^ 0x4AB187E2FF5DL;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/util/xml/ui/EditorTextFieldControl$2", "documentChanged"));
        }
    };
    private static final long d;

    protected EditorTextFieldControl(DomWrapper<String> domWrapper, boolean commitOnEveryChange) {
        super(domWrapper);
        this.a = commitOnEveryChange;
    }

    protected EditorTextFieldControl(DomWrapper<String> domWrapper) {
        this(domWrapper, false);
    }

    protected abstract EditorTextField getEditorTextField(@NotNull T var1);

    protected void doReset() {
        EditorTextField editorTextField = this.getEditorTextField(this.getComponent());
        editorTextField.getDocument().removeDocumentListener(this.b);
        super.doReset();
        editorTextField.getDocument().addDocumentListener(this.b);
    }

    protected JComponent getComponentToListenFocusLost(T component) {
        return this.getEditorTextField(this.getComponent());
    }

    protected JComponent getHighlightedComponent(T component) {
        return c;
    }

    protected T createMainComponent(T boundedComponent) {
        Project project2 = this.getProject();
        boundedComponent = this.createMainComponent(boundedComponent, project2);
        EditorTextField editorTextField = this.getEditorTextField(boundedComponent);
        editorTextField.setSupplementary(true);
        editorTextField.getDocument().addDocumentListener(this.b);
        return boundedComponent;
    }

    protected abstract T createMainComponent(T var1, Project var2);

    @NotNull
    protected String getValue() {
        String string = this.getEditorTextField(this.getComponent()).getText();
        if (string == null) {
            EditorTextFieldControl.a(0);
        }
        return string;
    }

    protected void setValue(String value) {
        CommandProcessor.getInstance().runUndoTransparentAction(() -> WriteAction.run(() -> {
            JComponent jComponent = this.getComponent();
            Document document = this.getEditorTextField(jComponent).getDocument();
            document.replaceString(0, document.getTextLength(), (CharSequence)(value == null ? "" : value));
        }));
    }

    protected void updateComponent() {
        DomElement domElement = this.getDomElement();
        if (domElement == null || !domElement.isValid()) {
            return;
        }
        EditorTextField editorTextField = this.getEditorTextField(this.getComponent());
        Project project2 = this.getProject();
        ApplicationManager.getApplication().invokeLater(() -> {
            if (!project2.isOpen()) {
                return;
            }
            if (!this.getDomWrapper().isValid()) {
                return;
            }
            DomElement domElement = this.getDomElement();
            if (domElement == null || !domElement.isValid()) {
                return;
            }
            DomElementAnnotationsManager domElementAnnotationsManager = DomElementAnnotationsManager.getInstance((Project)project2);
            DomElementsProblemsHolder domElementsProblemsHolder = domElementAnnotationsManager.getCachedProblemHolder(domElement);
            List list2 = domElementsProblemsHolder.getProblems(domElement);
            ArrayList arrayList = new ArrayList(domElementsProblemsHolder.getProblems(domElement, true, HighlightSeverity.WARNING));
            arrayList.removeAll(list2);
            Color color = this.getDefaultBackground();
            if (list2.size() > 0 && editorTextField.getText().trim().length() == 0) {
                color = this.getErrorBackground();
            } else if (arrayList.size() > 0) {
                color = this.getWarningBackground();
            }
            Editor editor = editorTextField.getEditor();
            if (editor != null) {
                MarkupModel markupModel = editor.getMarkupModel();
                markupModel.removeAllHighlighters();
                if (!list2.isEmpty() && editor.getDocument().getLineCount() > 0) {
                    TextAttributes textAttributes = SimpleTextAttributes.ERROR_ATTRIBUTES.toTextAttributes();
                    textAttributes.setEffectType(EffectType.WAVE_UNDERSCORE);
                    textAttributes.setEffectColor(textAttributes.getForegroundColor());
                    markupModel.addLineHighlighter(0, 0, textAttributes);
                    editor.getContentComponent().setToolTipText(((DomElementProblemDescriptor)list2.get(0)).getDescriptionTemplate());
                }
            }
            editorTextField.setBackground(color);
        });
    }

    public boolean canNavigate(DomElement element) {
        return this.getDomElement().equals(element);
    }

    public void navigate(DomElement element) {
        EditorTextField editorTextField = this.getEditorTextField(this.getComponent());
        SwingUtilities.invokeLater(() -> {
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)editorTextField, true));
            editorTextField.selectAll();
        });
    }

    static {
        d = lb.a(-25756439451628124L, -1323290698170123825L, MethodHandles.lookup().lookupClass()).a(187352921439385L);
        c = new JTextField(){
            private static final long a = lb.a(-6924465798250522097L, -1301848655516135261L, MethodHandles.lookup().lookupClass()).a(44878261390484L);

            @Override
            public void addNotify() {
                long l2 = a ^ 0x7616E75C3CEDL;
                throw new UnsupportedOperationException("Shouldn't be shown");
            }

            @Override
            public void setVisible(boolean aFlag) {
                long l2 = a ^ 0x4FE69DA39C63L;
                throw new UnsupportedOperationException("Shouldn't be shown");
            }
        };
    }

    private static /* synthetic */ void a(int n2) {
        long l2 = d ^ 0x6A4C44BD53C7L;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/ui/EditorTextFieldControl", "getValue"));
    }
}

