/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.impl;

import b.a.lb;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.io.ZipUtil;
import com.intellij.util.io.impl.DirectoryContentSpecImpl;
import com.intellij.util.io.impl.DirectoryContentSpecImplKt$WhenMappings;
import com.intellij.util.io.impl.DirectorySpec;
import com.intellij.util.io.impl.DirectorySpecBase;
import com.intellij.util.io.impl.FileSpec;
import com.intellij.util.io.impl.ZipSpec;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000&\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a \u0010\b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u000e\u0010\n\u001a\u0004\u0018\u00010\u0007*\u00020\u000bH\u0002\u00a8\u0006\f"}, d2={"assertDirectoryContentMatches", "", "file", "Ljava/io/File;", "spec", "Lcom/intellij/util/io/impl/DirectoryContentSpecImpl;", "relativePath", "", "assertDirectoryMatches", "Lcom/intellij/util/io/impl/DirectorySpecBase;", "convertToText", "", "intellij.platform.testFramework"})
public final class DirectoryContentSpecImplKt {
    private static final long a = lb.a(-4421555939382163004L, -3356898113239635922L, MethodHandles.lookup().lookupClass()).a(151364169211559L);

    public static final void assertDirectoryContentMatches(@NotNull File file, @NotNull DirectoryContentSpecImpl spec, @NotNull String relativePath) {
        long l2 = a ^ 0x50F6663A68FDL;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)spec, (String)"spec");
        Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
        DirectoryContentSpecImpl directoryContentSpecImpl = spec;
        if (directoryContentSpecImpl instanceof DirectorySpec) {
            DirectoryContentSpecImplKt.a(file, (DirectorySpecBase)spec, relativePath);
        } else if (directoryContentSpecImpl instanceof ZipSpec) {
            File file2 = FileUtil.createTempDirectory((String)("extracted-" + file.getName()), null, (boolean)false);
            Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"FileUtil.createTempDirec\u2026file.name}\", null, false)");
            File file3 = file2;
            ZipUtil.extract((File)file, (File)file3, null);
            DirectoryContentSpecImplKt.a(file3, (DirectorySpecBase)spec, relativePath);
            FileUtil.delete((File)file3);
        } else if (directoryContentSpecImpl instanceof FileSpec) {
            Assert.assertTrue((String)(file + " is not a file"), (boolean)file.isFile());
            if (((FileSpec)spec).getContent() != null) {
                byte[] byArray = FileUtil.loadFileBytes((File)file);
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"FileUtil.loadFileBytes(file)");
                byte[] byArray2 = byArray;
                if (!Arrays.equals(byArray2, ((FileSpec)spec).getContent())) {
                    String string;
                    String string2 = DirectoryContentSpecImplKt.a(byArray2);
                    String string3 = DirectoryContentSpecImplKt.a(((FileSpec)spec).getContent());
                    String string4 = string = Intrinsics.areEqual((Object)relativePath, (Object)"") ^ true ? " at " + relativePath : "";
                    if (string2 != null && string3 != null) {
                        Assert.assertEquals((String)("File content mismatch" + string + ':'), (Object)string3, (Object)string2);
                    } else {
                        Assert.fail((String)("Binary file content mismatch" + string));
                    }
                }
            }
        }
    }

    private static final String a(@NotNull byte[] byArray) {
        Charset charset;
        long l2 = a ^ 0x69C069E985E7L;
        CharsetToolkit.GuessedEncoding guessedEncoding = new CharsetToolkit(byArray, Charsets.UTF_8).guessFromContent(byArray.length);
        Intrinsics.checkExpressionValueIsNotNull((Object)guessedEncoding, (String)"CharsetToolkit(this, Cha\u20268).guessFromContent(size)");
        CharsetToolkit.GuessedEncoding guessedEncoding2 = guessedEncoding;
        switch (DirectoryContentSpecImplKt$WhenMappings.$EnumSwitchMapping$0[guessedEncoding2.ordinal()]) {
            case 1: {
                charset = Charsets.US_ASCII;
                break;
            }
            case 2: {
                charset = Charsets.UTF_8;
                break;
            }
            default: {
                return null;
            }
        }
        Charset charset2 = charset;
        return new String(byArray, charset2);
    }

    private static final void a(File file, DirectorySpecBase directorySpecBase, String string) {
        long l2 = a ^ 0xEF89B9A0590L;
        Assert.assertTrue((String)(file + " is not a directory"), (boolean)file.isDirectory());
        Object[] objectArray = file.list();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"file.list()");
        List list2 = ArraysKt.sortedWith((Object[])objectArray, (Comparator)StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE));
        Map<String, DirectoryContentSpecImpl> map2 = directorySpecBase.getChildren();
        List list3 = CollectionsKt.sortedWith((Iterable)map2.keySet(), (Comparator)StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE));
        Assert.assertEquals((String)("Directory content mismatch" + (Intrinsics.areEqual((Object)string, (Object)"") ^ true ? " at " + string : "") + ':'), (Object)CollectionsKt.joinToString$default((Iterable)list3, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null), (Object)CollectionsKt.joinToString$default((Iterable)list2, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
        Iterable iterable = list2;
        for (Object t2 : iterable) {
            String string2 = (String)t2;
            File file2 = new File(file, string2);
            DirectoryContentSpecImpl directoryContentSpecImpl = map2.get(string2);
            if (directoryContentSpecImpl == null) {
                Intrinsics.throwNpe();
            }
            DirectoryContentSpecImplKt.assertDirectoryContentMatches(file2, directoryContentSpecImpl, string + '/' + string2);
        }
    }
}

