/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.utils.inlays;

import com.intellij.codeInsight.daemon.impl.ParameterHintsPresentationManager;
import com.intellij.codeInsight.hints.settings.ParameterNameHintsSettings;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.InlayModel;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiFile;
import com.intellij.rt.execution.junit.FileComparisonFailure;
import com.intellij.testFramework.VfsTestUtil;
import com.intellij.testFramework.fixtures.CodeInsightTestFixture;
import com.intellij.testFramework.utils.inlays.CaretAndInlaysInfo;
import com.intellij.testFramework.utils.inlays.InlayHintsChecker;
import com.intellij.testFramework.utils.inlays.InlayInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.ComparisonFailure;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\u0018\u0000 '2\u00020\u0001:\u0001'B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J6\u0010\u0014\u001a\u00020\u00152\u0016\u0010\u000b\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u0004\u0012\u00020\f0\u00062\u0016\u0010\u0005\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u0004\u0012\u00020\b0\u0006J\u0006\u0010\u0016\u001a\u00020\u0015J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ>\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0016\u0010\u000b\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u0004\u0012\u00020\f0\u00062\u0016\u0010\u0005\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u0004\u0012\u00020\b0\u0006H\u0002J \u0010\u001e\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 H\u0002J\u0006\u0010\"\u001a\u00020\u0015J\u0006\u0010#\u001a\u00020\u0015J\u0016\u0010$\u001a\u00020\u00152\u0006\u0010%\u001a\u00020\u00182\u0006\u0010&\u001a\u00020\fJH\u0010$\u001a\u00020\u00152\u0006\u0010%\u001a\u00020\u00182\u0006\u0010&\u001a\u00020\f2\u0016\u0010\u000b\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u0004\u0012\u00020\f0\u00062\u0016\u0010\u0005\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u0004\u0012\u00020\b0\u0006H\u0002R!\u0010\u0005\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR!\u0010\u000b\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u0004\u0012\u00020\f0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR\u000e\u0010\u000e\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/intellij/testFramework/utils/inlays/InlayHintsChecker;", "", "myFixture", "Lcom/intellij/testFramework/fixtures/CodeInsightTestFixture;", "(Lcom/intellij/testFramework/fixtures/CodeInsightTestFixture;)V", "inlayFilter", "Lkotlin/Function1;", "Lcom/intellij/openapi/editor/Inlay;", "", "getInlayFilter", "()Lkotlin/jvm/functions/Function1;", "inlayPresenter", "", "getInlayPresenter", "isParamHintsEnabledBefore", "manager", "Lcom/intellij/codeInsight/daemon/impl/ParameterHintsPresentationManager;", "kotlin.jvm.PlatformType", "getManager", "()Lcom/intellij/codeInsight/daemon/impl/ParameterHintsPresentationManager;", "checkInlays", "", "checkParameterHints", "extractInlaysAndCaretInfo", "Lcom/intellij/testFramework/utils/inlays/CaretAndInlaysInfo;", "document", "Lcom/intellij/openapi/editor/Document;", "getActualInlays", "", "Lcom/intellij/testFramework/utils/inlays/InlayInfo;", "removeText", "realStartOffset", "", "matchedLength", "setUp", "tearDown", "verifyInlaysAndCaretInfo", "expectedInlaysAndCaret", "originalText", "Companion", "intellij.platform.testFramework"})
public final class InlayHintsChecker {
    private boolean isParamHintsEnabledBefore;
    private final ParameterHintsPresentationManager manager;
    @NotNull
    private final Function1<Inlay<?>, String> inlayPresenter;
    @NotNull
    private final Function1<Inlay<?>, Boolean> inlayFilter;
    private final CodeInsightTestFixture myFixture;
    @NotNull
    private static final Pattern pattern;
    private static final ParameterNameHintsSettings default;
    public static final Companion Companion;

    public final void setUp() {
        EditorSettingsExternalizable settings;
        EditorSettingsExternalizable editorSettingsExternalizable = settings = EditorSettingsExternalizable.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)editorSettingsExternalizable, (String)"settings");
        this.isParamHintsEnabledBefore = editorSettingsExternalizable.isShowParameterNameHints();
        settings.setShowParameterNameHints(true);
    }

    public final void tearDown() {
        EditorSettingsExternalizable editorSettingsExternalizable = EditorSettingsExternalizable.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)editorSettingsExternalizable, (String)"EditorSettingsExternalizable.getInstance()");
        editorSettingsExternalizable.setShowParameterNameHints(this.isParamHintsEnabledBefore);
        ParameterNameHintsSettings hintSettings = ParameterNameHintsSettings.Companion.getInstance();
        hintSettings.loadState(default.getState());
    }

    public final ParameterHintsPresentationManager getManager() {
        return this.manager;
    }

    @NotNull
    public final Function1<Inlay<?>, String> getInlayPresenter() {
        return this.inlayPresenter;
    }

    @NotNull
    public final Function1<Inlay<?>, Boolean> getInlayFilter() {
        return this.inlayFilter;
    }

    public final void checkParameterHints() {
        this.checkInlays(this.inlayPresenter, this.inlayFilter);
    }

    public final void checkInlays(@NotNull Function1<? super Inlay<?>, String> inlayPresenter2, @NotNull Function1<? super Inlay<?>, Boolean> inlayFilter2) {
        Document document;
        Intrinsics.checkParameterIsNotNull(inlayPresenter2, (String)"inlayPresenter");
        Intrinsics.checkParameterIsNotNull(inlayFilter2, (String)"inlayFilter");
        PsiFile file = this.myFixture.getFile();
        Document document2 = document = this.myFixture.getDocument(file);
        Intrinsics.checkExpressionValueIsNotNull((Object)document2, (String)"document");
        String string = document2.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"document.text");
        String originalText = string;
        CaretAndInlaysInfo expectedInlaysAndCaret = this.extractInlaysAndCaretInfo(document);
        this.myFixture.doHighlighting();
        this.verifyInlaysAndCaretInfo(expectedInlaysAndCaret, originalText, inlayPresenter2, inlayFilter2);
    }

    public final void verifyInlaysAndCaretInfo(@NotNull CaretAndInlaysInfo expectedInlaysAndCaret, @NotNull String originalText) {
        Intrinsics.checkParameterIsNotNull((Object)expectedInlaysAndCaret, (String)"expectedInlaysAndCaret");
        Intrinsics.checkParameterIsNotNull((Object)originalText, (String)"originalText");
        this.verifyInlaysAndCaretInfo(expectedInlaysAndCaret, originalText, this.inlayPresenter, this.inlayFilter);
    }

    private final void verifyInlaysAndCaretInfo(CaretAndInlaysInfo expectedInlaysAndCaret, String originalText, Function1<? super Inlay<?>, String> inlayPresenter2, Function1<? super Inlay<?>, Boolean> inlayFilter2) {
        block17: {
            List<InlayInfo> actual;
            Document document;
            PsiFile file;
            block16: {
                boolean bl2;
                block14: {
                    file = this.myFixture.getFile();
                    document = this.myFixture.getDocument(file);
                    actual = this.getActualInlays(inlayPresenter2, inlayFilter2);
                    List<InlayInfo> expected = expectedInlaysAndCaret.getInlays();
                    if (expectedInlaysAndCaret.getInlays().size() != actual.size()) break block16;
                    Iterable $receiver$iv = CollectionsKt.zip((Iterable)actual, (Iterable)expected);
                    if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (Iterator element$iv : $receiver$iv) {
                            Pair it2 = (Pair)element$iv;
                            if (!(Intrinsics.areEqual((Object)((InlayInfo)it2.getFirst()), (Object)((InlayInfo)it2.getSecond())) ^ true)) continue;
                            bl2 = true;
                            break block14;
                        }
                        bl2 = false;
                    }
                }
                if (!bl2) break block17;
            }
            List entries = new ArrayList();
            Iterable $receiver$iv = actual;
            for (Object element$iv : $receiver$iv) {
                String string;
                StringBuilder stringBuilder;
                Pair pair2;
                InlayInfo it3 = (InlayInfo)element$iv;
                Integer $i$f$any = it3.getOffset();
                Pair pair3 = pair2;
                Pair pair4 = pair2;
                List list2 = entries;
                StringBuilder $receiver = stringBuilder = new StringBuilder();
                $receiver.append("<");
                $receiver.append(it3.getHighlighted() ? "H" : "h");
                $receiver.append(it3.getCurrent() ? "INT" : "int");
                $receiver.append(" text=\"");
                $receiver.append(it3.getText());
                $receiver.append("\"/>");
                Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder.toString(), (String)"StringBuilder().apply(builderAction).toString()");
                pair3((Object)$i$f$any, (Object)string);
                list2.add(pair4);
            }
            if (expectedInlaysAndCaret.getCaretOffset() != null) {
                int n2;
                int actualInlaysBeforeCaret;
                int actualCaretOffset;
                block15: {
                    Editor editor = this.myFixture.getEditor();
                    Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"myFixture.editor");
                    CaretModel caretModel = editor.getCaretModel();
                    Intrinsics.checkExpressionValueIsNotNull((Object)caretModel, (String)"myFixture.editor.caretModel");
                    actualCaretOffset = caretModel.getOffset();
                    Editor editor2 = this.myFixture.getEditor();
                    Intrinsics.checkExpressionValueIsNotNull((Object)editor2, (String)"myFixture.editor");
                    CaretModel caretModel2 = editor2.getCaretModel();
                    Intrinsics.checkExpressionValueIsNotNull((Object)caretModel2, (String)"myFixture.editor.caretModel");
                    actualInlaysBeforeCaret = caretModel2.getVisualPosition().column - this.myFixture.getEditor().offsetToVisualPosition((int)actualCaretOffset).column;
                    List $receiver$iv2 = entries;
                    int index$iv = 0;
                    for (Object item$iv : $receiver$iv2) {
                        Pair it4 = (Pair)item$iv;
                        if (((Number)it4.getFirst()).intValue() == actualCaretOffset) {
                            n2 = index$iv;
                            break block15;
                        }
                        ++index$iv;
                    }
                    n2 = -1;
                }
                int first = n2;
                int insertIndex2 = first == -1 ? -CollectionsKt.binarySearch$default((List)entries, (int)0, (int)0, (Function1)((Function1)new Function1<Pair<? extends Integer, ? extends String>, Integer>(actualCaretOffset){
                    final /* synthetic */ int $actualCaretOffset;

                    public final int invoke(@NotNull Pair<Integer, String> it2) {
                        Intrinsics.checkParameterIsNotNull(it2, (String)"it");
                        return ((Number)it2.getFirst()).intValue() - this.$actualCaretOffset;
                    }
                    {
                        this.$actualCaretOffset = n2;
                        super(1);
                    }
                }), (int)3, null) - 1 : first + actualInlaysBeforeCaret;
                entries.add(insertIndex2, new Pair((Object)actualCaretOffset, (Object)"<caret>"));
            }
            Document document2 = document;
            Intrinsics.checkExpressionValueIsNotNull((Object)document2, (String)"document");
            StringBuilder proposedText = new StringBuilder(document2.getText());
            Iterable $receiver$iv3 = CollectionsKt.asReversedMutable((List)entries);
            for (Object element$iv : $receiver$iv3) {
                Pair it5 = (Pair)element$iv;
                proposedText.insert(((Number)it5.getFirst()).intValue(), (String)it5.getSecond());
            }
            PsiFile psiFile = file;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"file");
            String string = (String)VfsTestUtil.TEST_DATA_FILE_PATH.get((UserDataHolder)psiFile.getVirtualFile());
            if (string != null) {
                String string2;
                String originalPath = string2 = string;
                throw (Throwable)new FileComparisonFailure("Hints differ", originalText, proposedText.toString(), originalPath);
            }
            throw (Throwable)new ComparisonFailure("Hints differ", originalText, proposedText.toString());
        }
        if (expectedInlaysAndCaret.getCaretOffset() != null) {
            Integer n3 = expectedInlaysAndCaret.getCaretOffset();
            Editor editor = this.myFixture.getEditor();
            Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"myFixture.editor");
            CaretModel caretModel = editor.getCaretModel();
            Intrinsics.checkExpressionValueIsNotNull((Object)caretModel, (String)"myFixture.editor.caretModel");
            Assert.assertEquals((String)"Unexpected caret offset", (Object)n3, (Object)caretModel.getOffset());
            VisualPosition visualPosition = this.myFixture.getEditor().offsetToVisualPosition(expectedInlaysAndCaret.getCaretOffset().intValue());
            Intrinsics.checkExpressionValueIsNotNull((Object)visualPosition, (String)"myFixture.editor.offsetT\u2026laysAndCaret.caretOffset)");
            VisualPosition position = visualPosition;
            VisualPosition visualPosition2 = new VisualPosition(position.line, position.column + expectedInlaysAndCaret.getInlaysBeforeCaret());
            Editor editor3 = this.myFixture.getEditor();
            Intrinsics.checkExpressionValueIsNotNull((Object)editor3, (String)"myFixture.editor");
            CaretModel caretModel3 = editor3.getCaretModel();
            Intrinsics.checkExpressionValueIsNotNull((Object)caretModel3, (String)"myFixture.editor.caretModel");
            Assert.assertEquals((String)"Unexpected caret visual position", (Object)visualPosition2, (Object)caretModel3.getVisualPosition());
            Editor editor4 = this.myFixture.getEditor();
            Intrinsics.checkExpressionValueIsNotNull((Object)editor4, (String)"myFixture.editor");
            SelectionModel selectionModel = editor4.getSelectionModel();
            Intrinsics.checkExpressionValueIsNotNull((Object)selectionModel, (String)"myFixture.editor.selectionModel");
            SelectionModel selectionModel2 = selectionModel;
            if (expectedInlaysAndCaret.getSelection() == null) {
                Assert.assertFalse((boolean)selectionModel2.hasSelection());
            } else {
                Assert.assertEquals((String)"Unexpected selection", (Object)expectedInlaysAndCaret.getSelection(), (Object)new TextRange(selectionModel2.getSelectionStart(), selectionModel2.getSelectionEnd()));
            }
        }
    }

    private final List<InlayInfo> getActualInlays(Function1<? super Inlay<?>, String> inlayPresenter2, Function1<? super Inlay<?>, Boolean> inlayFilter2) {
        Inlay it2;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        Editor editor;
        Editor editor2 = editor = this.myFixture.getEditor();
        Intrinsics.checkExpressionValueIsNotNull((Object)editor2, (String)"editor");
        InlayModel inlayModel = editor2.getInlayModel();
        Document document = editor.getDocument();
        Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"editor.document");
        List list2 = inlayModel.getInlineElementsInRange(0, document.getTextLength());
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"editor.inlayModel.getInl\u2026itor.document.textLength)");
        List allInlays = list2;
        ParameterHintsPresentationManager hintManager = ParameterHintsPresentationManager.getInstance();
        Iterable iterable = CollectionsKt.filterNotNull((Iterable)allInlays);
        Iterable iterable2 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it2 = (Inlay)element$iv$iv;
            if (!((Boolean)inlayFilter2.invoke((Object)it2)).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            boolean isCurrent;
            boolean isHighlighted;
            it2 = (Inlay)item$iv$iv;
            Collection collection = destination$iv$iv;
            if (hintManager.isParameterHint(it2)) {
                isHighlighted = hintManager.isHighlighted(it2);
                isCurrent = hintManager.isCurrent(it2);
            } else {
                isHighlighted = false;
                isCurrent = false;
            }
            InlayInfo inlayInfo = new InlayInfo(it2.getOffset(), (String)inlayPresenter2.invoke((Object)it2), isHighlighted, isCurrent);
            collection.add(inlayInfo);
        }
        $receiver$iv = (List)destination$iv$iv;
        iterable2 = $receiver$iv;
        Comparator comparator2 = new Comparator<T>(){

            public final int compare(T a10, T b10) {
                InlayInfo it2 = (InlayInfo)a10;
                Comparable comparable = Integer.valueOf(it2.getOffset());
                it2 = (InlayInfo)b10;
                Comparable comparable2 = comparable;
                Integer n2 = it2.getOffset();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n2);
            }
        };
        return CollectionsKt.sortedWith((Iterable)iterable2, (Comparator)comparator2);
    }

    @NotNull
    public final CaretAndInlaysInfo extractInlaysAndCaretInfo(@NotNull Document document) {
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        String string = document.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"document.text");
        String text2 = string;
        Matcher matcher = pattern.matcher(text2);
        List inlays = new ArrayList();
        int extractedLength = 0;
        Integer caretOffset = null;
        int inlaysBeforeCaret = 0;
        Integer selectionStart = null;
        Integer selectionEnd = null;
        while (matcher.find()) {
            Iterable iterable;
            int start = matcher.start();
            int matchedLength = matcher.end() - start;
            int realStartOffset = start - extractedLength;
            if (matcher.group(1) != null) {
                Object item$iv;
                InlayInfo it2;
                Iterable $receiver$iv;
                caretOffset = realStartOffset;
                iterable = CollectionsKt.asReversedMutable((List)inlays);
                ArrayList list$iv = new ArrayList();
                Iterator iterator = $receiver$iv.iterator();
                while (iterator.hasNext() && (it2 = (InlayInfo)(item$iv = iterator.next())).getOffset() == caretOffset.intValue()) {
                    list$iv.add(item$iv);
                }
                $receiver$iv = list$iv;
                for (Object element$iv : $receiver$iv) {
                    InlayInfo it3 = (InlayInfo)element$iv;
                    int n2 = inlaysBeforeCaret;
                    inlaysBeforeCaret = n2 + 1;
                }
            } else if (matcher.group(2) != null) {
                selectionStart = realStartOffset;
            } else if (matcher.group(3) != null) {
                selectionEnd = realStartOffset;
            } else {
                iterable = inlays;
                String string2 = matcher.group(5);
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"matcher.group(5)");
                String string3 = matcher.group(4);
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"matcher.group(4)");
                boolean bl2 = StringsKt.startsWith$default((String)string3, (String)"H", (boolean)false, (int)2, null);
                String string4 = matcher.group(4);
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"matcher.group(4)");
                InlayInfo inlayInfo = new InlayInfo(realStartOffset, string2, bl2, StringsKt.endsWith$default((String)string4, (String)"INT", (boolean)false, (int)2, null));
                iterable.add(inlayInfo);
            }
            this.removeText(document, realStartOffset, matchedLength);
            extractedLength += matcher.end() - start;
        }
        return new CaretAndInlaysInfo(caretOffset, inlaysBeforeCaret, selectionStart == null || selectionEnd == null ? null : new TextRange(selectionStart.intValue(), selectionEnd.intValue()), inlays);
    }

    private final void removeText(Document document, int realStartOffset, int matchedLength) {
        WriteCommandAction.runWriteCommandAction((Project)this.myFixture.getProject(), (Runnable)new Runnable(document, realStartOffset, matchedLength){
            final /* synthetic */ Document $document;
            final /* synthetic */ int $realStartOffset;
            final /* synthetic */ int $matchedLength;

            public final void run() {
                this.$document.replaceString(this.$realStartOffset, this.$realStartOffset + this.$matchedLength, (CharSequence)"");
            }
            {
                this.$document = document;
                this.$realStartOffset = n2;
                this.$matchedLength = n3;
            }
        });
    }

    public InlayHintsChecker(@NotNull CodeInsightTestFixture myFixture) {
        Intrinsics.checkParameterIsNotNull((Object)myFixture, (String)"myFixture");
        this.myFixture = myFixture;
        this.manager = ParameterHintsPresentationManager.getInstance();
        this.inlayPresenter = inlayPresenter.1.INSTANCE;
        this.inlayFilter = new Function1<Inlay<?>, Boolean>(this){
            final /* synthetic */ InlayHintsChecker this$0;

            public final boolean invoke(@NotNull Inlay<?> it2) {
                Intrinsics.checkParameterIsNotNull(it2, (String)"it");
                return this.this$0.getManager().isParameterHint(it2);
            }
            {
                this.this$0 = inlayHintsChecker;
                super(1);
            }
        };
    }

    static {
        Companion = new Companion(null);
        Pattern pattern = Pattern.compile("(<caret>)|(<selection>)|(</selection>)|<(hint|HINT|Hint|hINT)\\s+text=\"([^\"\n\r]+)\"\\s*/>");
        Intrinsics.checkExpressionValueIsNotNull((Object)pattern, (String)"Pattern.compile(\"(<caret\u2026=\\\"([^\\\"\\n\\r]+)\\\"\\\\s*/>\")");
        InlayHintsChecker.pattern = pattern;
        default = new ParameterNameHintsSettings();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/testFramework/utils/inlays/InlayHintsChecker$Companion;", "", "()V", "default", "Lcom/intellij/codeInsight/hints/settings/ParameterNameHintsSettings;", "pattern", "Ljava/util/regex/Pattern;", "getPattern", "()Ljava/util/regex/Pattern;", "intellij.platform.testFramework"})
    public static final class Companion {
        @NotNull
        public final Pattern getPattern() {
            return pattern;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

