/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures.impl;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.idea.IdeaTestApplication;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.psi.codeStyle.CodeStyleSchemes;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageManagerImpl;
import com.intellij.testFramework.CodeStyleSettingsTracker;
import com.intellij.testFramework.LightPlatformTestCase;
import com.intellij.testFramework.LightProjectDescriptor;
import com.intellij.testFramework.PlatformTestCase;
import com.intellij.testFramework.RunAll;
import com.intellij.testFramework.SdkLeakTracker;
import com.intellij.testFramework.TestDataProvider;
import com.intellij.testFramework.fixtures.LightIdeaTestFixture;
import com.intellij.testFramework.fixtures.impl.BaseFixture;
import com.intellij.util.ThrowableRunnable;
import org.jetbrains.annotations.NotNull;

public class LightIdeaTestFixtureImpl
extends BaseFixture
implements LightIdeaTestFixture {
    private final LightProjectDescriptor myProjectDescriptor;
    private SdkLeakTracker myOldSdks;
    private CodeStyleSettingsTracker myCodeStyleSettingsTracker;

    public LightIdeaTestFixtureImpl(@NotNull LightProjectDescriptor projectDescriptor) {
        if (projectDescriptor == null) {
            LightIdeaTestFixtureImpl.$$$reportNull$$$0(0);
        }
        this.myProjectDescriptor = projectDescriptor;
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        IdeaTestApplication application = LightPlatformTestCase.initApplication();
        LightPlatformTestCase.doSetup(this.myProjectDescriptor, LocalInspectionTool.EMPTY_ARRAY, this.getTestRootDisposable());
        InjectedLanguageManagerImpl.pushInjectors((Project)this.getProject());
        this.myCodeStyleSettingsTracker = new CodeStyleSettingsTracker(this::getCurrentCodeStyleSettings);
        application.setDataProvider(new TestDataProvider(this.getProject()));
        this.myOldSdks = new SdkLeakTracker();
    }

    @Override
    public void tearDown() {
        Project project2 = this.getProject();
        CodeStyle.dropTemporarySettings((Project)project2);
        new RunAll(new ThrowableRunnable[0]).append(() -> {
            if (this.myCodeStyleSettingsTracker != null) {
                this.myCodeStyleSettingsTracker.checkForSettingsDamage();
            }
        }).append(() -> super.tearDown()).append(() -> {
            if (project2 != null) {
                LightPlatformTestCase.doTearDown(project2, LightPlatformTestCase.getApplication());
            }
        }).append(() -> LightPlatformTestCase.checkEditorsReleased()).append(() -> {
            SdkLeakTracker oldSdks = this.myOldSdks;
            if (oldSdks != null) {
                oldSdks.checkForJdkTableLeaks();
            }
        }).append(() -> InjectedLanguageManagerImpl.checkInjectorsAreDisposed((Project)project2)).append(() -> PersistentFS.getInstance().clearIdCache()).append(() -> PlatformTestCase.cleanupApplicationCaches(project2)).run();
    }

    @Override
    public Project getProject() {
        return LightPlatformTestCase.getProject();
    }

    protected CodeStyleSettings getCurrentCodeStyleSettings() {
        if (CodeStyleSchemes.getInstance().getCurrentScheme() == null) {
            return new CodeStyleSettings();
        }
        return CodeStyle.getSettings((Project)this.getProject());
    }

    @Override
    public Module getModule() {
        return LightPlatformTestCase.getModule();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectDescriptor", "com/intellij/testFramework/fixtures/impl/LightIdeaTestFixtureImpl", "<init>"));
    }
}

