/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures;

import com.intellij.lang.Language;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.testFramework.LightProjectDescriptor;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.testFramework.fixtures.CodeInsightTestFixture;
import com.intellij.testFramework.fixtures.IdeaProjectTestFixture;
import com.intellij.testFramework.fixtures.IdeaTestExecutionPolicy;
import com.intellij.testFramework.fixtures.IdeaTestFixtureFactory;
import com.intellij.testFramework.fixtures.TempDirTestFixture;
import com.intellij.testFramework.fixtures.TestFixtureBuilder;
import com.intellij.testFramework.fixtures.impl.LightTempDirTestFixtureImpl;

public abstract class LightPlatformCodeInsightFixtureTestCase
extends UsefulTestCase {
    protected CodeInsightTestFixture myFixture;
    protected Module myModule;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        IdeaTestFixtureFactory factory2 = IdeaTestFixtureFactory.getFixtureFactory();
        TestFixtureBuilder<IdeaProjectTestFixture> fixtureBuilder = factory2.createLightFixtureBuilder(this.getProjectDescriptor());
        IdeaProjectTestFixture fixture = fixtureBuilder.getFixture();
        IdeaTestExecutionPolicy policy = IdeaTestExecutionPolicy.current();
        TempDirTestFixture tempDirFixture = policy != null ? policy.createTempDirTestFixture() : new LightTempDirTestFixtureImpl(true);
        this.myFixture = IdeaTestFixtureFactory.getFixtureFactory().createCodeInsightFixture(fixture, tempDirFixture);
        this.myFixture.setTestDataPath(this.getTestDataPath());
        this.myFixture.setUp();
        this.myModule = this.myFixture.getModule();
    }

    @Override
    protected void tearDown() throws Exception {
        try {
            this.myFixture.tearDown();
        }
        finally {
            this.myFixture = null;
            this.myModule = null;
            super.tearDown();
        }
    }

    protected String getBasePath() {
        return "";
    }

    protected LightProjectDescriptor getProjectDescriptor() {
        return null;
    }

    protected String getTestDataPath() {
        String path = this.isCommunity() ? PlatformTestUtil.getCommunityPath() : PathManager.getHomePath();
        return StringUtil.trimEnd((String)FileUtil.toSystemIndependentName((String)path), (String)"/") + '/' + StringUtil.trimStart((String)FileUtil.toSystemIndependentName((String)this.getBasePath()), (String)"/");
    }

    protected boolean isCommunity() {
        return false;
    }

    @Override
    protected void runTest() throws Throwable {
        if (this.isWriteActionRequired()) {
            WriteCommandAction.writeCommandAction((Project)this.getProject()).run(() -> this.doRunTests());
        } else {
            this.doRunTests();
        }
    }

    protected boolean isWriteActionRequired() {
        return false;
    }

    protected void doRunTests() throws Throwable {
        super.runTest();
    }

    protected Project getProject() {
        return this.myFixture.getProject();
    }

    protected PsiManager getPsiManager() {
        return PsiManager.getInstance((Project)this.getProject());
    }

    protected PsiFile createLightFile(FileType fileType, String text2) {
        return PsiFileFactory.getInstance((Project)this.getProject()).createFileFromText("a." + fileType.getDefaultExtension(), fileType, (CharSequence)text2);
    }

    public PsiFile createLightFile(String fileName, Language language, String text2) {
        return PsiFileFactory.getInstance((Project)this.getProject()).createFileFromText(fileName, language, (CharSequence)text2, false, true);
    }
}

