/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.project.Project;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class TestDataProvider
implements DataProvider,
DataContext {
    private final Project myProject;

    public TestDataProvider(@NotNull Project project2) {
        if (project2 == null) {
            TestDataProvider.$$$reportNull$$$0(0);
        }
        this.myProject = project2;
    }

    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            TestDataProvider.$$$reportNull$$$0(1);
        }
        if (this.myProject.isDisposed()) {
            throw new RuntimeException("TestDataProvider is already disposed for " + this.myProject + "\nIf you closed a project in test, please reset IdeaTestApplication.setDataProvider.");
        }
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return this.myProject;
        }
        FileEditorManagerEx manager = FileEditorManagerEx.getInstanceEx((Project)this.myProject);
        if (manager == null) {
            return null;
        }
        if (CommonDataKeys.EDITOR.is(dataId) || OpenFileDescriptor.NAVIGATE_IN_EDITOR.is(dataId)) {
            return manager instanceof FileEditorManagerImpl ? ((FileEditorManagerImpl)manager).getSelectedTextEditor(true) : manager.getSelectedTextEditor();
        }
        if (PlatformDataKeys.FILE_EDITOR.is(dataId)) {
            Editor editor = manager.getSelectedTextEditor();
            return editor == null ? null : TextEditorProvider.getInstance().getTextEditor(editor);
        }
        Editor editor = (Editor)this.getData(CommonDataKeys.EDITOR.getName());
        if (editor != null) {
            Object managerData = manager.getData(dataId, editor, editor.getCaretModel().getCurrentCaret());
            if (managerData != null) {
                return managerData;
            }
            JComponent component = editor.getContentComponent();
            if (component instanceof EditorComponentImpl) {
                return ((EditorComponentImpl)component).getData(dataId);
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        objectArray2[1] = "com/intellij/testFramework/TestDataProvider";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getData";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

