/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.DefaultLogger;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class LoggedErrorProcessor {
    private static final LoggedErrorProcessor DEFAULT;
    private static LoggedErrorProcessor ourInstance;

    @NotNull
    public static LoggedErrorProcessor getInstance() {
        LoggedErrorProcessor loggedErrorProcessor = ourInstance;
        if (loggedErrorProcessor == null) {
            LoggedErrorProcessor.$$$reportNull$$$0(0);
        }
        return loggedErrorProcessor;
    }

    public static void setNewInstance(@NotNull LoggedErrorProcessor newInstance) {
        if (newInstance == null) {
            LoggedErrorProcessor.$$$reportNull$$$0(1);
        }
        ourInstance = newInstance;
    }

    public static void restoreDefaultProcessor() {
        ourInstance = DEFAULT;
    }

    public void processWarn(String message, Throwable t2, @NotNull Logger logger) {
        if (logger == null) {
            LoggedErrorProcessor.$$$reportNull$$$0(2);
        }
        logger.warn((Object)message, t2);
    }

    public void processError(String message, Throwable t2, String[] details, @NotNull Logger logger) {
        if (logger == null) {
            LoggedErrorProcessor.$$$reportNull$$$0(3);
        }
        message = message + DefaultLogger.attachmentsToString((Throwable)t2);
        logger.info((Object)message, t2);
        if (DefaultLogger.shouldDumpExceptionToStderr()) {
            System.err.println("ERROR: " + message);
            if (t2 != null) {
                t2.printStackTrace(System.err);
            }
            if (details != null && details.length > 0) {
                System.err.println("details: ");
                for (String detail : details) {
                    System.err.println(detail);
                }
            }
        }
        throw new AssertionError(message, t2);
    }

    public void disableStderrDumping(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            LoggedErrorProcessor.$$$reportNull$$$0(4);
        }
        DefaultLogger.disableStderrDumping((Disposable)parentDisposable);
    }

    static {
        ourInstance = DEFAULT = new LoggedErrorProcessor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/LoggedErrorProcessor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newInstance";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logger";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/LoggedErrorProcessor";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setNewInstance";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processWarn";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processError";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "disableStderrDumping";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

