/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.rename;

import com.intellij.jam.JamElement;
import com.intellij.jam.JamService;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.openapi.project.Project;
import com.intellij.pom.PomTarget;
import com.intellij.pom.references.PomService;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiTarget;
import com.intellij.psi.targets.AliasingPsiTarget;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.semantic.SemService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class AliasingPomTargetRenameHandler
extends RenamePsiElementProcessor {
    private static ArrayList<AliasingPsiTarget> getTargets(PsiMember psiMember) {
        ArrayList<AliasingPsiTarget> result = new ArrayList<AliasingPsiTarget>();
        List metas = SemService.getSemService((Project)psiMember.getProject()).getSemElements(JamService.ALIASING_MEMBER_META_KEY, (PsiElement)psiMember);
        for (JamMemberMeta meta : metas) {
            JamElement element = meta.getJamElement((PsiModifierListOwner)psiMember);
            if (element == null) continue;
            for (PomTarget target : meta.getAssociatedTargets(element)) {
                if (!(target instanceof AliasingPsiTarget)) continue;
                AliasingPsiTarget psiTarget = (AliasingPsiTarget)target;
                result.add(psiTarget);
            }
        }
        return result;
    }

    public void prepareRenaming(@NotNull PsiElement element, @NotNull String newName, @NotNull Map<PsiElement, String> allRenames) {
        if (element == null) {
            AliasingPomTargetRenameHandler.$$$reportNull$$$0(0);
        }
        if (newName == null) {
            AliasingPomTargetRenameHandler.$$$reportNull$$$0(1);
        }
        if (allRenames == null) {
            AliasingPomTargetRenameHandler.$$$reportNull$$$0(2);
        }
        if (element instanceof PsiMember) {
            ArrayList<AliasingPsiTarget> targets = AliasingPomTargetRenameHandler.getTargets((PsiMember)element);
            for (AliasingPsiTarget target : targets) {
                String aliasName = target.getNameAlias(newName);
                assert (aliasName != null);
                PsiElement convertedElement = PomService.convertToPsi((PsiTarget)target);
                allRenames.put(convertedElement, aliasName);
            }
        }
    }

    public boolean isInplaceRenameSupported() {
        return false;
    }

    public boolean canProcessElement(@NotNull PsiElement element) {
        if (element == null) {
            AliasingPomTargetRenameHandler.$$$reportNull$$$0(3);
        }
        if (element instanceof PsiMember && element.isValid()) {
            PsiMember psiMember = (PsiMember)element;
            return !AliasingPomTargetRenameHandler.getTargets(psiMember).isEmpty();
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allRenames";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/rename/AliasingPomTargetRenameHandler";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "prepareRenaming";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "canProcessElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

