/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.async;

import b.a.lb;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.RunConfigurationExtension;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemProcessHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.profiler.ProfilerManager;
import com.intellij.profiler.api.DataReady;
import com.intellij.profiler.api.ProfilerError;
import com.intellij.profiler.api.ProfilerState;
import com.intellij.profiler.linux.HasInvalidVariables;
import com.intellij.profiler.linux.KernelVariable;
import com.intellij.profiler.linux.KernelVariablesChangeRequiredException;
import com.intellij.profiler.linux.KernelVariablesValidatorKt;
import com.intellij.profiler.linux.ValidationResult;
import com.intellij.profiler.ultimate.async.AgentConfiguration;
import com.intellij.profiler.ultimate.async.AgentOptions;
import com.intellij.profiler.ultimate.async.AsyncMisConfigured;
import com.intellij.profiler.ultimate.async.AsyncProfilerConfigurationExtension;
import com.intellij.profiler.ultimate.async.AsyncProfilerConfigurationExtensionKt;
import com.intellij.profiler.ultimate.async.AsyncProfilerGradleProcess;
import com.intellij.profiler.ultimate.async.AsyncProfilerProcess;
import com.intellij.profiler.ultimate.async.AsyncProfilerProcessBase;
import com.intellij.profiler.ultimate.async.AsyncProfilerRunnerSettings;
import com.intellij.profiler.ultimate.async.AsyncProfilerSettings;
import com.intellij.profiler.ultimate.async.AttachAsyncProfilerProviderKt;
import com.intellij.profiler.ultimate.async.UtilsKt;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0014J\u0016\u0010\u000b\u001a\u00020\u00042\f\u0010\f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0006H\u0016J\u0014\u0010\r\u001a\u00020\u000e2\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0016J9\u0010\u000f\u001a\u00020\u0004\"\u000e\b\u0000\u0010\u0010*\b\u0012\u0002\b\u0003\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u0002H\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016\u00a2\u0006\u0002\u0010\u0013\u00a8\u0006\u0015"}, d2={"Lcom/intellij/profiler/ultimate/async/AsyncProfilerConfigurationExtension;", "Lcom/intellij/execution/RunConfigurationExtension;", "()V", "attachToProcess", "", "configuration", "Lcom/intellij/execution/configurations/RunConfigurationBase;", "handler", "Lcom/intellij/execution/process/ProcessHandler;", "runnerSettings", "Lcom/intellij/execution/configurations/RunnerSettings;", "cleanUserData", "runConfigurationBase", "isApplicableFor", "", "updateJavaParameters", "T", "params", "Lcom/intellij/execution/configurations/JavaParameters;", "(Lcom/intellij/execution/configurations/RunConfigurationBase;Lcom/intellij/execution/configurations/JavaParameters;Lcom/intellij/execution/configurations/RunnerSettings;)V", "Companion", "intellij.profiler.ultimate"})
public final class AsyncProfilerConfigurationExtension
extends RunConfigurationExtension {
    @NotNull
    private static final Key<AgentConfiguration> b;
    @NotNull
    private static final List<KernelVariable> a;
    public static final Companion Companion;
    private static final long c;

    public boolean isApplicableFor(@NotNull RunConfigurationBase<?> configuration) {
        long l2 = c ^ 0x51A224624DF2L;
        Intrinsics.checkParameterIsNotNull(configuration, (String)"configuration");
        return UtilsKt.asyncProfilerCanBeUsed();
    }

    @Override
    public <T extends RunConfigurationBase<?>> void updateJavaParameters(T configuration, @Nullable JavaParameters params, @Nullable RunnerSettings runnerSettings) {
        long l2 = c ^ 0x609553945EDBL;
        if (!(runnerSettings instanceof AsyncProfilerRunnerSettings) || params == null || configuration == null) {
            return;
        }
        File file = new File(UtilsKt.getNativeAgentPath());
        if (!file.exists()) {
            String string = "Can't find native agent at " + file.getPath();
            Project project2 = configuration.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"configuration.getProject()");
            throw (Throwable)((Object)new AsyncMisConfigured(string, project2));
        }
        ValidationResult validationResult = KernelVariablesValidatorKt.checkKernelVariables(a);
        if (validationResult instanceof HasInvalidVariables) {
            HasInvalidVariables hasInvalidVariables = (HasInvalidVariables)validationResult;
            Project project3 = configuration.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"configuration.getProject()");
            throw (Throwable)((Object)new KernelVariablesChangeRequiredException(hasInvalidVariables, project3));
        }
        String string = UtilsKt.tryToHandleSpacesInAgentPath(file);
        File file2 = FileUtil.createTempFile((String)"asyncprofiler", (String)".dump", (boolean)true);
        Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"FileUtil.createTempFile(\u2026profiler\", \".dump\", true)");
        File file3 = file2;
        AgentOptions agentOptions = AsyncProfilerSettings.Companion.getInstance().agentOptions();
        configuration.putUserData(b, (Object)new AgentConfiguration(string, agentOptions, file3));
        String string2 = agentOptions.startAgent(file3);
        String string3 = "-agentpath:" + string + '=' + string2;
        AsyncProfilerConfigurationExtensionKt.access$getLOG$p().info("start profiler from run configuration, add VM parameters: " + string3);
        params.getVMParametersList().add(string3);
    }

    protected void attachToProcess(@NotNull RunConfigurationBase<?> configuration, @NotNull ProcessHandler handler, @Nullable RunnerSettings runnerSettings) {
        AsyncProfilerProcessBase asyncProfilerProcessBase;
        long l2 = c ^ 0x12804A3E643AL;
        Intrinsics.checkParameterIsNotNull(configuration, (String)"configuration");
        Intrinsics.checkParameterIsNotNull((Object)handler, (String)"handler");
        if (!(runnerSettings instanceof AsyncProfilerRunnerSettings)) {
            return;
        }
        AgentConfiguration agentConfiguration = (AgentConfiguration)configuration.getUserData(b);
        if (agentConfiguration == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)agentConfiguration, (String)"configuration.getUserDat\u2026FIGURATION_KEY) ?: return");
        AgentConfiguration agentConfiguration2 = agentConfiguration;
        Project project2 = configuration.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"configuration.project");
        Project project3 = project2;
        ProcessHandler processHandler = handler;
        if (processHandler instanceof ExternalSystemProcessHandler) {
            asyncProfilerProcessBase = new AsyncProfilerGradleProcess(project3, agentConfiguration2, (ExternalSystemProcessHandler)handler, System.currentTimeMillis());
        } else if (processHandler instanceof BaseOSProcessHandler) {
            String string = configuration.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"configuration.name");
            asyncProfilerProcessBase = new AsyncProfilerProcess(project3, string, agentConfiguration2, (BaseOSProcessHandler)handler, System.currentTimeMillis());
        } else {
            AsyncProfilerConfigurationExtensionKt.access$getLOG$p().error("unexpected process handler: " + handler);
            throw (Throwable)new ExecutionException("Can't start profiler: unsupported configuration");
        }
        AsyncProfilerProcessBase asyncProfilerProcessBase2 = asyncProfilerProcessBase;
        AttachAsyncProfilerProviderKt.attachProfilerTab(asyncProfilerProcessBase2, false);
        asyncProfilerProcessBase2.addStateChangedListener((Function2<? super ProfilerState, ? super ProfilerState, Unit>)((Function2)new Function2<ProfilerState, ProfilerState, Unit>(project3){
            final /* synthetic */ Project $project;
            private static final long a;

            public final void invoke(@NotNull ProfilerState $noName_0, @NotNull ProfilerState newState) {
                long l2 = a ^ 0x17D003FB0223L;
                Intrinsics.checkParameterIsNotNull((Object)$noName_0, (String)"<anonymous parameter 0>");
                Intrinsics.checkParameterIsNotNull((Object)newState, (String)"newState");
                if (newState instanceof ProfilerError) {
                    ProfilerManager.INSTANCE.showErrorBalloon("Profiler error: " + ((ProfilerError)newState).getReason(), this.$project);
                } else if (newState instanceof DataReady) {
                    ProfilerManager.INSTANCE.showInfoBalloon("Profiler data is ready", this.$project);
                }
            }
            {
                this.$project = project2;
                super(2);
            }

            static {
                a = lb.a(7774315091048475364L, -6352678508947426578L, MethodHandles.lookup().lookupClass()).a(6924229442973L);
            }
        }));
    }

    public void cleanUserData(@Nullable RunConfigurationBase<?> runConfigurationBase) {
        block0: {
            RunConfigurationBase<?> runConfigurationBase2 = runConfigurationBase;
            if (runConfigurationBase2 == null) break block0;
            runConfigurationBase2.putUserData(b, null);
        }
    }

    static {
        c = lb.a(-6546375900891849498L, 9103744161079698756L, MethodHandles.lookup().lookupClass()).a(200400707408989L);
        long l2 = c ^ 0x2C4CA31FC60AL;
        Companion = new Companion(null);
        Key key = Key.create((String)"async.profiler.agent.configuration");
        Intrinsics.checkExpressionValueIsNotNull((Object)key, (String)"Key.create<AgentConfigur\u2026ler.agent.configuration\")");
        b = key;
        a = CollectionsKt.listOf((Object[])new KernelVariable[]{new KernelVariable("perf_event_paranoid", "1", (Function1<? super String, Boolean>)((Function1)Companion.requiredKernelVariables.1.INSTANCE)), new KernelVariable("kptr_restrict", "0", (Function1<? super String, Boolean>)((Function1)Companion.requiredKernelVariables.2.INSTANCE))});
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001f\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/intellij/profiler/ultimate/async/AsyncProfilerConfigurationExtension$Companion;", "", "()V", "PROFILER_AGENT_CONFIGURATION_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/profiler/ultimate/async/AgentConfiguration;", "kotlin.jvm.PlatformType", "getPROFILER_AGENT_CONFIGURATION_KEY", "()Lcom/intellij/openapi/util/Key;", "requiredKernelVariables", "", "Lcom/intellij/profiler/linux/KernelVariable;", "getRequiredKernelVariables", "()Ljava/util/List;", "intellij.profiler.ultimate"})
    public static final class Companion {
        @NotNull
        public final Key<AgentConfiguration> getPROFILER_AGENT_CONFIGURATION_KEY() {
            return b;
        }

        @NotNull
        public final List<KernelVariable> getRequiredKernelVariables() {
            return a;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

