/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot.daemon;

import b.a.lb;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.impl.libraries.LibraryImpl;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.ui.configuration.ModuleEditor;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.libraries.LibraryEditingUtil;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.ExistingLibraryEditor;
import com.intellij.openapi.roots.ui.configuration.projectRoot.BaseLibrariesConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesModifiableModel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibraryConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ConfigurationErrorQuickFix;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.PlaceInProjectStructure;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.PlaceInProjectStructureBase;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElementUsage;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemDescription;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemType;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemsHolder;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.a;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class LibraryProjectStructureElement
extends ProjectStructureElement {
    private final Library a;
    private static final long b = lb.a(2329456931726317793L, 7202618034673520970L, MethodHandles.lookup().lookupClass()).a(82965495417067L);

    public LibraryProjectStructureElement(@NotNull StructureConfigurableContext context, @NotNull Library library) {
        if (context == null) {
            LibraryProjectStructureElement.b(0);
        }
        if (library == null) {
            LibraryProjectStructureElement.b(1);
        }
        super(context);
        this.a = library;
    }

    public Library getLibrary() {
        return this.a;
    }

    @Override
    public void check(ProjectStructureProblemsHolder problemsHolder) {
        long l2 = b ^ 0x62A2F82572F3L;
        if (((LibraryEx)this.a).isDisposed()) {
            return;
        }
        LibraryEx libraryEx = (LibraryEx)this.myContext.getLibraryModel(this.a);
        if (libraryEx == null || libraryEx.isDisposed()) {
            return;
        }
        this.a(problemsHolder, libraryEx, OrderRootType.CLASSES, "classes", ProjectStructureProblemType.error("library-invalid-classes-path"));
        String string = libraryEx.getName();
        if (string == null || !string.startsWith("Maven: ")) {
            this.a(problemsHolder, libraryEx, OrderRootType.SOURCES, "sources", ProjectStructureProblemType.warning("library-invalid-source-javadoc-path"));
            this.a(problemsHolder, libraryEx, JavadocOrderRootType.getInstance(), "javadoc", ProjectStructureProblemType.warning("library-invalid-source-javadoc-path"));
        }
    }

    private void a(ProjectStructureProblemsHolder projectStructureProblemsHolder, LibraryEx libraryEx, @NotNull OrderRootType orderRootType, String string, ProjectStructureProblemType projectStructureProblemType) {
        List list2;
        long l2 = b ^ 0x236137704372L;
        if (orderRootType == null) {
            LibraryProjectStructureElement.b(2);
        }
        if (!(list2 = libraryEx.getInvalidRootUrls(orderRootType)).isEmpty()) {
            String string2 = LibraryProjectStructureElement.a(list2, string, libraryEx.getName());
            PlaceInProjectStructure placeInProjectStructure = this.a();
            String string3 = ProjectBundle.message((String)"project.roots.error.message.invalid.roots", (Object[])new Object[]{string, list2.size()});
            ProjectStructureProblemDescription.ProblemLevel problemLevel = libraryEx.getTable().getTableLevel().equals("project") ? ProjectStructureProblemDescription.ProblemLevel.PROJECT : ProjectStructureProblemDescription.ProblemLevel.GLOBAL;
            projectStructureProblemsHolder.registerProblem(new ProjectStructureProblemDescription(string3, string2, placeInProjectStructure, projectStructureProblemType, problemLevel, Collections.singletonList(new RemoveInvalidRootsQuickFix(this, (Library)libraryEx, orderRootType, list2)), true));
        }
    }

    private static String a(List<String> list2, String string, String string2) {
        long l2 = b ^ 0x7F8BEABD4DA2L;
        StringBuilder stringBuilder = new StringBuilder();
        String string3 = StringUtil.escapeXml((String)string2);
        stringBuilder.append("Library ");
        stringBuilder.append("<a href='http://library/").append(string3).append("'>").append(string3).append("</a>");
        stringBuilder.append(" has broken " + string + " " + StringUtil.pluralize((String)"path", (int)list2.size()) + ":");
        for (String string4 : list2) {
            stringBuilder.append("<br>&nbsp;&nbsp;");
            stringBuilder.append(PathUtil.toPresentableUrl((String)string4));
        }
        return XmlStringUtil.wrapInHtml((CharSequence)stringBuilder);
    }

    @NotNull
    private PlaceInProjectStructure a() {
        Project project2 = this.myContext.getProject();
        PlaceInProjectStructureBase placeInProjectStructureBase = new PlaceInProjectStructureBase(project2, ProjectStructureConfigurable.getInstance(project2).createProjectOrGlobalLibraryPlace(this.a), this);
        if (placeInProjectStructureBase == null) {
            LibraryProjectStructureElement.b(3);
        }
        return placeInProjectStructureBase;
    }

    @Override
    public List<ProjectStructureElementUsage> getUsagesInElement() {
        return Collections.emptyList();
    }

    @Override
    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (!(o2 instanceof LibraryProjectStructureElement)) {
            return false;
        }
        return this.b() == ((LibraryProjectStructureElement)o2).b();
    }

    public ActionCallback navigate() {
        return this.a().navigate();
    }

    @NotNull
    private Library b() {
        InvocationHandler invocationHandler = Proxy.isProxyClass(this.a.getClass()) ? Proxy.getInvocationHandler(this.a) : null;
        Library library = invocationHandler instanceof ModuleEditor.ProxyDelegateAccessor ? (Library)((ModuleEditor.ProxyDelegateAccessor)((Object)invocationHandler)).getDelegate() : this.a;
        Library library2 = library instanceof LibraryImpl ? ((LibraryImpl)library).getSource() : null;
        Library library3 = library2 != null ? library2 : this.a;
        if (library3 == null) {
            LibraryProjectStructureElement.b(4);
        }
        return library3;
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this.b());
    }

    @Override
    public boolean shouldShowWarningIfUnused() {
        long l2 = b ^ 0x6D7CC1BFAD4EL;
        LibraryTable libraryTable = this.a.getTable();
        if (libraryTable == null) {
            return false;
        }
        return "project".equals(libraryTable.getTableLevel());
    }

    @Override
    public ProjectStructureProblemDescription createUnusedElementWarning() {
        long l2 = b ^ 0x6C2727B14AD4L;
        List<ConfigurationErrorQuickFix> list2 = Arrays.asList(new AddLibraryToDependenciesFix(this, null), new RemoveLibraryFix(this, null), new RemoveAllUnusedLibrariesFix(this, null));
        String string = StringUtil.escapeXml((String)this.a.getName());
        String string2 = "<a href='http://library/" + string + "'>" + string + "</a>";
        return new ProjectStructureProblemDescription(XmlStringUtil.wrapInHtml((CharSequence)("Library " + string2 + " is not used")), null, this.a(), ProjectStructureProblemType.unused("unused-library"), ProjectStructureProblemDescription.ProblemLevel.PROJECT, list2, false);
    }

    @Override
    public String getPresentableName() {
        return this.a.getName();
    }

    @Override
    public String getTypeName() {
        long l2 = b ^ 0x7713C3C71BE8L;
        return "Library";
    }

    @Override
    public String getId() {
        long l2 = b ^ 0x514069913FABL;
        return "library:" + this.a.getTable().getTableLevel() + ":" + this.a.getName();
    }

    private static /* synthetic */ void b(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = b ^ 0x2E8054A0226CL;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 3: 
            case 4: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/projectRoot/daemon/LibraryProjectStructureElement";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/projectRoot/daemon/LibraryProjectStructureElement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createPlace";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceOrThis";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "reportInvalidRoots";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class RemoveAllUnusedLibrariesFix
    extends ConfigurationErrorQuickFix {
        final /* synthetic */ LibraryProjectStructureElement this$0;
        private static final long b = lb.a(-5958531586251704682L, -1858251969856563476L, MethodHandles.lookup().lookupClass()).a(144024352811387L);

        private RemoveAllUnusedLibrariesFix(LibraryProjectStructureElement libraryProjectStructureElement) {
            long l2 = b ^ 0x3C1AC6FB5CBDL;
            this.this$0 = libraryProjectStructureElement;
            super("Remove All Unused Libraries");
        }

        @Override
        public void performFix() {
            long l2 = b ^ 0x686043CA441CL;
            BaseLibrariesConfigurable baseLibrariesConfigurable = BaseLibrariesConfigurable.getInstance(this.this$0.myContext.getProject(), "project");
            Library[] libraryArray = baseLibrariesConfigurable.getModelProvider().getModifiableModel().getLibraries();
            ArrayList<LibraryProjectStructureElement> arrayList = new ArrayList<LibraryProjectStructureElement>();
            for (Library library : libraryArray) {
                LibraryProjectStructureElement libraryProjectStructureElement = new LibraryProjectStructureElement(this.this$0.myContext, library);
                if (!this.this$0.myContext.getDaemonAnalyzer().getUsages(libraryProjectStructureElement).isEmpty()) continue;
                arrayList.add(libraryProjectStructureElement);
            }
            baseLibrariesConfigurable.removeLibraries(arrayList);
        }

        /* synthetic */ RemoveAllUnusedLibrariesFix(LibraryProjectStructureElement x0, a x1) {
            this(x0);
        }
    }

    private class RemoveLibraryFix
    extends ConfigurationErrorQuickFix {
        final /* synthetic */ LibraryProjectStructureElement this$0;
        private static final long b = lb.a(3194314719621920913L, 6862439420393830043L, MethodHandles.lookup().lookupClass()).a(143314781768572L);

        private RemoveLibraryFix(LibraryProjectStructureElement libraryProjectStructureElement) {
            long l2 = b ^ 0x4CF441356DDAL;
            this.this$0 = libraryProjectStructureElement;
            super("Remove Library");
        }

        @Override
        public void performFix() {
            BaseLibrariesConfigurable.getInstance(this.this$0.myContext.getProject(), this.this$0.a.getTable().getTableLevel()).removeLibrary(this.this$0);
        }

        /* synthetic */ RemoveLibraryFix(LibraryProjectStructureElement x0, a x1) {
            this(x0);
        }
    }

    private class AddLibraryToDependenciesFix
    extends ConfigurationErrorQuickFix {
        final /* synthetic */ LibraryProjectStructureElement this$0;
        private static final long b = lb.a(7700813907425923452L, -332018986777275209L, MethodHandles.lookup().lookupClass()).a(158754890851921L);

        private AddLibraryToDependenciesFix(LibraryProjectStructureElement libraryProjectStructureElement) {
            long l2 = b ^ 0x138EE89094E7L;
            this.this$0 = libraryProjectStructureElement;
            super("Add to Dependencies...");
        }

        @Override
        public void performFix() {
            LibraryEditingUtil.showDialogAndAddLibraryToDependencies(this.this$0.a, this.this$0.myContext.getProject(), false);
        }

        /* synthetic */ AddLibraryToDependenciesFix(LibraryProjectStructureElement x0, a x1) {
            this(x0);
        }
    }

    private class RemoveInvalidRootsQuickFix
    extends ConfigurationErrorQuickFix {
        private final Library d;
        private final OrderRootType b;
        private final List<String> c;
        final /* synthetic */ LibraryProjectStructureElement this$0;
        private static final long e = lb.a(7725339598131271744L, -1695600138564238711L, MethodHandles.lookup().lookupClass()).a(278652093131065L);

        RemoveInvalidRootsQuickFix(LibraryProjectStructureElement libraryProjectStructureElement, Library library, OrderRootType type, List<String> invalidUrls) {
            long l2 = e ^ 0x4BA9682AB12FL;
            this.this$0 = libraryProjectStructureElement;
            super("Remove invalid " + StringUtil.pluralize((String)"root", (int)invalidUrls.size()));
            this.d = library;
            this.b = type;
            this.c = invalidUrls;
        }

        @Override
        public void performFix() {
            LibraryTable.ModifiableModel modifiableModel = this.this$0.myContext.getModifiableLibraryTable(this.d.getTable());
            if (modifiableModel instanceof LibrariesModifiableModel) {
                for (String string : this.c) {
                    ExistingLibraryEditor existingLibraryEditor = ((LibrariesModifiableModel)modifiableModel).getLibraryEditor(this.d);
                    existingLibraryEditor.removeRoot(string, this.b);
                }
                this.this$0.myContext.getDaemonAnalyzer().queueUpdate(this.this$0);
                ProjectStructureConfigurable projectStructureConfigurable = ProjectStructureConfigurable.getInstance(this.this$0.myContext.getProject());
                this.this$0.navigate().doWhenDone(() -> {
                    NamedConfigurable namedConfigurable = projectStructureConfigurable.getConfigurableFor(this.d).getSelectedConfigurable();
                    if (namedConfigurable instanceof LibraryConfigurable) {
                        ((LibraryConfigurable)namedConfigurable).updateComponent();
                    }
                });
            }
        }
    }
}

