/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot;

import b.a.lb;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectStructureElementConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureDaemonAnalyzer;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemType;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemsHolderImpl;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.lang.invoke.MethodHandles;
import javax.swing.Icon;
import javax.swing.JTree;

class ProjectStructureElementRenderer
extends ColoredTreeCellRenderer {
    private final StructureConfigurableContext a;
    private static final long b = lb.a(-5816304454468138805L, 5593731934772035928L, MethodHandles.lookup().lookupClass()).a(232901185034252L);

    ProjectStructureElementRenderer(StructureConfigurableContext context) {
        this.a = context;
    }

    public void customizeCellRenderer(JTree tree2, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        long l2 = b ^ 0x17E514535276L;
        if (value instanceof MasterDetailsComponent.MyNode) {
            ProjectStructureElement projectStructureElement;
            MasterDetailsComponent.MyNode myNode = (MasterDetailsComponent.MyNode)value;
            NamedConfigurable namedConfigurable = myNode.getConfigurable();
            if (namedConfigurable == null) {
                return;
            }
            String string = myNode.getDisplayName();
            Icon icon = namedConfigurable.getIcon(expanded);
            this.setIcon(icon);
            this.setToolTipText(null);
            this.setFont(UIUtil.getTreeFont());
            SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
            if (myNode.isDisplayInBold()) {
                simpleTextAttributes = SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES;
            } else if (namedConfigurable instanceof ProjectStructureElementConfigurable && (projectStructureElement = ((ProjectStructureElementConfigurable)namedConfigurable).getProjectStructureElement()) != null) {
                ProjectStructureDaemonAnalyzer projectStructureDaemonAnalyzer = this.a.getDaemonAnalyzer();
                ProjectStructureProblemsHolderImpl projectStructureProblemsHolderImpl = projectStructureDaemonAnalyzer.getProblemsHolder(projectStructureElement);
                if (projectStructureProblemsHolderImpl != null && projectStructureProblemsHolderImpl.containsProblems()) {
                    int n2;
                    boolean bl2 = projectStructureProblemsHolderImpl.containsProblems(ProjectStructureProblemType.Severity.UNUSED);
                    boolean bl3 = projectStructureProblemsHolderImpl.containsProblems(ProjectStructureProblemType.Severity.WARNING);
                    boolean bl4 = projectStructureProblemsHolderImpl.containsProblems(ProjectStructureProblemType.Severity.ERROR);
                    Color color = bl2 ? UIUtil.getInactiveTextColor() : null;
                    int n3 = n2 = bl3 || bl4 ? 8 : -1;
                    JBColor jBColor = bl4 ? JBColor.RED : (bl3 ? JBColor.GRAY : null);
                    simpleTextAttributes = simpleTextAttributes.derive(n2, color, null, (Color)jBColor);
                    this.setToolTipText(projectStructureProblemsHolderImpl.composeTooltipMessage());
                }
                this.append(string, simpleTextAttributes);
                String string2 = projectStructureElement.getDescription();
                if (string2 != null) {
                    this.append(" (" + string2 + ")", SimpleTextAttributes.GRAY_ATTRIBUTES, false);
                }
                return;
            }
            this.append(string, simpleTextAttributes);
        }
    }
}

